/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.admin;

import com.wego168.distribute.domain.DistributerRegistField;
import com.wego168.distribute.enums.FieldTypeEnum;
import com.wego168.distribute.model.response.DistributerRegistFieldAdminListResponse;
import com.wego168.distribute.service.impl.DistributerRegistFieldService;
import com.wego168.domain.BaseDomain;
import com.wego168.exception.WegoException;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminDistributerRegistFieldController")
public class DistributerRegistFieldController
extends SimpleController {
    @Autowired
    private DistributerRegistFieldService service;

    @GetMapping(value={"/api/admin/v1/distributer-regist-field/list"})
    public RestResponse selectList() {
        String appId = this.getAppId();
        List<DistributerRegistField> list = this.service.selectList(appId);
        return RestResponse.success(this.toResponseList(list));
    }

    @PostMapping(value={"/api/admin/v1/distributer-regist-field/insert"})
    public RestResponse insert(String name, String field, @RequestParam(required=false, name="maxLength") String maxLengthString, Boolean notBlank, String type, @RequestParam(required=false, name="sort") String sortString) {
        try {
            String method = "insert";
            String minLengthString = "0";
            DistributerRegistField fieldDb = this.checkInput(name, field, maxLengthString, minLengthString, notBlank, type, sortString, method);
            this.service.insert((Object)fieldDb);
            return RestResponse.success((Object)((Object)fieldDb), (String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/distributer-regist-field/delete"})
    public RestResponse delete(String id) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"id", (int)32);
            DistributerRegistField field = (DistributerRegistField)((Object)this.service.selectById(id));
            Checker.checkCondition((field == null ? 1 : 0) != 0, (String)"\u8be5\u5b57\u6bb5\u4e0d\u5b58\u5728");
            boolean system = field.getSystem();
            Checker.checkCondition((boolean)system, (String)"\u7cfb\u7edf\u81ea\u5e26\u6570\u636e\u4e0d\u53ef\u5220\u9664");
            this.service.updateDelete(id);
            return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/distributer-regist-field/update"})
    public RestResponse update(String name, String field, @RequestParam(required=false, name="maxLength") String maxLengthString, Boolean notBlank, String type, @RequestParam(required=false, name="sort") String sortString, String id) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"id", (int)32);
            String minLengthString = "0";
            DistributerRegistField param = this.checkInput(name, field, maxLengthString, minLengthString, notBlank, type, sortString, "update");
            param.setId(id);
            DistributerRegistField fieldDb = (DistributerRegistField)((Object)this.service.selectById(id));
            Checker.checkCondition((fieldDb == null ? 1 : 0) != 0, (String)"\u8be5\u5b57\u6bb5\u4e0d\u5b58\u5728");
            boolean system = fieldDb.getSystem();
            if (system) {
                String typeDb = fieldDb.getType();
                Checker.checkCondition((!StringUtil.equals((String)typeDb, (String)type) ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u81ea\u5e26\u6570\u636e\u4e0d\u53ef\u4fee\u6539\u7c7b\u578b");
                boolean notBlankDb = fieldDb.getNotBlank();
                Checker.checkCondition((boolean)(notBlankDb ^ notBlank), (String)"\u7cfb\u7edf\u81ea\u5e26\u6570\u636e\u4e0d\u53ef\u4fee\u6539\u5fc5\u586b");
            }
            this.service.updateSelective((Object)param);
            return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    private DistributerRegistField checkInput(String name, String fieldCode, String maxLengthString, String minLengthString, Boolean notBlank, String type, String sortString, String method) {
        Checker.checkBlankAndLength((String)name, (String)"\u5b57\u6bb5\u540d\u79f0", (int)32);
        Checker.checkBlankOrLength((String)fieldCode, (String)"\u5b57\u6bb5\u4ee3\u7801", (int)64);
        if (StringUtil.isBlank((String)maxLengthString)) {
            maxLengthString = "0";
        }
        if (StringUtil.isBlank((String)minLengthString)) {
            minLengthString = "0";
        }
        if (StringUtil.isBlank((String)sortString)) {
            sortString = "0";
        }
        int maxLength = Checker.checkStringIsUnsignedInteger((String)maxLengthString, (String)"\u6700\u5927\u586b\u5199\u957f\u5ea6");
        int minLength = Checker.checkStringIsUnsignedInteger((String)minLengthString, (String)"\u6700\u5c0f\u586b\u5199\u957f\u5ea6");
        int sort = Checker.checkStringIsUnsignedInteger((String)sortString, (String)"\u5e8f\u53f7");
        Checker.checkCondition((minLength > maxLength ? 1 : 0) != 0, (String)"\u6700\u5c0f\u586b\u5199\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u6700\u5927\u586b\u5199\u957f\u5ea6");
        Checker.checkNull((Object)notBlank, (String)"\u662f\u5426\u5fc5\u586b");
        Checker.checkCondition((!FieldTypeEnum.isValid(type) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u7c7b\u578b");
        String appId = this.getAppId();
        DistributerRegistField field = new DistributerRegistField();
        if (StringUtil.equals((String)method, (String)"insert")) {
            BaseDomainUtil.initBaseDomain((BaseDomain)field, (String)appId);
            field.setField(fieldCode);
            field.setMaxLength(maxLength);
            field.setMinLength(minLength);
            field.setName(name);
            field.setNotBlank(notBlank);
            field.setSort(sort);
            field.setSystem(false);
            field.setType(type);
        } else {
            field.setMaxLength(maxLength);
            field.setMinLength(minLength);
            field.setName(name);
            field.setSort(sort);
            field.setUpdateTime(new Date());
        }
        return field;
    }

    private List<DistributerRegistFieldAdminListResponse> toResponseList(List<DistributerRegistField> list) {
        ArrayList<DistributerRegistFieldAdminListResponse> responseList = new ArrayList<DistributerRegistFieldAdminListResponse>(list.size());
        for (DistributerRegistField fieldDb : list) {
            responseList.add(new DistributerRegistFieldAdminListResponse(fieldDb));
        }
        return responseList;
    }
}

