/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.admin;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.distribute.domain.Withdraw;
import com.wego168.distribute.enums.TransferWayEnum;
import com.wego168.distribute.enums.WithdrawAccountTypeEnum;
import com.wego168.distribute.enums.WithdrawAuditStatusEnum;
import com.wego168.distribute.enums.WithdrawStatusEnum;
import com.wego168.distribute.enums.WithdrawTransferStatusEnum;
import com.wego168.distribute.model.response.WithdrawAdminPageResponse;
import com.wego168.distribute.service.impl.WithdrawService;
import com.wego168.distribute.task.WithdrawTask;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.validation.constraints.NotBlankOrLength;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import com.wego168.wxpay.domain.WxpayConfig;
import com.wego168.wxpay.model.response.JoinTransferResponse;
import com.wego168.wxpay.service.WxpayConfigService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController(value="adminWithdrawController")
public class WithdrawController
extends SimpleController {
    @Autowired
    private WithdrawTask withdrawTask;
    @Autowired
    private WithdrawService service;
    @Autowired
    private WxpayConfigService wxpayConfigService;

    @GetMapping(value={"/api/admin/v1/withdraw/page"})
    public RestResponse selectPage(String name, String mobile, String status, String auditStatus, String transferStatus, HttpServletRequest request) {
        String appId = this.getAppId();
        Page page = this.buildPage(request);
        page.eq("appId", (Object)appId);
        if (StringUtil.isNotBlank((String)name)) {
            page.like("name", (Object)name);
        }
        if (StringUtil.isNotBlank((String)mobile)) {
            page.like("mobile", (Object)mobile);
        }
        if (StringUtil.isNotBlank((String)status)) {
            page.eq("status", (Object)status);
        }
        if (StringUtil.isNotBlank((String)auditStatus)) {
            page.eq("auditStatus", (Object)auditStatus);
        }
        if (StringUtil.isNotBlank((String)transferStatus)) {
            page.eq("transferStatus", (Object)transferStatus);
        }
        page.orderBy("createTime DESC");
        List list = this.service.selectList((JpaCriteria)page, WithdrawAdminPageResponse.class);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/api/admin/v1/withdraw/bank-transfer"})
    public RestResponse bankTransfer(@NotBlankAndLength String id) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"\u63d0\u73b0\u8bb0\u5f55", (int)32);
            Withdraw withdraw = (Withdraw)((Object)this.service.selectById(id));
            this.ensureWithdrawCanTransfer(withdraw);
            String accountType = withdraw.getAccountType();
            Checker.checkCondition((!StringUtil.equals((String)accountType, (String)WithdrawAccountTypeEnum.PRIVATE_BANK.value()) && !StringUtil.equals((String)accountType, (String)WithdrawAccountTypeEnum.PUBLIC_BANK.value()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u94f6\u884c\u5361\u63d0\u73b0\u624d\u53ef\u6253\u6b3e");
            String merchantId = withdraw.getTransferMerchantId();
            Integer merchantType = withdraw.getTransferMerchantType();
            String appId = withdraw.getAppId();
            WxpayConfig payConfig = null;
            payConfig = StringUtil.isNotBlank((String)merchantId) ? this.wxpayConfigService.selectByAppIdAndMerchant(appId, merchantId, merchantType.intValue()) : this.wxpayConfigService.selectMostSuitableOne(appId, merchantType.intValue());
            Checker.checkCondition((payConfig == null ? 1 : 0) != 0, (String)"\u6253\u6b3e\u5546\u6237\u672a\u914d\u7f6e\uff0c\u8bf7\u5c1d\u8bd5\u4eba\u5de5\u8f6c\u8d26");
            JoinTransferResponse response = this.service.joinTransfer(payConfig, withdraw);
            if (response.isSuccess()) {
                return RestResponse.success((String)"\u6253\u6b3e\u7533\u8bf7\u6210\u529f");
            }
            return RestResponse.success((String)("\u6253\u6b3e\u7533\u8bf7\u5931\u8d25\uff1a" + response.getErrorDesc()));
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/withdraw/manual-transfer"})
    public RestResponse manualTransfer(@NotBlankAndLength String id, @NotBlankOrLength(min=1, max=64, message="\u8f6c\u8d26\u5355\u53f7\u7684\u957f\u5ea6\u5fc5\u987b\u57281~64\u5b57\u7b26\u4e4b\u95f4") String transactionNumber, @NotBlankOrLength(min=1, max=256, message="\u8f6c\u8d26\u51ed\u8bc1\u7684\u957f\u5ea6\u5fc5\u987b\u57281~64\u5b57\u7b26\u4e4b\u95f4") String transferTicket) {
        try {
            Withdraw withdraw = (Withdraw)((Object)this.service.selectById(id));
            this.ensureWithdrawCanTransfer(withdraw);
            String transferWay = withdraw.getTransferWay();
            Checker.checkCondition((!StringUtil.equals((String)transferWay, (String)TransferWayEnum.MANUAL.value()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u4eba\u5de5\u8f6c\u8d26\u7c7b\u578b\u63d0\u73b0\u624d\u53ef\u64cd\u4f5c");
            String appId = withdraw.getAppId();
            this.service.manualTransfer(id, appId, transactionNumber, transferTicket);
            return RestResponse.success((String)"\u6253\u6b3e\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/admin/v1/withdraw/query"})
    public RestResponse query(String id) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"\u63d0\u73b0\u8bb0\u5f55", (int)32);
            Withdraw withdraw = (Withdraw)((Object)this.service.selectById(id));
            String merchantId = withdraw.getTransferMerchantId();
            Integer merchantType = withdraw.getTransferMerchantType();
            String appId = withdraw.getAppId();
            WxpayConfig payConfig = null;
            payConfig = StringUtil.isNotBlank((String)merchantId) ? this.wxpayConfigService.selectByAppIdAndMerchant(appId, merchantId, merchantType.intValue()) : this.wxpayConfigService.selectMostSuitableOne(appId, merchantType.intValue());
            Checker.checkCondition((payConfig == null ? 1 : 0) != 0, (String)"\u6253\u6b3e\u5546\u6237\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u67e5\u8be2");
            this.withdrawTask.queryAndUpdateStatus(payConfig, withdraw);
            return RestResponse.success((String)"\u67e5\u8be2\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    private void ensureWithdrawCanTransfer(Withdraw withdraw) {
        Checker.checkCondition((withdraw == null ? 1 : 0) != 0, (String)"\u63d0\u73b0\u8bb0\u5f55\u4e0d\u5b58\u5728");
        String status = withdraw.getStatus();
        Checker.checkCondition((boolean)StringUtil.equals((String)status, (String)WithdrawStatusEnum.FINISH.value()), (String)"\u6253\u6b3e\u5931\u8d25\uff0c\u8be5\u7b14\u63d0\u73b0\u5df2\u5b8c\u6210");
        String auditStatus = withdraw.getAuditStatus();
        Checker.checkCondition((!StringUtil.equals((String)auditStatus, (String)WithdrawAuditStatusEnum.AUDITED.value()) ? 1 : 0) != 0, (String)"\u6253\u6b3e\u5931\u8d25\uff0c\u9700\u5148\u901a\u8fc7\u5ba1\u6838");
        String transferStatus = withdraw.getStatus();
        Checker.checkCondition((boolean)StringUtil.equals((String)transferStatus, (String)WithdrawTransferStatusEnum.FINISH.value()), (String)"\u6253\u6b3e\u5931\u8d25\uff0c\u8be5\u7b14\u63d0\u73b0\u5df2\u5b8c\u6210");
        String transferWay = withdraw.getTransferWay();
        Checker.checkCondition((StringUtil.equals((String)transferStatus, (String)WithdrawTransferStatusEnum.ONGOING.value()) && StringUtil.equals((String)transferWay, (String)TransferWayEnum.AUTO.value()) ? 1 : 0) != 0, (String)"\u6253\u6b3e\u5931\u8d25\uff0c\u8be5\u7b14\u63d0\u73b0\u5df2\u5728\u6253\u6b3e\u4e2d");
    }
}

