/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.member;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.domain.DistributerCommissionConfig;
import com.wego168.distribute.domain.Withdraw;
import com.wego168.distribute.enums.WithdrawAccountTypeEnum;
import com.wego168.distribute.model.response.DistributerCommissionMemberPageResponse;
import com.wego168.distribute.service.impl.DistributerCommissionConfigService;
import com.wego168.distribute.service.impl.DistributerCommissionService;
import com.wego168.distribute.service.impl.DistributerService;
import com.wego168.exception.WegoException;
import com.wego168.member.service.impl.WalletService;
import com.wego168.member.util.SessionUtil;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.share.domain.Sharer;
import com.wego168.share.service.SharerService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import com.wego168.wx.enums.ServiceTypeEnum;
import com.wego168.wxpay.domain.WxpayConfig;
import com.wego168.wxpay.service.WxpayConfigService;
import java.text.DecimalFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="memberDistributerCommissionController")
public class DistributerCommissionController
extends SimpleController {
    @Autowired
    private DistributerService distributerService;
    @Autowired
    private SharerService sharerService;
    @Autowired
    private DistributerCommissionService service;
    @Autowired
    private DistributerCommissionConfigService distributerCommissionConfigService;
    @Autowired
    private WalletService walletService;
    @Autowired
    private WxpayConfigService wxpayConfigService;
    @Autowired
    private SimpleRedisTemplate redisTemplate;

    @GetMapping(value={"/api/v1/{identity}-commission/page"})
    public RestResponse selectPage(@PathVariable String identity, String fromOrderType, String fromOrderTitle, String status, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Page page = this.buildPage(request);
        List<DistributerCommissionMemberPageResponse> list = this.service.selectPageForMember(memberId, fromOrderType, fromOrderTitle, status, identity, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/api/v1/{identity}-commission/withdraw"})
    public RestResponse withdraw(@RequestParam(name="amount", required=false) String amountString, @RequestParam(name="serviceType", required=false) String serviceTypeString, @PathVariable String identity, String withdrawAccount, String withdrawName) {
        try {
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            if (StringUtil.isBlank((String)serviceTypeString)) {
                serviceTypeString = String.valueOf(ServiceTypeEnum.PROGRAM.id());
            }
            int serviceType = Checker.checkStringIsPositiveInteger((String)serviceTypeString, (String)"\u5e94\u7528\u7c7b\u578b");
            int amount = Checker.checkStringIsPositiveInteger((String)amountString, (String)"\u63d0\u73b0\u91d1\u989d");
            boolean identityIsValid = StringUtil.in((String)identity, (String[])new String[]{"sharer", "distributer"});
            Checker.checkCondition((!identityIsValid ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u8bf7\u6c42");
            int poundage = this.checkWithdrawAmountAndCalculatePoundage(amount);
            String merchantId = this.determineTransferMerchantId(serviceType);
            if (StringUtil.equals((String)identity, (String)"distributer")) {
                return this.distributerWithdraw(amount, poundage, memberId, withdrawAccount, withdrawName, merchantId);
            }
            return this.sharerWithdraw(amount, poundage, memberId, withdrawAccount, withdrawName, merchantId);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/{identity}-commission/calculate-withdraw-poundage"})
    public RestResponse calculateWithdrawPoundage(@RequestParam(name="amount", required=false) String amountString) {
        try {
            int amount = Checker.checkStringIsPositiveInteger((String)amountString, (String)"\u63d0\u73b0\u91d1\u989d");
            int poundage = this.checkWithdrawAmountAndCalculatePoundage(amount);
            Bootmap response = new Bootmap();
            response.put((Object)"poundage", (Object)poundage);
            response.put((Object)"amount", (Object)amount);
            return RestResponse.success((Object)response);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    private int checkWithdrawAmountAndCalculatePoundage(int amount) {
        String appId = this.getAppId();
        DistributerCommissionConfig config = this.distributerCommissionConfigService.select(appId);
        int minWithdrawAmount = config.getMinWithdrawAmount();
        DecimalFormat formatter = new DecimalFormat("######0.00");
        Checker.checkCondition((amount < minWithdrawAmount ? 1 : 0) != 0, (String)("\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u4f4e\u4e8e" + formatter.format((double)minWithdrawAmount * 0.01) + "\u5143"));
        int minPoundage = config.getMinPoundage();
        int poundageRate = config.getPoundageRate();
        Checker.checkCondition((amount < minPoundage ? 1 : 0) != 0, (String)("\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u4f4e\u4e8e" + formatter.format((double)minPoundage * 0.01) + "\u5143"));
        int poundage = (int)((double)(amount * poundageRate) * 1.0E-4);
        if (poundageRate > 0 && poundage == 0) {
            poundage = 1;
        }
        if (poundage < minPoundage) {
            poundage = minPoundage;
        }
        Checker.checkCondition((poundage >= amount ? 1 : 0) != 0, (String)"\u63d0\u73b0\u5931\u8d25\uff1a\u5546\u6237\u63d0\u73b0\u914d\u7f6e\u9519\u8bef");
        return poundage;
    }

    private RestResponse distributerWithdraw(int amount, int poundage, String memberId, String withdrawAccount, String withdrawName, String merchantId) {
        Distributer distributer = this.distributerService.selectById(memberId);
        Checker.checkCondition((distributer == null ? 1 : 0) != 0, (String)"\u672a\u6ce8\u518c\u7684\u7528\u6237");
        boolean updateWithdrawAccount = false;
        if (StringUtil.isBlank((String)withdrawAccount)) {
            withdrawAccount = distributer.getWithdrawAccount();
        } else {
            updateWithdrawAccount = true;
        }
        if (StringUtil.isBlank((String)withdrawName)) {
            withdrawName = distributer.getWithdrawName();
        } else {
            updateWithdrawAccount = true;
        }
        Checker.checkCondition((boolean)StringUtil.isBlank((String)withdrawAccount), (String)"\u8bf7\u5148\u8bbe\u7f6e\u63d0\u73b0\u8d26\u53f7");
        Checker.checkCondition((boolean)StringUtil.isBlank((String)withdrawName), (String)"\u8bf7\u5148\u8bbe\u7f6e\u59d3\u540d");
        if (updateWithdrawAccount) {
            Distributer param = new Distributer();
            param.setId(memberId);
            param.setWithdrawAccount(withdrawAccount);
            param.setWithdrawName(withdrawName);
            distributer.setWithdrawAccount(withdrawAccount);
            distributer.setWithdrawName(withdrawName);
            distributer.setWithdrawAccountType(WithdrawAccountTypeEnum.PRIVATE_BANK.value());
            this.distributerService.updateSelective((Object)param);
        }
        RestResponse response = (RestResponse)this.redisTemplate.doInLock(memberId, key -> {
            int balance = this.walletService.getWalletAmount(memberId);
            if (amount > balance) {
                return RestResponse.error((String)"\u7533\u8bf7\u5931\u8d25\uff1a\u63d0\u73b0\u91d1\u989d\u8d85\u8fc7\u53ef\u63d0\u73b0\u4f59\u989d");
            }
            Withdraw withdraw = this.service.distributerWithdraw(distributer, amount, poundage, merchantId);
            return RestResponse.success((Object)((Object)withdraw), (String)"\u63d0\u73b0\u7533\u8bf7\u6210\u529f\uff0c\u6b63\u5728\u7b49\u5f85\u5ba1\u6838");
        });
        return response;
    }

    private RestResponse sharerWithdraw(int amount, int poundage, String memberId, String withdrawAccount, String withdrawName, String merchantId) {
        Sharer sharer = (Sharer)((Object)this.sharerService.selectById(memberId));
        Checker.checkCondition((sharer == null ? 1 : 0) != 0, (String)"\u672a\u6ce8\u518c\u7684\u7528\u6237");
        boolean updateWithdrawAccount = false;
        if (StringUtil.isBlank((String)withdrawAccount)) {
            withdrawAccount = sharer.getWithdrawAccount();
        } else {
            updateWithdrawAccount = true;
        }
        if (StringUtil.isBlank((String)withdrawName)) {
            withdrawName = sharer.getWithdrawName();
        } else {
            updateWithdrawAccount = true;
        }
        Checker.checkCondition((boolean)StringUtil.isBlank((String)withdrawAccount), (String)"\u8bf7\u5148\u8bbe\u7f6e\u63d0\u73b0\u8d26\u53f7");
        Checker.checkCondition((boolean)StringUtil.isBlank((String)withdrawName), (String)"\u8bf7\u5148\u8bbe\u7f6e\u59d3\u540d");
        if (updateWithdrawAccount) {
            Sharer param = new Sharer();
            param.setId(memberId);
            param.setWithdrawAccount(withdrawAccount);
            param.setWithdrawName(withdrawName);
            param.setWithdrawAccountType(WithdrawAccountTypeEnum.PRIVATE_BANK.value());
            sharer.setWithdrawAccount(withdrawAccount);
            sharer.setWithdrawName(withdrawName);
            sharer.setWithdrawAccountType(WithdrawAccountTypeEnum.PRIVATE_BANK.value());
            this.sharerService.updateSelective((Object)param);
        }
        RestResponse response = (RestResponse)this.redisTemplate.doInLock(memberId, key -> {
            int balance = this.walletService.getWalletAmount(memberId);
            if (amount > balance) {
                return RestResponse.error((String)"\u7533\u8bf7\u5931\u8d25\uff1a\u63d0\u73b0\u91d1\u989d\u8d85\u8fc7\u53ef\u63d0\u73b0\u4f59\u989d");
            }
            Withdraw withdraw = this.service.sharerWithdraw(sharer, amount, poundage, merchantId);
            return RestResponse.success((Object)((Object)withdraw), (String)"\u63d0\u73b0\u7533\u8bf7\u6210\u529f\uff0c\u6b63\u5728\u7b49\u5f85\u5ba1\u6838");
        });
        return response;
    }

    private String determineTransferMerchantId(int serviceType) {
        String appId = this.getAppId();
        String transferMerchantId = null;
        WxpayConfig payConfig = this.wxpayConfigService.selectMostSuitableOne(appId, serviceType);
        if (payConfig != null) {
            transferMerchantId = payConfig.getMchId();
        }
        return transferMerchantId;
    }
}

