/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.member;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.distribute.component.DistributerRegistComponent;
import com.wego168.distribute.component.SharerBindComponent;
import com.wego168.distribute.domain.DistributeOpenIdChain;
import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.domain.DistributerBecomeCondition;
import com.wego168.distribute.domain.DistributerQrcode;
import com.wego168.distribute.enums.DistributerQrcodeOwnerTypeEnum;
import com.wego168.distribute.enums.DistributerQrcodeTargetTypeEnum;
import com.wego168.distribute.enums.WithdrawAccountTypeEnum;
import com.wego168.distribute.model.DistributerRegistData;
import com.wego168.distribute.model.response.DistributerCustomersWebPageResponse;
import com.wego168.distribute.model.response.DistributerFriendsWebPageResponse;
import com.wego168.distribute.service.impl.DistributeOpenIdChainService;
import com.wego168.distribute.service.impl.DistributeOpenIdLinkService;
import com.wego168.distribute.service.impl.DistributerBecomeConditionConfigService;
import com.wego168.distribute.service.impl.DistributerQrcodeService;
import com.wego168.distribute.service.impl.DistributerService;
import com.wego168.exception.WegoException;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.enums.AccountTypeEnum;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.util.SessionUtil;
import com.wego168.share.domain.DefaultPlatformSharer;
import com.wego168.share.domain.Sharer;
import com.wego168.share.service.DefaultPlatformSharerService;
import com.wego168.share.service.SharerService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController(value="memberDistributerController")
public class DistributerController
extends SimpleController {
    @Autowired
    private DistributeOpenIdLinkService distributeOpenIdLinkService;
    @Autowired
    private DistributeOpenIdChainService distributeOpenIdChainService;
    @Autowired
    @Qualifier(value="distributerService")
    private DistributerService service;
    @Autowired
    private SharerService sharerService;
    @Autowired
    private DistributerRegistComponent distributerRegistComponent;
    @Autowired
    private MemberService memberService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private DistributerBecomeConditionConfigService distributerBecomeConditionConfigService;
    @Autowired
    private DistributerService distributerService;
    @Autowired
    private DistributerQrcodeService distributerQrcodeService;
    @Autowired
    private DefaultPlatformSharerService defaultPlatformSharerService;
    @Autowired
    private SharerBindComponent sharerBindComponent;
    private Logger logger = LoggerFactory.getLogger(DistributerController.class);

    @GetMapping(value={"/api/v1.1/distributer/get"})
    public RestResponse get() {
        try {
            boolean isDistributer;
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            Distributer distributer = this.service.selectById(memberId);
            Member member = this.memberService.selectById(memberId);
            Bootmap response = new Bootmap();
            String name = null;
            boolean bl = isDistributer = distributer != null;
            if (isDistributer) {
                name = distributer.getName();
                response.put((Object)"status", (Object)distributer.getStatus());
            } else {
                name = member.getName();
            }
            response.put((Object)"name", (Object)name);
            response.put((Object)"headImage", (Object)member.getHeadImage());
            response.put((Object)"isDistributer", (Object)isDistributer);
            return RestResponse.success((Object)response);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/v1.1/distributer/regist"})
    public RestResponse registDistributer(@RequestBody Map<String, String> registrationData) {
        try {
            String appId = this.getAppId();
            String openId = SessionUtil.getOpenIdIfAbsentToThrow();
            String unionId = null;
            String memberId = this.distributerService.ensureMemberAndAccountWhenRegist(new DistributerRegistData(), openId, unionId, appId);
            Distributer distributer = this.service.selectById(memberId);
            Checker.checkCondition((distributer != null ? 1 : 0) != 0, (String)"\u60a8\u5df2\u7ecf\u6ce8\u518c\u8fc7\u4e86");
            DistributerBecomeCondition condition = this.distributerBecomeConditionConfigService.selectConfig(appId).get(0);
            Member member = this.memberService.selectById(memberId);
            return this.distributerRegistComponent.registByCondition(registrationData, member, openId, condition);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/v1/distributer/scan-bind", "/api/v1/sharer/scan-bind"})
    public RestResponse scanAndBindDistributer(String scene) {
        try {
            Checker.checkBlankAndLength((String)scene, (String)"\u573a\u666f\u503c", (int)32);
            String appId = this.getAppId();
            DistributerQrcode qrcode = this.distributerQrcodeService.selectByScene(scene, appId);
            this.logger.error("bind,scene:{},appid:{}", (Object)scene, (Object)appId);
            Checker.checkCondition((qrcode == null ? 1 : 0) != 0, (String)"\u8be5\u4e8c\u7ef4\u7801\u4e0d\u5b58\u5728");
            String upperOpenId = null;
            String url = qrcode.getUrl();
            String targetType = qrcode.getTargetType();
            if (StringUtil.equals((String)targetType, (String)DistributerQrcodeTargetTypeEnum.DISTRIBUTER.value()) || StringUtil.equals((String)targetType, (String)DistributerQrcodeTargetTypeEnum.SHARER.value())) {
                upperOpenId = qrcode.getTargetId();
            } else {
                String memberId = qrcode.getMemberId();
                MemberAccount miniProgramAccount = this.memberAccountService.selectProgramAccount(memberId);
                Checker.checkCondition((miniProgramAccount == null ? 1 : 0) != 0, (String)"\u8be5\u7528\u6237\u672a\u6ce8\u518c\uff0c\u7ed1\u5b9a\u5931\u8d25");
                upperOpenId = miniProgramAccount.getUsername();
            }
            String ownerType = qrcode.getOwnerType();
            if (StringUtil.equals((String)ownerType, (String)DistributerQrcodeOwnerTypeEnum.DISTRIBUTER.value())) {
                this.logger.error("bind distrbuter,upper openid:{}", (Object)upperOpenId);
                return this.bindDistributer(upperOpenId, url);
            }
            this.logger.error("bind sharer,upper openid:{}", (Object)upperOpenId);
            return this.bindSharer(upperOpenId, url);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/v1/sharer/bind"})
    public RestResponse bind(String openId, String url) {
        try {
            return this.bindSharer(openId, url);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/v1/sharer/bind-default"})
    public RestResponse bindDefaultSharer() {
        try {
            DefaultPlatformSharer defaultPlatformSharer = this.defaultPlatformSharerService.selectByAppId(super.getAppId());
            if (defaultPlatformSharer == null) {
                return RestResponse.success((String)"\u4ec0\u4e48\u4e5f\u6ca1\u505a\uff1a\u9ed8\u8ba4\u5e73\u53f0\u63a8\u5e7f\u8005\u672a\u914d\u7f6e");
            }
            String openId = defaultPlatformSharer.getSharerOpenId();
            return this.bindSharer(openId, "");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/distributer/friends"})
    public RestResponse getFriends(String appellation, Boolean showCommission, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        String openId = this.distributerRegistComponent.ensureOpenId(request);
        Page page = this.buildPage(request);
        showCommission = showCommission == null ? true : showCommission;
        int accountType = AccountTypeEnum.PROGRAM.value();
        List<DistributerFriendsWebPageResponse> friends = this.distributeOpenIdChainService.selectFriendsPage(appellation, openId, memberId, showCommission, accountType, page);
        page.setList(friends);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1/distributer/customers"})
    public RestResponse getCustomers(String appellation, Boolean showCommission, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        String openId = this.distributerRegistComponent.ensureOpenId(request);
        Page page = this.buildPage(request);
        showCommission = showCommission == null ? true : showCommission;
        int accountType = AccountTypeEnum.PROGRAM.value();
        List<DistributerCustomersWebPageResponse> list = this.distributeOpenIdChainService.selectCustomersPage(appellation, openId, memberId, showCommission, accountType, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/api/v1/{identity}/update"})
    public RestResponse update(String name, String headImage, @PathVariable String identity) {
        try {
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            Checker.checkBlankOrLength((String)name, (String)"\u59d3\u540d", (int)16);
            Checker.checkBlankOrLength((String)headImage, (String)"\u5934\u50cf", (int)256);
            boolean identityIsValid = StringUtil.in((String)identity, (String[])new String[]{"sharer", "distributer"});
            Checker.checkCondition((!identityIsValid ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u8bf7\u6c42");
            if (StringUtil.equals((String)identity, (String)"sharer")) {
                Sharer sharer = new Sharer();
                sharer.setId(memberId);
                sharer.setUpdateTime(new Date());
                if (StringUtil.isNotBlank((String)name)) {
                    sharer.setName(name);
                }
                this.sharerService.updateSelective((Object)sharer);
            } else {
                Distributer distributer = new Distributer();
                distributer.setId(memberId);
                distributer.setUpdateTime(new Date());
                distributer.setName(name);
                if (StringUtil.isNotBlank((String)name)) {
                    distributer.setName(name);
                }
                this.service.updateSelective((Object)distributer);
            }
            Member member = new Member();
            member.setId(memberId);
            member.setHeadImage(headImage);
            member.setUpdateTime(new Date());
            this.memberService.updateSelective((Object)member);
            return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/distributer/get-withdraw-account"})
    public RestResponse getWithdrawAccount() {
        try {
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            Distributer distributer = this.service.selectById(memberId);
            Checker.checkCondition((distributer == null ? 1 : 0) != 0, (String)"\u672a\u6ce8\u518c\u7684\u7528\u6237");
            String withdrawAccount = distributer.getWithdrawAccount();
            String withdrawName = distributer.getWithdrawName();
            Bootmap response = new Bootmap();
            response.put((Object)"withdrawAccount", (Object)withdrawAccount);
            response.put((Object)"withdrawName", (Object)withdrawName);
            response.put((Object)"withdrawAccountType", (Object)distributer.getWithdrawAccountType());
            return RestResponse.success((Object)response, (String)"ok");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/v1/distributer/update-withdraw-account"})
    public RestResponse updateWithdrawAccount(String withdrawAccount, String withdrawName) {
        try {
            Checker.checkBlankAndLength((String)withdrawAccount, (String)"\u63d0\u73b0\u8d26\u53f7", (int)32);
            Checker.checkBlankAndLength((String)withdrawName, (String)"\u59d3\u540d", (int)32);
            String withdrawAccountType = WithdrawAccountTypeEnum.PRIVATE_BANK.value();
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            Distributer param = new Distributer();
            param.setId(memberId);
            param.setWithdrawAccount(withdrawAccount);
            param.setWithdrawAccountType(withdrawAccountType);
            param.setWithdrawName(withdrawName);
            this.service.updateSelective((Object)param);
            return RestResponse.success(null, (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    private RestResponse bindDistributer(String upperOpenId, String url) {
        try {
            Checker.checkBlank((String)upperOpenId, (String)"\u5206\u4eab\u8005");
            String openId = SessionUtil.getOpenIdIfAbsentToThrow();
            String appId = this.getAppId();
            this.distributeOpenIdLinkService.insert(this.distributeOpenIdLinkService.create(openId, upperOpenId, url));
            if (StringUtil.equals((String)openId, (String)upperOpenId)) {
                this.logger.error("\u9500\u552e\u5458\u7ed1\u5b9a\u5931\u8d25\uff0c\u5206\u4eab\u8005\u548c\u5f53\u524d\u7528\u6237openid\u76f8\u540c\uff1a{}", (Object)openId);
                return RestResponse.success((Object)"\u7ed1\u5b9a\u9500\u552e\u5458\u5931\u8d25\uff0c\u5206\u4eab\u8005\u548c\u5f53\u524d\u7528\u6237openid\u76f8\u540c", (String)"ok");
            }
            String existUpperOpenId = this.distributeOpenIdChainService.getRealUpperOpenId(openId);
            if (StringUtil.isNotBlank((String)existUpperOpenId)) {
                this.logger.error("\u9500\u552e\u5458\u7ed1\u5b9a\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\uff1a{}\u5df2\u5b58\u5728\u9500\u552e\u5458\uff1a{},\u5206\u4eab\u8005\uff1a{}", new Object[]{openId, existUpperOpenId, upperOpenId});
                return RestResponse.success((Object)"\u7ed1\u5b9a\u9500\u552e\u5458\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u9500\u552e", (String)"ok");
            }
            boolean audited = this.distributeOpenIdChainService.isAuditedDistributerId(upperOpenId, appId);
            if (!audited) {
                String realUpperOpenId = this.distributeOpenIdChainService.getRealUpperOpenId(upperOpenId);
                if (StringUtil.isBlank((String)realUpperOpenId)) {
                    this.logger.error("\u9500\u552e\u5458\u7ed1\u5b9a\u5931\u8d25\uff0c\u5206\u4eab\u8005\uff1a{}\u4e0d\u662f\u9500\u552e\u5458\uff0c\u4e5f\u4e0d\u5b58\u5728\u4e0a\u7ea7\u9500\u552e\u5458\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)upperOpenId, (Object)openId);
                    return RestResponse.success((Object)"\u7ed1\u5b9a\u9500\u552e\u5458\u5931\u8d25\uff0c\u5206\u4eab\u8005\u4e0d\u662f\u9500\u552e\u5458", (String)"ok");
                }
                this.logger.error("\u9500\u552e\u5458\u7ed1\u5b9a\u5931\u8d25\uff0c\u5206\u4eab\u8005\uff1a{}\u4e0d\u662f\u9500\u552e\u5458\uff0c\u5b58\u5728\u4e0a\u7ea7\u9500\u552e\u5458\uff1a{}\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", new Object[]{upperOpenId, realUpperOpenId, openId});
                upperOpenId = realUpperOpenId;
            }
            List<DistributeOpenIdChain> upperChainList = this.distributeOpenIdChainService.listUpperChainsExcludeSystemVirtualChain(upperOpenId);
            DistributeOpenIdChain level1Chain = this.distributeOpenIdChainService.create(openId, upperOpenId, 0, true, url);
            upperChainList.add(0, level1Chain);
            ArrayList<DistributeOpenIdChain> chainList = new ArrayList<DistributeOpenIdChain>();
            int maxLevel = 3;
            int index = 0;
            for (DistributeOpenIdChain distributeOpenIdChain : upperChainList) {
                int level = distributeOpenIdChain.getUpperDistributerLevel() + 1;
                if (level > maxLevel) break;
                boolean isRoot = index + 1 == upperChainList.size() || index + 1 >= maxLevel;
                chainList.add(this.distributeOpenIdChainService.create(openId, distributeOpenIdChain.getUpperOpenId(), level, isRoot, url));
                ++index;
            }
            this.distributeOpenIdChainService.insertBatch(chainList);
            return RestResponse.success((Object)"\u7ed1\u5b9a\u9500\u552e\u5458\u6210\u529f", (String)"ok");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    private RestResponse bindSharer(String upperOpenId, String url) {
        try {
            Checker.checkBlank((String)upperOpenId, (String)"\u5206\u4eab\u8005");
            String openId = SessionUtil.getOpenIdIfAbsentToThrow();
            String appId = this.getAppId();
            return this.sharerBindComponent.bindSharer(openId, upperOpenId, url, appId);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

