/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.member;

import com.simple.mybatis.Bootmap;
import com.wego168.base.domain.FileServer;
import com.wego168.base.domain.Storable;
import com.wego168.base.service.FileServerService;
import com.wego168.base.service.StorableService;
import com.wego168.distribute.component.DistributerQrcodeComponent;
import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.domain.DistributerQrcode;
import com.wego168.distribute.enums.DistributerQrcodeOwnerTypeEnum;
import com.wego168.distribute.enums.DistributerQrcodeTargetTypeEnum;
import com.wego168.distribute.model.response.DistributerQrcodeMemberGetResponse;
import com.wego168.distribute.service.impl.DistributerQrcodeService;
import com.wego168.distribute.service.impl.DistributerService;
import com.wego168.exception.WegoException;
import com.wego168.member.domain.Member;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.util.SessionUtil;
import com.wego168.share.component.SharerRegistComponent;
import com.wego168.share.domain.Sharer;
import com.wego168.share.domain.SharerBecomeCondition;
import com.wego168.share.enums.SharerBecomeConditionEnum;
import com.wego168.share.model.SharerRegistData;
import com.wego168.share.service.SharerBecomeConditionConfigService;
import com.wego168.share.service.SharerService;
import com.wego168.util.Checker;
import com.wego168.util.IntegerUtil;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.response.StatusCode;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="memberDistributerQrcodeController")
public class DistributerQrcodeController
extends SimpleController {
    @Autowired
    private StorableService storableService;
    @Autowired
    private FileServerService fileServerService;
    @Autowired
    private DistributerService distributerService;
    @Autowired
    private DistributerQrcodeService distributerQrcodeService;
    @Autowired
    private DistributerQrcodeComponent distributerQrcodeComponent;
    @Autowired
    private SharerService sharerService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private SharerBecomeConditionConfigService sharerBecomeConditionConfigService;
    @Autowired
    private SharerRegistComponent sharerRegistComponent;

    @GetMapping(value={"/api/v1/distributer-qrcode/get"})
    public RestResponse getDistributerQrcode(String page) {
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        String targetType = DistributerQrcodeTargetTypeEnum.DISTRIBUTER.value();
        String targetId = openId;
        String ownerType = DistributerQrcodeOwnerTypeEnum.DISTRIBUTER.value();
        int showStyle = 1;
        String targetParam = null;
        return this.getQrcode(memberId, ownerType, targetType, targetId, page, showStyle, targetParam);
    }

    @GetMapping(value={"/api/v1/sharer-qrcode/get"})
    public RestResponse getSharerQrcode(String page) {
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        String targetType = DistributerQrcodeTargetTypeEnum.SHARER.value();
        String targetId = openId;
        String ownerType = DistributerQrcodeOwnerTypeEnum.SHARER.value();
        int showStyle = 1;
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        String targetParam = null;
        return this.getQrcode(memberId, ownerType, targetType, targetId, page, showStyle, targetParam);
    }

    @GetMapping(value={"/api/v1/distributer-qrcode/scan", "/api/v1/sharer-qrcode/scan"})
    public RestResponse scan(String scene) {
        try {
            Checker.checkBlankAndLength((String)scene, (String)"\u5c0f\u7a0b\u5e8f\u7801\u573a\u666f\u503c", (int)32);
            String appId = this.getAppId();
            DistributerQrcode qrcode = this.distributerQrcodeService.selectByScene(scene, appId);
            Checker.checkCondition((qrcode == null ? 1 : 0) != 0, (String)"\u8be5\u4e8c\u7ef4\u7801\u4e0d\u5b58\u5728");
            this.storableService.assembleHost((Storable)qrcode);
            return RestResponse.success((Object)new DistributerQrcodeMemberGetResponse(qrcode));
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/distributer-qrcode/scan-owner", "/api/v1/sharer-qrcode/scan-owner"})
    public RestResponse scanOwner(String scene) {
        try {
            Sharer sharer;
            String name;
            Checker.checkBlankAndLength((String)scene, (String)"\u5c0f\u7a0b\u5e8f\u7801\u573a\u666f\u503c", (int)32);
            String appId = this.getAppId();
            DistributerQrcode qrcode = this.distributerQrcodeService.selectByScene(scene, appId);
            Checker.checkCondition((qrcode == null ? 1 : 0) != 0, (String)"\u8be5\u4e8c\u7ef4\u7801\u4e0d\u5b58\u5728");
            Bootmap response = new Bootmap();
            String ownerType = qrcode.getOwnerType();
            String memberId = qrcode.getMemberId();
            Member member = this.memberService.selectById(memberId);
            response.put((Object)"name", (Object)member.getName());
            response.put((Object)"headImage", (Object)member.getHeadImage());
            if (StringUtil.equals((String)ownerType, (String)DistributerQrcodeOwnerTypeEnum.DISTRIBUTER.value())) {
                Distributer distributer = this.distributerService.selectById(memberId);
                String name2 = distributer.getName();
                if (StringUtil.isNotBlank((String)name2)) {
                    response.put((Object)"name", (Object)name2);
                }
            } else if (StringUtil.equals((String)ownerType, (String)DistributerQrcodeOwnerTypeEnum.SHARER.value()) && StringUtil.isNotBlank((String)(name = (sharer = (Sharer)((Object)this.sharerService.selectById(memberId))).getName()))) {
                response.put((Object)"name", (Object)name);
            }
            return RestResponse.success((Object)response);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/distributer-qrcode/get-activity"})
    public RestResponse getDistributerActivityQrcode(String activityId, @RequestParam(required=false, name="showStyle") String showStyleString, String page) {
        try {
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            Checker.checkBlankAndLength((String)activityId, (String)"\u6d3b\u52a8id", (int)32);
            String targetType = DistributerQrcodeTargetTypeEnum.ACTIVITY.value();
            String ownerType = DistributerQrcodeOwnerTypeEnum.DISTRIBUTER.value();
            int showStyle = Checker.checkStringIsUnsignedInteger((String)showStyleString, (String)"\u6837\u5f0f");
            String targetParam = null;
            return this.getQrcode(memberId, ownerType, targetType, activityId, page, showStyle, targetParam);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/sharer-qrcode/get-{type}"})
    public RestResponse getSharerActivityQrcode(@PathVariable String type, String activityId, String storeId, @RequestParam(required=false, name="showStyle") String showStyleString, String page) {
        try {
            Checker.checkBlankAndLength((String)activityId, (String)"id", (int)32);
            String appId = this.getAppId();
            String openId = SessionUtil.getOpenIdIfAbsentToThrow();
            String unionId = null;
            String memberId = this.sharerService.ensureMemberAndAccountWhenRegist(new SharerRegistData(), openId, unionId, appId);
            if (StringUtil.isBlank((String)memberId)) {
                return RestResponse.success(null, (String)"\u672a\u6ce8\u518c\uff0c\u56e0\u4e3a\u4f1a\u5458\u4e0d\u5b58\u5728");
            }
            int showStyle = Checker.checkStringIsUnsignedInteger((String)showStyleString, (String)"\u6837\u5f0f");
            Sharer sharer = (Sharer)((Object)this.sharerService.selectById(memberId));
            if (sharer == null) {
                SharerBecomeCondition condition = this.sharerBecomeConditionConfigService.selectConfig(appId).get(0);
                if (StringUtil.in((String)condition.getCondition(), (String[])new String[]{SharerBecomeConditionEnum.NO_CONDITION.value(), SharerBecomeConditionEnum.REGIST.value()})) {
                    Member member = this.memberService.selectById(memberId);
                    RestResponse registResponse = this.sharerRegistComponent.registByCondition(new HashMap<String, String>(), member, openId, condition);
                    if (!IntegerUtil.equals((Integer)registResponse.getCode(), (Integer)StatusCode.OK.code())) {
                        return registResponse;
                    }
                } else {
                    return RestResponse.error((int)110, (String)"\u5148\u6ce8\u518c\u63a8\u5e7f\u8005\uff0c\u624d\u80fd\u751f\u6210\u63a8\u5e7f\u6d77\u62a5", null);
                }
            }
            String targetType = this.determineTargetType(type);
            String targetParam = null;
            if (StringUtil.equals((String)targetType, (String)DistributerQrcodeTargetTypeEnum.MALL_GOODS.value())) {
                Checker.checkBlankAndLength((String)storeId, (String)"\u5546\u6237\u975e\u6cd5", (int)32);
                targetParam = "{\"storeId\": \"" + storeId + "\"}";
            }
            String ownerType = DistributerQrcodeOwnerTypeEnum.SHARER.value();
            return this.getQrcode(memberId, ownerType, targetType, activityId, page, showStyle, targetParam);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    private RestResponse getQrcode(String memberId, String ownerType, String targetType, String targetId, String page, int showStyle, String targetParam) {
        try {
            String defaultServerId;
            FileServer server;
            if (StringUtil.isBlank((String)page)) {
                page = "pagesPromotion/transfer/index";
            }
            Checker.checkCondition(((server = (FileServer)this.fileServerService.selectById((Object)(defaultServerId = "1"))) == null ? 1 : 0) != 0, (String)"\u56fe\u7247\u670d\u52a1\u5668\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801");
            String appId = this.getAppId();
            DistributerQrcode qrcode = this.distributerQrcodeComponent.createOrGet(memberId, appId, page, ownerType, targetId, targetType, showStyle, targetParam);
            this.storableService.assembleHost((Storable)qrcode, server);
            return RestResponse.success((Object)new DistributerQrcodeMemberGetResponse(qrcode));
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    private String determineTargetType(String type) {
        if (StringUtil.equals((String)type, (String)"activity")) {
            return DistributerQrcodeTargetTypeEnum.ACTIVITY.value();
        }
        if (StringUtil.equals((String)type, (String)"course-vip")) {
            return DistributerQrcodeTargetTypeEnum.COURSE_VIP.value();
        }
        if (StringUtil.equals((String)type, (String)"mall-goods")) {
            return DistributerQrcodeTargetTypeEnum.MALL_GOODS.value();
        }
        Checker.checkCondition((boolean)true, (String)"\u9519\u8bef\u7684\u63a8\u5e7f\u7801\u7c7b\u578b");
        return null;
    }
}

