/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.member;

import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.domain.DistributerRegistField;
import com.wego168.distribute.domain.DistributerRegistFieldData;
import com.wego168.distribute.model.DistributerRegistData;
import com.wego168.distribute.model.response.DistributerRegistFieldDataMemberListResponse;
import com.wego168.distribute.service.impl.DistributerRegistFieldDataService;
import com.wego168.distribute.service.impl.DistributerRegistFieldService;
import com.wego168.distribute.service.impl.DistributerService;
import com.wego168.exception.WegoException;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="memberDistributerRegistFieldDataController")
public class DistributerRegistFieldDataController
extends SimpleController {
    @Autowired
    private DistributerRegistFieldService distributerRegistFieldService;
    @Autowired
    private DistributerRegistFieldDataService service;
    @Autowired
    private DistributerService distributerService;

    @GetMapping(value={"/api/v1/distributer-regist-field-data/list"})
    public RestResponse selectList() {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        List<DistributerRegistFieldDataMemberListResponse> list = this.service.selectListByDistributerId(memberId);
        return RestResponse.success(list);
    }

    @PostMapping(value={"/api/v1/distributer-regist-field-data/update"})
    public RestResponse update(@RequestBody Map<String, String> registrationData) {
        try {
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            String appId = this.getAppId();
            Distributer distributer = this.distributerService.selectById(memberId);
            Checker.checkCondition((distributer == null ? 1 : 0) != 0, (String)"\u8bf7\u5148\u6ce8\u518c");
            List<DistributerRegistFieldDataMemberListResponse> list = this.service.selectListByDistributerId(memberId);
            Checker.checkCondition((list == null || list.size() == 0 ? 1 : 0) != 0, (String)"\u65e0\u53ef\u7528\u8d44\u6599");
            List<DistributerRegistField> fieldList = this.distributerRegistFieldService.selectList(appId);
            DistributerRegistData registrationDataResponse = this.distributerRegistFieldService.checkRegistrationData(registrationData, fieldList);
            String name = registrationDataResponse.getName();
            String mobile = registrationDataResponse.getMobile();
            Distributer param = new Distributer();
            param.setId(distributer.getId());
            if (StringUtil.isNotBlank((String)name)) {
                param.setName(name);
            }
            if (StringUtil.isNotBlank((String)mobile)) {
                param.setMobile(mobile);
            }
            param.setUpdateTime(new Date());
            this.distributerService.updateSelective((Object)param);
            List<DistributerRegistFieldData> dataList = this.service.create(fieldList, registrationData, memberId);
            this.service.refresh(dataList);
            return RestResponse.success(dataList, (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

