/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.member;

import com.simple.mybatis.Bootmap;
import com.wego168.distribute.component.DistributerRegistComponent;
import com.wego168.distribute.controller.admin.DistributerControllerSupport;
import com.wego168.distribute.service.IDistributerAccountService;
import com.wego168.distribute.service.IDistributerService;
import com.wego168.distribute.service.impl.DistributeOpenIdChainService;
import com.wego168.distribute.service.impl.DistributerAccountService;
import com.wego168.distribute.service.impl.DistributerCommissionService;
import com.wego168.distribute.service.impl.DistributerService;
import com.wego168.distribute.service.impl.WithdrawService;
import com.wego168.exception.WegoException;
import com.wego168.member.service.IMemberAccountService;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.WalletService;
import com.wego168.member.util.SessionUtil;
import com.wego168.web.response.RestResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="memberDistributerSummaryController")
public class DistributerSummaryController
extends DistributerControllerSupport {
    @Autowired
    private DistributeOpenIdChainService distributeOpenIdChainService;
    @Autowired
    @Qualifier(value="distributerService")
    private DistributerService service;
    @Autowired
    private DistributerAccountService distributerAccountService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private DistributerCommissionService distributerCommissionService;
    @Autowired
    private DistributerRegistComponent distributerRegistComponent;
    @Autowired
    private WithdrawService withdrawService;
    @Autowired
    private WalletService walletService;

    @GetMapping(value={"/api/v1.1/distributer-summary"})
    public RestResponse getSummary(HttpServletRequest request) {
        try {
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            String openId = this.distributerRegistComponent.ensureOpenId(request);
            int customerQuantity = this.distributerCommissionService.sumCustomerQuantity(memberId);
            int friendQuantity = this.distributeOpenIdChainService.sumFriendQuantity(openId);
            int customerOrderQuantity = this.distributerCommissionService.sumCustomerOrderQuantity(memberId, "distributer");
            int commissionAmount = this.distributerCommissionService.sumCommissionAmount(memberId, "distributer");
            int totalCommissionAmount = this.distributerCommissionService.sumTotalCommissionAmount(memberId, "distributer");
            int withdrawed = this.withdrawService.sumWithdrawAmount(memberId);
            int wallet = this.walletService.getWalletAmount(memberId);
            Bootmap response = new Bootmap();
            response.put((Object)"wallet", (Object)wallet);
            response.put((Object)"customerQuantity", (Object)customerQuantity);
            response.put((Object)"friendQuantity", (Object)friendQuantity);
            response.put((Object)"customerOrderQuantity", (Object)customerOrderQuantity);
            response.put((Object)"totalCommission", (Object)totalCommissionAmount);
            response.put((Object)"currentCommission", (Object)(commissionAmount - withdrawed));
            response.put((Object)"withdrawed", (Object)withdrawed);
            return RestResponse.success((Object)response);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @Override
    protected IMemberAccountService getMemberAccountService() {
        return this.memberAccountService;
    }

    @Override
    protected IDistributerService getDistributerService() {
        return this.service;
    }

    @Override
    protected IDistributerAccountService getDistributerAccountService() {
        return this.distributerAccountService;
    }
}

