/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.member;

import com.simple.mybatis.Page;
import com.wego168.distribute.domain.Withdraw;
import com.wego168.distribute.model.response.WithdrawMemberGetResponse;
import com.wego168.distribute.model.response.WithdrawMemberPageResponse;
import com.wego168.distribute.service.impl.WithdrawService;
import com.wego168.exception.WegoException;
import com.wego168.member.service.impl.WalletService;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.Checker;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="memberWithdrawController")
public class WithdrawController
extends SimpleController {
    @Autowired
    private WalletService walletService;
    @Autowired
    private WithdrawService service;

    @GetMapping(value={"/api/v1/withdraw/balance"})
    public RestResponse getBalance() {
        try {
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            int wallet = this.walletService.getWalletAmount(memberId);
            return RestResponse.success((Object)wallet);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/withdraw/received"})
    public RestResponse getReceived() {
        try {
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            int sum = this.service.sumWithdrawAmount(memberId);
            return RestResponse.success((Object)sum);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/withdraw/page"})
    public RestResponse selectPage(HttpServletRequest request) {
        try {
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            Page page = this.buildPage(request);
            List<Withdraw> list = this.service.selectPageForMember(memberId, page);
            if (list != null && list.size() > 0) {
                ArrayList<WithdrawMemberPageResponse> responseList = new ArrayList<WithdrawMemberPageResponse>(list.size());
                for (Withdraw withdrawDb : list) {
                    responseList.add(new WithdrawMemberPageResponse(withdrawDb));
                }
                page.setList(responseList);
            } else {
                page.setList(list);
            }
            return RestResponse.success((Object)page);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/withdraw/get"})
    public RestResponse get(String id) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"\u63d0\u73b0\u8bb0\u5f55", (int)32);
            Withdraw withdraw = (Withdraw)((Object)this.service.selectById(id));
            Checker.checkCondition((withdraw == null ? 1 : 0) != 0, (String)"\u8be5\u63d0\u73b0\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            return RestResponse.success((Object)new WithdrawMemberGetResponse(withdraw));
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

