/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.web;

import com.simple.mybatis.Bootmap;
import com.wego168.distribute.domain.DistributerCommissionConfig;
import com.wego168.distribute.service.impl.DistributerCommissionConfigService;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.text.DecimalFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="webDistributerCommissionConfigController")
public class DistributerCommissionConfigController
extends SimpleController {
    @Autowired
    private DistributerCommissionConfigService service;

    @GetMapping(value={"/api/v1/distributer-commission-config/get"})
    public RestResponse getDistributerCommissionConfig() {
        String appId = this.getAppId();
        DistributerCommissionConfig config = this.service.select(appId);
        return RestResponse.success((Object)((Object)config));
    }

    @GetMapping(value={"/api/v1/withdraw-config/get"})
    public RestResponse getWithdrawConfig() {
        String appId = this.getAppId();
        DistributerCommissionConfig config = this.service.select(appId);
        int minWithdrawAmount = config.getMinWithdrawAmount();
        int minPoundage = config.getMinPoundage();
        int poundageRate = config.getPoundageRate();
        Bootmap response = new Bootmap();
        response.put((Object)"poundageRate", (Object)poundageRate);
        response.put((Object)"minPoundage", (Object)minPoundage);
        response.put((Object)"minWithdrawAmount", (Object)minWithdrawAmount);
        String description = "\u63d0\u73b0\u514d\u624b\u7eed\u8d39";
        DecimalFormat formatter = new DecimalFormat("######0.00");
        if (poundageRate > 0 || minPoundage > 0) {
            if (poundageRate > 0 && minPoundage == 0) {
                description = "\u6bcf\u7b14\u63d0\u73b0\u6536\u53d6" + formatter.format((double)poundageRate * 0.01) + "%\u624b\u7eed\u8d39";
            }
            if (poundageRate == 0 && minPoundage > 0) {
                description = "\u6bcf\u7b14\u63d0\u73b0\u6536\u53d6" + formatter.format((double)minPoundage * 0.01) + "\u5143\u624b\u7eed\u8d39";
            }
            if (poundageRate > 0 && minPoundage > 0) {
                description = "\u6bcf\u7b14\u63d0\u73b0\u6536\u53d6" + formatter.format((double)poundageRate * 0.01) + "%\u624b\u7eed\u8d39\uff0c\u6700\u4f4e" + formatter.format((double)minPoundage * 0.01) + "\u5143";
            }
        }
        response.put((Object)"description", (Object)description);
        return RestResponse.success((Object)response);
    }
}

