/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.controller.web;

import com.wego168.base.component.ActivitySignPaySubscriber;
import com.wego168.distribute.scheduler.DistributerCommissionScheduler;
import com.wego168.distribute.scheduler.WithdrawScheduler;
import com.wego168.exception.WegoException;
import com.wego168.share.task.SharerLevelCalculator;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="asdjknwer4tgb")
public class TestController
extends SimpleController {
    @Autowired
    private SharerLevelCalculator sharerLevelCalculator;
    @Autowired
    private DistributerCommissionScheduler distributerCommissionScheduler;
    @Autowired
    private WithdrawScheduler withdrawScheduler;
    @Autowired
    private ActivitySignPaySubscriber activityCommissionHandler;

    @GetMapping(value={"/api/v1/test/distributer/scheduler/transfer-commission"})
    public RestResponse transferCommission() {
        this.distributerCommissionScheduler.transferActivityCommissionToWallet();
        return RestResponse.success((String)"ok");
    }

    @GetMapping(value={"/api/v1/test/sharer-level/calculate"})
    public RestResponse calculateSharerLevelByBinding(String sharerId) {
        String appId = this.getAppId();
        this.sharerLevelCalculator.calculateSharerLevelByBinding(sharerId, appId);
        return RestResponse.success((String)"ok");
    }

    @GetMapping(value={"/api/v1/test/join-transfer"})
    public RestResponse joinTransfer() {
        this.withdrawScheduler.joinTransfer();
        return RestResponse.success((String)"ok");
    }

    @GetMapping(value={"/api/v1/test/query-join-transfer"})
    public RestResponse queryJoinTransfer() {
        this.withdrawScheduler.queryJoinTransfer();
        return RestResponse.success((String)"ok");
    }

    @GetMapping(value={"/api/v1/test/give-activity-commission"})
    public RestResponse giveActivityCommission(@RequestParam(required=false, name="activityAmount") String activityAmountString, String memberId) {
        try {
            Checker.checkBlankAndLength((String)memberId, (String)"\u62a5\u540d\u8005id", (int)32);
            String appId = this.getAppId();
            String signId = "testsignid-" + SequenceUtil.createRandomLetterSequence((int)21, (Boolean)false);
            int activityAmount = Checker.checkStringIsPositiveInteger((String)activityAmountString, (String)"\u6d3b\u52a8\u62a5\u540d\u8d39");
            int point = 100;
            int payAmount = activityAmount;
            int distributerCommissionAmount = activityAmount / 5;
            int sharerCommissionAmount = activityAmount / 2;
            boolean commissionNeedAudit = false;
            String activityTitle = "\u865a\u7a7a\u6d3b\u52a8";
            String activityImage = "/attachments/activity/937fa928a8fb4833834fbc442efa391e.jpg";
            this.activityCommissionHandler.subscribeActivitySignPay(Integer.valueOf(payAmount), Integer.valueOf(activityAmount), Integer.valueOf(distributerCommissionAmount), Integer.valueOf(sharerCommissionAmount), point, Boolean.valueOf(commissionNeedAudit), activityTitle, activityImage, memberId, signId, appId);
            return RestResponse.success((String)"ok");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/test/cancel-activity-commission"})
    public RestResponse cancelActivityCommission(String signId, String activityTitle) {
        try {
            Checker.checkBlankAndLength((String)signId, (String)"\u62a5\u540d\u8bb0\u5f55id", (int)32);
            Checker.checkBlankAndLength((String)activityTitle, (String)"\u6d3b\u52a8\u6807\u9898", (int)32);
            return RestResponse.success((String)"ok");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

