/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.filter;

import com.wego168.base.filter.FilterIgnores;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.RequestUtil;
import com.wego168.util.StringUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DistributeFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(DistributeFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)resp;
        HttpServletRequest request = (HttpServletRequest)req;
        if (FilterIgnores.isStaticResource((HttpServletRequest)request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String distribute = request.getParameter("dst");
        if (StringUtil.equals((String)distribute, (String)"1")) {
            this.logger.info("Thread:{},distribute uri:{}", (Object)Thread.currentThread().getName(), (Object)RequestUtil.getCurrentUrl((HttpServletRequest)request));
            String upperDistributerId = request.getParameter("dstr");
            String distributerId = SessionUtil.getMemberId((HttpServletRequest)request);
            this.logger.info("Thread:{},upper distibuterId:{},distributerId:{}", new Object[]{Thread.currentThread().getName(), upperDistributerId, distributerId});
            if (StringUtil.isNotBlank((String)upperDistributerId) && StringUtil.isNotBlank((String)distributerId) && !StringUtil.equals((String)upperDistributerId, (String)distributerId)) {
                this.logger.error("distributer filter asycn ready:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                this.createDistributeRelationship(upperDistributerId, distributerId);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    protected abstract void createDistributeRelationship(String var1, String var2);
}

