/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.scheduler;

import com.wego168.distribute.domain.DistributerCommission;
import com.wego168.distribute.service.impl.DistributerCommissionService;
import com.wego168.util.Checker;
import com.wego168.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DistributerCommissionScheduler {
    @Autowired
    private DistributerCommissionService service;
    private Logger logger = LoggerFactory.getLogger(DistributerCommissionScheduler.class);

    @Scheduled(cron="0 3/15 * * * ?")
    @Async
    public void transferActivityCommissionToWallet() {
        this.logger.error("\u5f00\u59cb\u5c06\u6d3b\u52a8\u4f63\u91d1\u6c47\u5165\u94b1\u5305\u4f59\u989d\u3002\u3002\u3002");
        List<DistributerCommission> commissionList = this.service.selectPreTransferActivityCommission();
        if (Checker.listIsEmpty(commissionList)) {
            this.logger.error("\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u6d3b\u52a8\u4f63\u91d1");
            return;
        }
        Date now = new Date();
        for (DistributerCommission commissionDb : commissionList) {
            Integer delayHours = commissionDb.getTransferDelayHours();
            delayHours = delayHours == null ? 0 : delayHours;
            Date auditTime = commissionDb.getAuditTime();
            if (DateUtil.addHourToDate((Date)auditTime, (int)delayHours).before(now)) {
                this.service.transferToWallet(commissionDb);
                this.logger.error("\u6d3b\u52a8\u4f63\u91d1[{}]\u5df2\u5230\u8d26\uff0c\u91d1\u989d\uff1a{}", (Object)commissionDb.getFromOrderTitle(), (Object)commissionDb.getAmount());
                continue;
            }
            this.logger.error("\u6d3b\u52a8\u4f63\u91d1[{}]\u4e0d\u53ef\u5230\u8d26\uff0c\u73b0\u5728\u8fd8\u4e0d\u662f\u65f6\u5019", (Object)commissionDb.getFromOrderTitle());
        }
    }

    @Scheduled(cron="0 4/15 * * * ?")
    @Async
    public void transferMallOrderCommissionToWallet() {
        this.logger.error("\u5f00\u59cb\u5c06\u5546\u57ce\u8ba2\u5355\u4f63\u91d1\u6c47\u5165\u94b1\u5305\u4f59\u989d\u3002\u3002\u3002");
        List<DistributerCommission> commissionList = this.service.selectPreTransferMallOrderCommission();
        if (Checker.listIsEmpty(commissionList)) {
            this.logger.error("\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u5546\u57ce\u8ba2\u5355\u4f63\u91d1");
            return;
        }
        Date now = new Date();
        for (DistributerCommission commissionDb : commissionList) {
            Integer delayHours = commissionDb.getTransferDelayHours();
            delayHours = delayHours == null ? 0 : delayHours;
            Date auditTime = commissionDb.getAuditTime();
            if (DateUtil.addHourToDate((Date)auditTime, (int)delayHours).before(now)) {
                this.service.transferToWallet(commissionDb);
                this.logger.error("\u5546\u57ce\u8ba2\u5355\u4f63\u91d1[{}]\u5df2\u5230\u8d26\uff0c\u91d1\u989d\uff1a{}", (Object)commissionDb.getFromOrderTitle(), (Object)commissionDb.getAmount());
                continue;
            }
            this.logger.error("\u5546\u57ce\u8ba2\u5355\u4f63\u91d1[{}]\u4e0d\u53ef\u5230\u8d26\uff0c\u73b0\u5728\u8fd8\u4e0d\u662f\u65f6\u5019", (Object)commissionDb.getFromOrderTitle());
        }
    }
}

