/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.scheduler;

import com.simple.mybatis.JpaCriteria;
import com.wego168.distribute.domain.Withdraw;
import com.wego168.distribute.enums.TransferTypeEnum;
import com.wego168.distribute.enums.TransferWayEnum;
import com.wego168.distribute.enums.WithdrawAuditStatusEnum;
import com.wego168.distribute.enums.WithdrawStatusEnum;
import com.wego168.distribute.enums.WithdrawTransferStatusEnum;
import com.wego168.distribute.service.impl.WithdrawService;
import com.wego168.distribute.task.WithdrawTask;
import com.wego168.util.StringUtil;
import com.wego168.wxpay.domain.WxpayConfig;
import com.wego168.wxpay.enums.PayGateWayCodeEnum;
import com.wego168.wxpay.model.response.JoinTransferResponse;
import com.wego168.wxpay.service.WxpayConfigService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class WithdrawScheduler {
    @Autowired
    private WithdrawService service;
    @Autowired
    private WithdrawTask withdrawTask;
    @Autowired
    private WxpayConfigService wxpayConfigService;
    private Logger logger = LoggerFactory.getLogger(WithdrawScheduler.class);

    @Scheduled(cron="0 0/5 * * * ?")
    public void joinTransfer() {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("status", (Object)WithdrawStatusEnum.ONGOING.value());
        criteria.eq("transferWay", (Object)TransferWayEnum.AUTO.value());
        criteria.eq("transferType", (Object)TransferTypeEnum.JOIN.value());
        criteria.eq("auditStatus", (Object)WithdrawAuditStatusEnum.AUDITED.value());
        criteria.eq("transferStatus", (Object)WithdrawTransferStatusEnum.WAITING.value());
        List list = this.service.selectList(criteria);
        if (list == null || list.size() == 0) {
            this.logger.error("\u65e0\u63d0\u73b0\u8bb0\u5f55");
            return;
        }
        for (Withdraw withdraw : list) {
            Integer merchantType;
            String merchantId = withdraw.getTransferMerchantId();
            String appId = withdraw.getAppId();
            WxpayConfig payConfig = this.wxpayConfigService.selectByAppIdAndMerchant(appId, merchantId, (merchantType = withdraw.getTransferMerchantType()).intValue());
            if (payConfig == null) {
                this.logger.error(String.valueOf(withdraw.getNumber()) + "\u65e0\u652f\u4ed8\u914d\u7f6e");
                continue;
            }
            String code = payConfig.getCode();
            if (!StringUtil.equals((String)code, (String)PayGateWayCodeEnum.JOIN.description())) {
                this.logger.error(String.valueOf(withdraw.getNumber()) + "\u65e0\u6c47\u805a\u652f\u4ed8\u914d\u7f6e");
                continue;
            }
            JoinTransferResponse response = this.service.joinTransfer(payConfig, withdraw);
            this.logger.error(response.toString());
        }
    }

    @Scheduled(cron="0 3/15 * * * ?")
    public void queryJoinTransfer() {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("status", (Object)WithdrawStatusEnum.ONGOING.value());
        criteria.eq("transferWay", (Object)TransferWayEnum.AUTO.value());
        criteria.eq("transferType", (Object)TransferTypeEnum.JOIN.value());
        criteria.eq("auditStatus", (Object)WithdrawAuditStatusEnum.AUDITED.value());
        criteria.eq("transferStatus", (Object)WithdrawTransferStatusEnum.ONGOING.value());
        List list = this.service.selectList(criteria);
        if (list == null || list.size() == 0) {
            this.logger.error("\u65e0\u6253\u6b3e\u4e2d\u63d0\u73b0\u8bb0\u5f55");
            return;
        }
        for (Withdraw withdraw : list) {
            Integer merchantType;
            String merchantId;
            String appId = withdraw.getAppId();
            WxpayConfig payConfig = this.wxpayConfigService.selectByAppIdAndMerchant(appId, merchantId = withdraw.getTransferMerchantId(), (merchantType = withdraw.getTransferMerchantType()).intValue());
            if (payConfig == null) {
                this.logger.error("query failed,pay config is not defined,id:{}", (Object)withdraw.getId());
                continue;
            }
            this.withdrawTask.queryAndUpdateStatus(payConfig, withdraw);
        }
    }
}

