/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.service.impl;

import com.simple.mybatis.JpaCriteria;
import com.wego168.distribute.domain.DistributeChain;
import com.wego168.distribute.domain.DistributeLink;
import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.persistence.DistributeChainMapper;
import com.wego168.distribute.persistence.DistributeLinkMapper;
import com.wego168.distribute.service.IDistributeChainService;
import com.wego168.distribute.service.impl.DistributerService;
import com.wego168.util.SequenceUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DistributeChainService
implements IDistributeChainService {
    private static final Logger log = LoggerFactory.getLogger(DistributeChainService.class);
    public int maxLevel = 3;
    @Autowired
    private DistributeChainMapper distributeChainMapper;
    @Autowired
    private DistributeLinkMapper distributeLinkMapper;
    @Autowired
    private DistributerService distributerService;

    @Override
    public DistributeChain create(String distributerId, String upperDistributerId, int level, boolean isRoot) {
        DistributeChain chain = new DistributeChain();
        chain.setId(SequenceUtil.createUuid());
        chain.setCreateTime(new Date());
        chain.setDistributerId(distributerId);
        chain.setUpperDistributerId(upperDistributerId);
        chain.setUpperDistributerLevel(level);
        chain.setUpperDistributerIsRoot(isRoot);
        return chain;
    }

    @Override
    public DistributeChain createSystemVirtualChain(String distributerId, String virtualUpperDistributerId) {
        DistributeChain chain = new DistributeChain();
        chain.setId(SequenceUtil.createUuid());
        chain.setCreateTime(new Date());
        chain.setDistributerId(distributerId);
        chain.setUpperDistributerId(virtualUpperDistributerId);
        chain.setUpperDistributerIsRoot(false);
        chain.setUpperDistributerLevel(0);
        return chain;
    }

    @Override
    public void join(List<DistributeChain> chainList, DistributeLink link) {
        if (chainList != null) {
            this.distributeChainMapper.insertBatch(chainList);
        }
        if (link != null) {
            this.distributeLinkMapper.insert(link);
        }
    }

    @Override
    public List<DistributeChain> listUpperChainsIncludeSystemVirtualChain(String distributerId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("distributerId", (Object)distributerId).le("upperDistributerLevel", (Object)this.maxLevel).orderBy("upperDistributerLevel asc");
        return this.distributeChainMapper.selectList(criteria);
    }

    @Override
    public List<DistributeChain> listUpperChainsExcludeSystemVirtualChain(String distributerId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("distributerId", (Object)distributerId).gt("upperDistributerLevel", (Object)0).le("upperDistributerLevel", (Object)this.maxLevel).orderBy("upperDistributerLevel asc");
        return this.distributeChainMapper.selectList(criteria);
    }

    @Override
    public DistributeChain getNearestChainIncludeSystemVirtualChain(String distributerId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("distributerId", (Object)distributerId).orderBy("upperDistributerLevel asc");
        List list = this.distributeChainMapper.selectList(criteria);
        if (list != null && list.size() > 0) {
            return (DistributeChain)list.get(0);
        }
        return null;
    }

    @Override
    public DistributeChain getNearestChainExcludeSystemVirtualChain(String distributerId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("distributerId", (Object)distributerId).gt("upperDistributerLevel", (Object)0).orderBy("upperDistributerLevel asc");
        List list = this.distributeChainMapper.selectList(criteria);
        if (list != null && list.size() > 0) {
            return (DistributeChain)list.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public Integer updateUpperDistributerByDistributerPhone(String memberId, String mobile, String appId) {
        Distributer distributer = (Distributer)((Object)this.distributerService.select(JpaCriteria.builder().eq("mobile", (Object)mobile)));
        if (distributer == null) {
            log.error("\u627e\u4e0d\u5230\u624b\u673a\u53f7\u4e3a{}\u7684\u5206\u9500\u8005", (Object)mobile);
            return 0;
        }
        log.error("\u627e\u5230\u5206\u9500\u8005\u4e3a{}", (Object)distributer.getId());
        JpaCriteria criteria = JpaCriteria.builder().eq("distributerId", (Object)memberId).eq("upperDistributerLevel", (Object)1);
        DistributeChain distributeChain = (DistributeChain)this.distributeChainMapper.select(criteria);
        if (distributeChain == null || distributeChain.getUpperDistributerId().equals(distributer.getId())) {
            return 0;
        }
        distributeChain.setUpperDistributerId(distributer.getId());
        return this.distributeChainMapper.update(distributeChain);
    }
}

