/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.service.impl;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.distribute.domain.DistributeOpenIdChain;
import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.enums.DistributerCommissionStatusEnum;
import com.wego168.distribute.enums.DistributerStatusEnum;
import com.wego168.distribute.model.response.DistributerCustomersWebPageResponse;
import com.wego168.distribute.model.response.DistributerFriendsWebPageResponse;
import com.wego168.distribute.persistence.DistributeOpenIdChainMapper;
import com.wego168.distribute.persistence.DistributerCommissionMapper;
import com.wego168.distribute.persistence.DistributerMapper;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributeOpenIdChainService
extends CrudService<DistributeOpenIdChain> {
    @Autowired
    private DistributeOpenIdChainMapper mapper;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private DistributerMapper distributerMapper;
    @Autowired
    private DistributerCommissionMapper distributerCommissionMapper;

    public DistributeOpenIdChain create(String openId, String upperOpenId, int level, boolean isRoot, String url) {
        DistributeOpenIdChain chain = new DistributeOpenIdChain();
        chain.setId(SequenceUtil.createUuid());
        chain.setCreateTime(new Date());
        chain.setOpenId(openId);
        chain.setUpperOpenId(upperOpenId);
        chain.setUpperDistributerLevel(level);
        chain.setUpperDistributerIsRoot(isRoot);
        chain.setUrl(url);
        return chain;
    }

    public DistributeOpenIdChain createSystemVirtualChain(String openId, String virtualUpperDistributerId) {
        DistributeOpenIdChain chain = new DistributeOpenIdChain();
        chain.setId(SequenceUtil.createUuid());
        chain.setCreateTime(new Date());
        chain.setOpenId(openId);
        chain.setUpperOpenId(virtualUpperDistributerId);
        chain.setUpperDistributerIsRoot(false);
        chain.setUpperDistributerLevel(0);
        chain.setUrl(null);
        return chain;
    }

    public String getRealUpperOpenId(String openId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("openId", (Object)openId);
        criteria.eq("upperDistributerLevel", (Object)1);
        DistributeOpenIdChain chain = (DistributeOpenIdChain)this.mapper.select(criteria);
        if (chain != null) {
            return chain.getUpperOpenId();
        }
        return null;
    }

    public String getUpperOpenId(String openId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("openId", (Object)openId);
        criteria.le("upperDistributerLevel", (Object)1);
        criteria.orderBy("upperDistributerLevel ASC");
        List list = this.mapper.selectList(criteria);
        if (list != null && list.size() > 0) {
            return ((DistributeOpenIdChain)list.get(0)).getUpperOpenId();
        }
        return null;
    }

    public boolean isAuditedDistributerId(String openId, String appId) {
        String memberId;
        Distributer distributer;
        MemberAccount account = this.memberAccountService.selectByUsername(openId, appId);
        if (account != null && (distributer = (Distributer)((Object)this.distributerMapper.selectById(memberId = account.getMemberId()))) != null) {
            return StringUtil.equals((String)distributer.getStatus(), (String)DistributerStatusEnum.AUDITED.value());
        }
        return false;
    }

    public List<DistributeOpenIdChain> listUpperChainsExcludeSystemVirtualChain(String openId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("openId", (Object)openId);
        criteria.gt("upperDistributerLevel", (Object)0);
        criteria.le("upperDistributerLevel", (Object)3).orderBy("upperDistributerLevel ASC");
        return this.mapper.selectList(criteria);
    }

    public List<DistributerFriendsWebPageResponse> selectFriendsPage(String name, String upperOpenId, String distributerId, boolean showCommission, int accountType, Page page) {
        List<DistributerFriendsWebPageResponse> openIdList;
        int level = 1;
        page.put((Object)"level", (Object)level);
        page.put((Object)"openId", (Object)upperOpenId);
        page.put((Object)"accountType", (Object)accountType);
        if (StringUtil.isNotBlank((String)name)) {
            page.put((Object)"name", (Object)("%" + name + "%"));
        }
        if ((openIdList = this.mapper.selectFriendsOpenIdPage(page)) != null && openIdList.size() > 0) {
            List<DistributerFriendsWebPageResponse> friends = this.mapper.selectFriendsPage(openIdList);
            HashMap<String, DistributerFriendsWebPageResponse> friendsMap = new HashMap<String, DistributerFriendsWebPageResponse>();
            for (DistributerFriendsWebPageResponse friend : friends) {
                friendsMap.put(friend.getOpenId(), friend);
            }
            HashMap<String, Integer> commissionMap = new HashMap<String, Integer>();
            if (showCommission) {
                String type = "distributer";
                String[] statusArray = new String[]{DistributerCommissionStatusEnum.FINISH.value(), DistributerCommissionStatusEnum.ONGOING.value()};
                List<DistributerFriendsWebPageResponse> commissionList = this.distributerCommissionMapper.selectCustomerCommission(openIdList, statusArray, distributerId, type);
                if (commissionList != null && commissionList.size() > 0) {
                    for (DistributerFriendsWebPageResponse r : commissionList) {
                        commissionMap.put(r.getOpenId(), r.getCommission());
                    }
                }
            }
            for (DistributerFriendsWebPageResponse openIdResponse : openIdList) {
                String openId = openIdResponse.getOpenId();
                DistributerFriendsWebPageResponse friend = (DistributerFriendsWebPageResponse)friendsMap.get(openId);
                if (friend == null) {
                    openIdResponse.setAppellation("\u6e38\u5ba2");
                } else {
                    openIdResponse.setAppellation(friend.getAppellation());
                    openIdResponse.setHeadImage(friend.getHeadImage());
                    openIdResponse.setRegistTime(friend.getRegistTime());
                }
                Integer commission = (Integer)commissionMap.get(openId);
                commission = commission == null ? 0 : commission;
                openIdResponse.setCommission(commission);
            }
        }
        return openIdList;
    }

    public List<DistributerCustomersWebPageResponse> selectCustomersPage(String name, String upperOpenId, String distributerId, boolean showCommission, int accountType, Page page) {
        List<DistributerCustomersWebPageResponse> responseList;
        int level = 1;
        page.put((Object)"level", (Object)level);
        page.put((Object)"openId", (Object)upperOpenId);
        page.put((Object)"accountType", (Object)accountType);
        if (StringUtil.isNotBlank((String)name)) {
            page.put((Object)"name", (Object)("%" + name + "%"));
        }
        if ((responseList = this.mapper.selectCustomersOpenIdPage(page)) != null && responseList.size() > 0) {
            List<DistributerFriendsWebPageResponse> customers = this.mapper.selectFriendsPage(responseList);
            HashMap<String, DistributerFriendsWebPageResponse> customersMap = new HashMap<String, DistributerFriendsWebPageResponse>();
            for (DistributerFriendsWebPageResponse customer : customers) {
                customersMap.put(customer.getOpenId(), customer);
            }
            HashMap<String, Integer> commissionMap = new HashMap<String, Integer>();
            if (showCommission) {
                String type = "distributer";
                String[] statusArray = new String[]{DistributerCommissionStatusEnum.FINISH.value(), DistributerCommissionStatusEnum.ONGOING.value()};
                List<DistributerFriendsWebPageResponse> commissionList = this.distributerCommissionMapper.selectCustomerCommission(responseList, statusArray, distributerId, type);
                if (commissionList != null && commissionList.size() > 0) {
                    for (DistributerFriendsWebPageResponse r : commissionList) {
                        commissionMap.put(r.getOpenId(), r.getCommission());
                    }
                }
            }
            for (DistributerCustomersWebPageResponse response : responseList) {
                String openId = response.getOpenId();
                DistributerFriendsWebPageResponse customer = (DistributerFriendsWebPageResponse)customersMap.get(openId);
                if (customer == null) {
                    response.setAppellation("\u6e38\u5ba2");
                } else {
                    response.setAppellation(customer.getAppellation());
                    response.setHeadImage(customer.getHeadImage());
                }
                Integer commission = (Integer)commissionMap.get(openId);
                commission = commission == null ? 0 : commission;
                response.setAmount(commission);
            }
        }
        return responseList;
    }

    public int sumFriendQuantity(String distributerOpenId) {
        int level = 1;
        Integer friendQuantity = this.mapper.sumFriendQuantity(distributerOpenId, level);
        friendQuantity = friendQuantity == null ? 0 : friendQuantity;
        return friendQuantity;
    }

    public CrudMapper<DistributeOpenIdChain> getMapper() {
        return this.mapper;
    }
}

