/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.service.impl;

import com.simple.mybatis.JpaCriteria;
import com.wego168.distribute.domain.DistributerAccount;
import com.wego168.distribute.persistence.DistributerAccountMapper;
import com.wego168.distribute.service.IDistributerAccountService;
import com.wego168.member.enums.AccountTypeEnum;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.SequenceUtil;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributerAccountService
extends CrudService<DistributerAccount>
implements IDistributerAccountService {
    @Autowired
    private DistributerAccountMapper distributerAccountMapper;
    private static String defaultPassword = "123456";

    @Override
    public DistributerAccount selectByUsername(String username, String appId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("username", (Object)username).eq("appId", (Object)appId);
        return (DistributerAccount)((Object)this.distributerAccountMapper.select(criteria));
    }

    @Override
    public DistributerAccount createMobileAccount(String mobile, String distributerId, String appId) {
        DistributerAccount account = new DistributerAccount();
        account.setAppId(appId);
        account.setId(SequenceUtil.createUuid());
        account.setCreateTime(new Date());
        account.setDistributerId(distributerId);
        account.setIsDeleted(false);
        account.setPassword(defaultPassword);
        account.setType(AccountTypeEnum.MOBILE.value());
        account.setUpdateTime(new Date());
        account.setUsername(mobile);
        return account;
    }

    @Override
    public DistributerAccount createWechatAccount(String openId, String distributerId, String appId) {
        DistributerAccount account = new DistributerAccount();
        account.setAppId(appId);
        account.setId(SequenceUtil.createUuid());
        account.setCreateTime(new Date());
        account.setDistributerId(distributerId);
        account.setIsDeleted(false);
        account.setPassword(defaultPassword);
        account.setType(AccountTypeEnum.WECHAT.value());
        account.setUpdateTime(new Date());
        account.setUsername(openId);
        return account;
    }

    @Override
    public DistributerAccount selectMobileAccount(String distributerId, String appId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("distributerId", (Object)distributerId).eq("appId", (Object)appId).eq("type", (Object)AccountTypeEnum.MOBILE.value());
        return (DistributerAccount)((Object)this.distributerAccountMapper.select(criteria));
    }

    @Override
    public DistributerAccount selectWechatAccount(String distributerId, String appId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("distributerId", (Object)distributerId).eq("appId", (Object)appId).eq("type", (Object)AccountTypeEnum.WECHAT.value());
        return (DistributerAccount)((Object)this.distributerAccountMapper.select(criteria));
    }

    public CrudMapper<DistributerAccount> getMapper() {
        return this.distributerAccountMapper;
    }
}

