/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.service.impl;

import com.simple.mybatis.JpaCriteria;
import com.wego168.distribute.domain.DistributerBecomeCondition;
import com.wego168.distribute.enums.DistributerBecomeConditionEnum;
import com.wego168.distribute.persistence.DistributerBecomeConditionMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.SequenceUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributerBecomeConditionService
extends BaseService<DistributerBecomeCondition> {
    @Autowired
    private DistributerBecomeConditionMapper mapper;

    public List<DistributerBecomeCondition> selectList(String appId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        criteria.orderBy("sort ASC");
        List<DistributerBecomeCondition> list = this.selectList(criteria);
        if (list == null || list.size() == 0) {
            list = this.initCondition(appId);
        }
        return list;
    }

    public List<DistributerBecomeCondition> selectListByIdArray(String[] idArray) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.in("id", (Object[])idArray);
        return this.mapper.selectList(criteria);
    }

    private List<DistributerBecomeCondition> initCondition(String appId) {
        ArrayList<DistributerBecomeCondition> list = new ArrayList<DistributerBecomeCondition>(3);
        int sort = 1;
        String groupId = SequenceUtil.createUuid();
        DistributerBecomeConditionEnum[] distributerBecomeConditionEnumArray = DistributerBecomeConditionEnum.values();
        int n = distributerBecomeConditionEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            DistributerBecomeConditionEnum e = distributerBecomeConditionEnumArray[n2];
            DistributerBecomeCondition condition = new DistributerBecomeCondition();
            BaseDomainUtil.initBaseDomain((BaseDomain)condition, (String)appId);
            condition.setCondition(e.value());
            condition.setContent(e.description());
            condition.setSort(sort++);
            condition.setGroupId(groupId);
            list.add(condition);
            ++n2;
        }
        this.mapper.insertBatch(list);
        return list;
    }

    public CrudMapper<DistributerBecomeCondition> getMapper() {
        return this.mapper;
    }
}

