/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.service.impl;

import com.wego168.distribute.domain.DistributerCommissionConfig;
import com.wego168.distribute.enums.TransferWayEnum;
import com.wego168.distribute.persistence.DistributerCommissionConfigMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.BaseDomainUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributerCommissionConfigService
extends CrudService<DistributerCommissionConfig> {
    @Autowired
    private DistributerCommissionConfigMapper mapper;

    public DistributerCommissionConfig select(String appId) {
        DistributerCommissionConfig config = (DistributerCommissionConfig)((Object)this.mapper.selectById(appId));
        if (config == null) {
            return this.initConfig(appId);
        }
        return config;
    }

    private DistributerCommissionConfig initConfig(String appId) {
        DistributerCommissionConfig config = new DistributerCommissionConfig();
        BaseDomainUtil.initBaseDomain((BaseDomain)config, (String)appId);
        config.setId(appId);
        config.setActivityCommissionRate1(1000);
        config.setActivityCommissionFrozenHours(360);
        config.setCourseCommissionRate1(1000);
        config.setCourseCommissionFrozenHours(360);
        config.setOrderCommissionRate1(1000);
        config.setOrderCommissionFrozenHours(360);
        config.setMinPoundage(1);
        config.setMinWithdrawAmount(1);
        config.setPoundageRate(10);
        config.setTransferWay(TransferWayEnum.MANUAL.value());
        config.setGiveDistributerAndSharerCommissionAtSameTime(false);
        config.setOrderCommissionNeedAudit(true);
        this.mapper.insert((Object)config);
        return config;
    }

    public CrudMapper<DistributerCommissionConfig> getMapper() {
        return this.mapper;
    }
}

