/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.service.impl;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.domain.DistributerCommission;
import com.wego168.distribute.domain.DistributerCommissionConfig;
import com.wego168.distribute.domain.Withdraw;
import com.wego168.distribute.enums.DistributerCommissionAuditStatusEnum;
import com.wego168.distribute.enums.DistributerCommissionOrderTypeEnum;
import com.wego168.distribute.enums.DistributerCommissionStatusEnum;
import com.wego168.distribute.model.response.DistributerCommissionAdminPageResponse;
import com.wego168.distribute.model.response.DistributerCommissionAdminPageResponseV2;
import com.wego168.distribute.model.response.DistributerCommissionMemberPageResponse;
import com.wego168.distribute.model.response.DistributerFriendsWebPageResponse;
import com.wego168.distribute.persistence.DistributerCommissionMapper;
import com.wego168.distribute.service.IDistributerCommissionService;
import com.wego168.distribute.service.impl.DistributerCommissionConfigService;
import com.wego168.distribute.service.impl.WithdrawService;
import com.wego168.member.domain.WalletFlow;
import com.wego168.member.enums.WalletBusinessEnum;
import com.wego168.member.enums.WalletTypeEnum;
import com.wego168.member.enums.WalletUserEnum;
import com.wego168.member.model.HasOpenId;
import com.wego168.member.service.impl.WalletFlowService;
import com.wego168.persistence.CrudMapper;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.share.domain.Sharer;
import com.wego168.share.model.response.SharerAdminPageResponseV2;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import com.wego168.wx.enums.ServiceTypeEnum;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DistributerCommissionService
extends CrudService<DistributerCommission>
implements IDistributerCommissionService {
    private static final Logger log = LoggerFactory.getLogger(DistributerCommissionService.class);
    @Autowired
    private DistributerCommissionMapper mapper;
    @Autowired
    private DistributerCommissionConfigService distributerCommissionConfigService;
    @Autowired
    private WalletFlowService walletFlowService;
    @Autowired
    private WithdrawService withdrawService;
    @Autowired
    private SimpleRedisTemplate redisTemplate;
    private static String defaultAppId = "default";

    @Override
    public DistributerCommission create(String distributerId, int distributerLevel, int amount, String orderId, String orderNumber, int orderAmount, String orderBuyer, String storeId) {
        DistributerCommission commission = new DistributerCommission();
        commission.setId(SequenceUtil.createUuid());
        commission.setStoreId(storeId);
        commission.setAppId(defaultAppId);
        commission.setAmount(amount);
        commission.setAuditFinishTime(null);
        commission.setAuditStatus(DistributerCommissionAuditStatusEnum.WAITING_AUDIT.value());
        commission.setAuditTime(null);
        commission.setCreateTime(new Date());
        commission.setDistributerId(distributerId);
        commission.setDistributerLevel(distributerLevel);
        commission.setFromOrderAmount(orderAmount);
        commission.setFromOrderBuyer(orderBuyer);
        commission.setFromOrderId(orderId);
        commission.setFromOrderNumber(orderNumber);
        commission.setIsDeleted(false);
        commission.setNote(null);
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        commission.setNumber(String.valueOf(date) + SequenceUtil.createRandomNumberSequence((int)8));
        commission.setRefuseReason(null);
        commission.setRefuseTime(null);
        commission.setUpdateTime(new Date());
        commission.setType("distributer");
        return commission;
    }

    public List<DistributerCommissionMemberPageResponse> selectPageForMember(String memberId, String fromOrderType, String fromOrderTitle, String status, String type, Page page) {
        page.put((Object)"memberId", (Object)memberId);
        if (StringUtil.isNotBlank((String)fromOrderType)) {
            page.put((Object)"fromOrderType", (Object)fromOrderType);
        }
        if (StringUtil.isNotBlank((String)fromOrderTitle)) {
            page.put((Object)"fromOrderTitle", (Object)("%" + fromOrderTitle + "%"));
        }
        if (StringUtil.isNotBlank((String)status)) {
            page.put((Object)"status", (Object)status);
        }
        int maxLevel = 1;
        page.put((Object)"maxLevel", (Object)maxLevel);
        page.put((Object)"type", (Object)type);
        return this.mapper.selectPageForMember(page);
    }

    public List<DistributerCommissionAdminPageResponse> selectPageForAdmin(String name, String appellation, String mobile, String type, String status, String fromOrderTitle, String appId, Page page) {
        if (StringUtil.isNotBlank((String)name)) {
            page.put((Object)"name", (Object)("%" + name + "%"));
        }
        if (StringUtil.isNotBlank((String)appellation)) {
            page.put((Object)"appellation", (Object)("%" + appellation + "%"));
        }
        if (StringUtil.isNotBlank((String)mobile)) {
            page.put((Object)"mobile", (Object)("%" + mobile + "%"));
        }
        page.put((Object)"type", (Object)type);
        if (StringUtil.isNotBlank((String)status)) {
            page.put((Object)"status", (Object)status);
        }
        if (StringUtil.isNotBlank((String)fromOrderTitle)) {
            page.put((Object)"fromOrderTitle", (Object)("%" + fromOrderTitle + "%"));
        }
        page.put((Object)"appId", (Object)appId);
        int maxLevel = 1;
        page.put((Object)"maxLevel", (Object)maxLevel);
        return this.mapper.selectPageForAdmin(page);
    }

    public List<DistributerCommissionAdminPageResponseV2> selectPageForAdminV2(String buyerAppellation, String sharerName, String sharerMobile, String fromOrderNumber, String type, String status, String fromOrderTitle, String appId, Page page) {
        if (StringUtil.isNotBlank((String)sharerName)) {
            page.put((Object)"sharerName", (Object)("%" + sharerName + "%"));
        }
        if (StringUtil.isNotBlank((String)sharerMobile)) {
            page.put((Object)"sharerMobile", (Object)("%" + sharerMobile + "%"));
        }
        if (StringUtil.isNotBlank((String)buyerAppellation)) {
            page.put((Object)"buyerAppellation", (Object)("%" + buyerAppellation + "%"));
        }
        page.put((Object)"type", (Object)type);
        if (StringUtil.isNotBlank((String)status)) {
            page.put((Object)"status", (Object)status);
        }
        if (StringUtil.isNotBlank((String)fromOrderTitle)) {
            page.put((Object)"fromOrderTitle", (Object)("%" + fromOrderTitle + "%"));
        }
        page.put((Object)"fromOrderNumber", (Object)fromOrderNumber);
        page.put((Object)"appId", (Object)appId);
        int maxLevel = 1;
        page.put((Object)"maxLevel", (Object)maxLevel);
        return this.mapper.selectPageForStoreV2(page);
    }

    public List<DistributerCommissionAdminPageResponseV2> selectPageForStoreV2(String buyerAppellation, String sharerName, String sharerMobile, String type, String status, String fromOrderTitle, String storeId, Page page) {
        if (StringUtil.isNotBlank((String)sharerName)) {
            page.put((Object)"sharerName", (Object)("%" + sharerName + "%"));
        }
        if (StringUtil.isNotBlank((String)sharerMobile)) {
            page.put((Object)"sharerMobile", (Object)("%" + sharerMobile + "%"));
        }
        if (StringUtil.isNotBlank((String)buyerAppellation)) {
            page.put((Object)"buyerAppellation", (Object)("%" + buyerAppellation + "%"));
        }
        page.put((Object)"type", (Object)type);
        if (StringUtil.isNotBlank((String)status)) {
            page.put((Object)"status", (Object)status);
        }
        if (StringUtil.isNotBlank((String)fromOrderTitle)) {
            page.put((Object)"fromOrderTitle", (Object)("%" + fromOrderTitle + "%"));
        }
        page.put((Object)"storeId", (Object)storeId);
        int maxLevel = 1;
        page.put((Object)"maxLevel", (Object)maxLevel);
        return this.mapper.selectPageForStoreV2(page);
    }

    public List<DistributerCommission> selectPreTransferActivityCommission() {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("status", (Object)DistributerCommissionStatusEnum.ONGOING.value());
        criteria.eq("auditStatus", (Object)DistributerCommissionAuditStatusEnum.AUDITED.value());
        criteria.eq("fromOrderType", (Object)DistributerCommissionOrderTypeEnum.ACTIVITY_SIGN.value());
        return this.mapper.selectList(criteria);
    }

    public List<DistributerCommission> selectPreTransferMallOrderCommission() {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("status", (Object)DistributerCommissionStatusEnum.READY.value());
        criteria.eq("auditStatus", (Object)DistributerCommissionAuditStatusEnum.AUDITED.value());
        criteria.eq("fromOrderType", (Object)DistributerCommissionOrderTypeEnum.MALL_ORDER.value());
        return this.mapper.selectList(criteria);
    }

    @Transactional
    public void transferToWallet(DistributerCommission commissionDb) {
        String type = WalletTypeEnum.INCOME.value();
        String businessType = this.determineWalletBusinessType(commissionDb);
        String businessId = this.determineWalletBusinessId(commissionDb);
        String distributerId = commissionDb.getDistributerId();
        int amount = commissionDb.getAmount();
        String orderTitle = commissionDb.getFromOrderTitle();
        String appId = commissionDb.getAppId();
        int appType = ServiceTypeEnum.PROGRAM.id();
        WalletFlow flow = this.walletFlowService.build(distributerId, amount, orderTitle, type, businessId, businessType, appId, Integer.valueOf(appType));
        this.walletFlowService.produce(new WalletFlow[]{flow});
        DistributerCommission param = new DistributerCommission();
        param.setId(commissionDb.getId());
        param.setStatus(DistributerCommissionStatusEnum.FINISH.value());
        param.setUpdateTime(new Date());
        this.mapper.updateSelective((Object)param);
    }

    public int sumCustomerQuantity(String distributerId) {
        String type = "distributer";
        Integer quantity = this.mapper.sumCustomerQuantity(distributerId, type);
        quantity = quantity == null ? 0 : quantity;
        return quantity;
    }

    public int sumCustomerOrderQuantity(String distributerId, String type) {
        String[] statusArray = new String[]{DistributerCommissionStatusEnum.FINISH.value(), DistributerCommissionStatusEnum.ONGOING.value()};
        Integer quantity = this.mapper.sumCustomerOrderQuantity(distributerId, statusArray, type);
        quantity = quantity == null ? 0 : quantity;
        return quantity;
    }

    public int sumCustomerOrderAmount(String distributerId, String type) {
        String[] statusArray = new String[]{DistributerCommissionStatusEnum.FINISH.value(), DistributerCommissionStatusEnum.ONGOING.value(), DistributerCommissionStatusEnum.READY.value()};
        Integer amount = this.mapper.sumCustomerOrderAmount(distributerId, statusArray, type);
        amount = amount == null ? 0 : amount;
        return amount;
    }

    public int sumCommissionAmount(String distributerId, String type) {
        String[] statusArray = new String[]{DistributerCommissionStatusEnum.FINISH.value(), DistributerCommissionStatusEnum.ONGOING.value(), DistributerCommissionStatusEnum.CANCEL.value(), DistributerCommissionStatusEnum.READY.value()};
        Integer amount = this.mapper.sumCommissionAmount(distributerId, statusArray, type);
        amount = amount == null ? 0 : amount;
        return amount;
    }

    @Async
    public void updateSharerCommissionAmountAsync(String sharerId, String appId) {
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String type = "sharer";
        int sum = this.sumCommissionAmount(sharerId, type);
        String redisKey = "sharer-commission-amount-" + appId;
        String mapKey = sharerId;
        this.redisTemplate.putMap(redisKey, mapKey, (Object)sum);
    }

    public List<SharerAdminPageResponseV2> assembleCommission(List<SharerAdminPageResponseV2> list, String appId) {
        if (Checker.listNotEmpty(list)) {
            String redisKey = "sharer-commission-amount-" + appId;
            Map commissionMap = this.redisTemplate.getMap(redisKey);
            for (SharerAdminPageResponseV2 e : list) {
                String sharerId = e.getId();
                Object commission = commissionMap.get(sharerId);
                if (commission == null) continue;
                e.setCommission((Integer)commission);
            }
        }
        return list;
    }

    public int sumTotalCommissionAmount(String distributerId, String type) {
        String[] statusArray = new String[]{DistributerCommissionStatusEnum.FINISH.value(), DistributerCommissionStatusEnum.ONGOING.value(), DistributerCommissionStatusEnum.CANCEL.value(), DistributerCommissionStatusEnum.READY.value()};
        Integer amount = this.mapper.sumCommissionAmount(distributerId, statusArray, type);
        amount = amount == null ? 0 : amount;
        return amount;
    }

    @Transactional
    public Withdraw sharerWithdraw(Sharer sharer, int amount, int poundage, String transferMerchantId) {
        String memberId = sharer.getId();
        String account = sharer.getWithdrawAccount();
        String accountType = sharer.getWithdrawAccountType();
        String name = sharer.getWithdrawName();
        boolean needAudit = false;
        String appId = sharer.getAppId();
        String mobile = sharer.getMobile();
        Withdraw withdraw = this.withdrawService.apply(amount, poundage, account, accountType, name, mobile, memberId, needAudit, transferMerchantId, appId);
        String businessId = withdraw.getId();
        String businessType = WalletBusinessEnum.WITHDRAW.value();
        this.walletFlowService.withdraw(amount, memberId, null, businessId, businessType, appId);
        return withdraw;
    }

    @Transactional
    public Withdraw distributerWithdraw(Distributer distributer, int amount, int poundage, String transferMerchantId) {
        String memberId = distributer.getId();
        String account = distributer.getWithdrawAccount();
        String accountType = distributer.getWithdrawAccountType();
        String name = distributer.getWithdrawName();
        boolean needAudit = false;
        String appId = distributer.getAppId();
        String mobile = distributer.getMobile();
        Withdraw withdraw = this.withdrawService.apply(amount, poundage, account, accountType, name, mobile, memberId, needAudit, transferMerchantId, appId);
        String businessId = withdraw.getId();
        String businessType = WalletBusinessEnum.WITHDRAW.value();
        this.walletFlowService.withdraw(amount, memberId, null, businessId, businessType, appId);
        return withdraw;
    }

    public Map<String, Integer> selectCommissionAsMap(List<? extends HasOpenId> openIdList, String memberId, int level, String type) {
        List<DistributerFriendsWebPageResponse> list2;
        String[] statusArray = new String[]{DistributerCommissionStatusEnum.ONGOING.value(), DistributerCommissionStatusEnum.FINISH.value()};
        List<DistributerFriendsWebPageResponse> list = this.mapper.selectCustomerCommission(openIdList, statusArray, memberId, type);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Checker.checkCondition((level > 2 || level < 1 ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u7b49\u7ea7");
        if (Checker.listNotEmpty(list)) {
            for (DistributerFriendsWebPageResponse response : list) {
                String openId = response.getOpenId();
                Integer commission = response.getCommission();
                commission = commission == null ? 0 : commission;
                map.put(openId, commission);
            }
        }
        if (level == 2 && Checker.listNotEmpty(list2 = this.mapper.selectCustomerCommission2(openIdList, statusArray, memberId, type))) {
            for (DistributerFriendsWebPageResponse response : list2) {
                String openId = response.getOpenId();
                Integer commission = response.getCommission();
                commission = commission == null ? 0 : commission;
                if (map.containsKey(openId)) {
                    map.put(openId, (Integer)map.get(openId) + commission);
                    continue;
                }
                map.put(openId, commission);
            }
        }
        return map;
    }

    public Map<String, Integer> selectOrderAmountAsMap(List<? extends HasOpenId> openIdList, String memberId) {
        List<DistributerFriendsWebPageResponse> list = this.mapper.selectCustomerOrderAmount(openIdList, memberId);
        HashMap<String, Integer> commissionMap = new HashMap<String, Integer>();
        if (Checker.listNotEmpty(openIdList)) {
            for (DistributerFriendsWebPageResponse response : list) {
                String openId = response.getOpenId();
                Integer commission = response.getCommission();
                commission = commission == null ? 0 : commission;
                commissionMap.put(openId, commission);
            }
        }
        return commissionMap;
    }

    public void cancelCommissionByOrderId(String orderId, String note) {
        DistributerCommission param = new DistributerCommission();
        param.setUpdateTime(new Date());
        param.setNote(note);
        param.setStatus(DistributerCommissionStatusEnum.CANCEL.value());
        JpaCriteria criteria = JpaCriteria.builder((Object)((Object)param));
        criteria.eq("fromOrderId", (Object)orderId);
        this.mapper.updateSelective(criteria);
        List list = this.mapper.selectList(criteria);
        if (Checker.listNotEmpty((List)list)) {
            for (DistributerCommission distributerCommission : list) {
                this.updateSharerCommissionAmountAsync(distributerCommission.getDistributerId(), distributerCommission.getAppId());
            }
        }
    }

    public void updateCommissionWhenOrderFinished(String orderId, String appId) {
        log.error("\u8ba2\u5355\u5b8c\u6210\uff0c\u7ed3\u7b97\u4f63\u91d1...{},{}", (Object)orderId, (Object)appId);
        List<DistributerCommission> list = this.selectOngoingListByOrderId(orderId);
        if (Checker.listNotEmpty(list)) {
            DistributerCommissionConfig config = this.distributerCommissionConfigService.select(appId);
            boolean needAudit = config.getOrderCommissionNeedAudit();
            for (DistributerCommission e : list) {
                int appType = WxAppServiceTypeEnum.MINI_PROGRAM.value();
                WalletFlow flow = this.walletFlowService.build(e.getStoreId(), e.getAmount().intValue(), e.getFromOrderTitle(), WalletTypeEnum.DEDUCT_SHARER_COMMISSION.value(), orderId, WalletBusinessEnum.MALL_ORDER_COMMISSION.value(), appId, Integer.valueOf(appType));
                flow.setUserType(WalletUserEnum.STORE.name());
                this.walletFlowService.consume(new WalletFlow[]{flow});
                DistributerCommission param = new DistributerCommission();
                param.setId(e.getId());
                param.setStatus(DistributerCommissionStatusEnum.READY.value());
                if (!needAudit) {
                    param.setAuditStatus(DistributerCommissionAuditStatusEnum.AUDITED.value());
                    param.setAuditTime(new Date());
                }
                this.updateSelective((Object)param);
            }
        }
    }

    public List<DistributerCommission> selectOngoingListByOrderId(String orderId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("fromOrderId", (Object)orderId);
        criteria.eq("fromOrderType", (Object)DistributerCommissionOrderTypeEnum.MALL_ORDER.value());
        criteria.eq("status", (Object)DistributerCommissionStatusEnum.ONGOING.value());
        List list = this.mapper.selectList(criteria);
        return list;
    }

    public CrudMapper<DistributerCommission> getMapper() {
        return this.mapper;
    }

    private String determineWalletBusinessType(DistributerCommission commissionDb) {
        String fromOrderType = commissionDb.getFromOrderType();
        String businessType = null;
        if (StringUtil.equals((String)fromOrderType, (String)DistributerCommissionOrderTypeEnum.ACTIVITY_SIGN.value())) {
            businessType = WalletBusinessEnum.SIGN_COMMISSION.value();
        } else if (StringUtil.equals((String)fromOrderType, (String)DistributerCommissionOrderTypeEnum.COURSE_VIP_PURCHASE.value())) {
            businessType = WalletBusinessEnum.COURSE_VIP_COMMISSION.value();
        } else if (StringUtil.equals((String)fromOrderType, (String)DistributerCommissionOrderTypeEnum.MALL_ORDER.value())) {
            businessType = WalletBusinessEnum.MALL_ORDER_COMMISSION.value();
        }
        Checker.checkBlank((String)businessType, (String)"\u94b1\u5305\u91d1\u989d\u6765\u6e90\u7c7b\u578b");
        return businessType;
    }

    private String determineWalletBusinessId(DistributerCommission commissionDb) {
        String fromOrderType = commissionDb.getFromOrderType();
        String businessId = null;
        if (StringUtil.equals((String)fromOrderType, (String)DistributerCommissionOrderTypeEnum.ACTIVITY_SIGN.value())) {
            businessId = commissionDb.getFromOrderId();
        } else if (StringUtil.equals((String)fromOrderType, (String)DistributerCommissionOrderTypeEnum.COURSE_VIP_PURCHASE.value())) {
            businessId = commissionDb.getFromOrderId();
        } else if (StringUtil.equals((String)fromOrderType, (String)DistributerCommissionOrderTypeEnum.MALL_ORDER.value())) {
            businessId = commissionDb.getFromOrderId();
        }
        Checker.checkBlank((String)businessId, (String)"\u94b1\u5305\u91d1\u989d\u6765\u6e90id");
        return businessId;
    }
}

