/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.service.impl;

import com.simple.mybatis.JpaCriteria;
import com.wego168.distribute.domain.DistributerQrcode;
import com.wego168.distribute.enums.DistributerQrcodeTypeEnum;
import com.wego168.distribute.persistence.DistributerQrcodeMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributerQrcodeService
extends BaseService<DistributerQrcode> {
    @Autowired
    private DistributerQrcodeMapper mapper;

    public CrudMapper<DistributerQrcode> getMapper() {
        return this.mapper;
    }

    public DistributerQrcode createQrcode(String scene, String url, String memberId, String targetId, String targetType, String ownerType, Integer showStyle, String appId, String serverId, String targetParam) {
        DistributerQrcode qrcode = new DistributerQrcode();
        BaseDomainUtil.initBaseDomain((BaseDomain)qrcode, (String)appId);
        qrcode.setMemberId(memberId);
        qrcode.setOwnerType(ownerType);
        qrcode.setScene(scene);
        qrcode.setServerId(serverId);
        qrcode.setShowStyle(showStyle);
        qrcode.setTargetId(targetId);
        qrcode.setTargetName("");
        qrcode.setTargetType(targetType);
        qrcode.setTargetParam(targetParam);
        qrcode.setType(DistributerQrcodeTypeEnum.MINI_PROGRAM.value());
        qrcode.setUrl(url);
        return qrcode;
    }

    public DistributerQrcode selectByScene(String scene, String appId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("scene", (Object)scene);
        criteria.eq("appId", (Object)appId);
        return (DistributerQrcode)((Object)this.mapper.select(criteria));
    }

    public DistributerQrcode selectByTarget(String memberId, String ownerType, String targetType, String targetId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("memberId", (Object)memberId);
        criteria.eq("targetType", (Object)targetType);
        criteria.eq("ownerType", (Object)ownerType);
        criteria.eq("targetId", (Object)targetId);
        criteria.orderBy("createTime DESC");
        List list = this.mapper.selectList(criteria);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (DistributerQrcode)((Object)list.get(0));
    }
}

