/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.service.impl;

import com.simple.mybatis.JpaCriteria;
import com.wego168.distribute.domain.DistributerRegistField;
import com.wego168.distribute.domain.DistributerRegistFieldData;
import com.wego168.distribute.model.response.DistributerRegistFieldDataMemberListResponse;
import com.wego168.distribute.persistence.DistributerRegistFieldDataMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.SequenceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributerRegistFieldDataService
extends BaseService<DistributerRegistFieldData> {
    @Autowired
    private DistributerRegistFieldDataMapper mapper;

    public CrudMapper<DistributerRegistFieldData> getMapper() {
        return this.mapper;
    }

    public List<DistributerRegistFieldData> create(List<DistributerRegistField> fieldList, Map<String, String> registrationData, String distributerId) {
        ArrayList<DistributerRegistFieldData> dataList = new ArrayList<DistributerRegistFieldData>(fieldList.size());
        String batch = SequenceUtil.createRandomLowerCaseLetterAndNumberSequence((int)8);
        for (DistributerRegistField field : fieldList) {
            DistributerRegistFieldData data = new DistributerRegistFieldData();
            BaseDomainUtil.initBaseDomain((BaseDomain)data, (String)fieldList.get(0).getAppId());
            data.setBatch(batch);
            data.setDistributerId(distributerId);
            data.setName(field.getName());
            data.setSort(field.getSort());
            data.setValue(registrationData.get(field.getId()));
            dataList.add(data);
        }
        return dataList;
    }

    public List<DistributerRegistFieldDataMemberListResponse> selectListByDistributerId(String distributerId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("distributerId", (Object)distributerId);
        criteria.orderBy("sort ASC");
        return this.selectList(criteria, DistributerRegistFieldDataMemberListResponse.class);
    }

    public void refresh(List<DistributerRegistFieldData> dataList) {
        String distributerId = dataList.get(0).getDistributerId();
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("distributerId", (Object)distributerId);
        this.mapper.delete(criteria);
        this.mapper.insertBatch(dataList);
    }
}

