/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.service.impl;

import com.simple.mybatis.JpaCriteria;
import com.wego168.distribute.domain.DistributerRegistField;
import com.wego168.distribute.enums.FieldTypeEnum;
import com.wego168.distribute.model.DistributerRegistData;
import com.wego168.distribute.persistence.DistributerRegistFieldMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributerRegistFieldService
extends BaseService<DistributerRegistField> {
    @Autowired
    private DistributerRegistFieldMapper mapper;

    public CrudMapper<DistributerRegistField> getMapper() {
        return this.mapper;
    }

    public DistributerRegistData checkRegistrationData(Map<String, String> registrationData, String appId) {
        List<DistributerRegistField> fieldList = this.selectList(appId);
        return this.checkRegistrationData(registrationData, fieldList);
    }

    public DistributerRegistData checkRegistrationData(Map<String, String> registrationData, List<DistributerRegistField> fieldList) {
        String name = null;
        String mobile = null;
        for (DistributerRegistField field : fieldList) {
            String fieldCode = field.getField();
            String fieldId = field.getId();
            String value = registrationData.get(fieldId);
            this.checkValue(value, field);
            if (StringUtil.equals((String)fieldCode, (String)"name")) {
                name = value;
            }
            if (!StringUtil.equals((String)fieldCode, (String)"mobile")) continue;
            mobile = value;
        }
        DistributerRegistData registrationDataResponse = new DistributerRegistData();
        registrationDataResponse.setName(name);
        registrationDataResponse.setMobile(mobile);
        return registrationDataResponse;
    }

    public List<DistributerRegistField> selectList(String appId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("appId", (Object)appId);
        criteria.eq("isDeleted", (Object)false);
        criteria.orderBy("sort ASC");
        List<DistributerRegistField> list = this.mapper.selectList(criteria);
        if (list == null || list.size() == 0) {
            list = this.init(appId);
        }
        return list;
    }

    private Map<String, DistributerRegistField> selectMap(String appId) {
        List<DistributerRegistField> list = this.selectList(appId);
        HashMap<String, DistributerRegistField> map = new HashMap<String, DistributerRegistField>();
        for (DistributerRegistField field : list) {
            map.put(field.getId(), field);
        }
        return map;
    }

    private List<DistributerRegistField> init(String appId) {
        ArrayList<DistributerRegistField> list = new ArrayList<DistributerRegistField>(2);
        DistributerRegistField name = new DistributerRegistField();
        BaseDomainUtil.initBaseDomain((BaseDomain)name, (String)appId);
        name.setField("name");
        name.setMaxLength(16);
        name.setMinLength(0);
        name.setName("\u59d3\u540d");
        name.setNotBlank(true);
        name.setSort(1);
        name.setSystem(true);
        name.setType(FieldTypeEnum.TEXT.value());
        list.add(name);
        DistributerRegistField mobile = new DistributerRegistField();
        BaseDomainUtil.initBaseDomain((BaseDomain)mobile, (String)appId);
        mobile.setField("mobile");
        mobile.setMaxLength(11);
        mobile.setMinLength(0);
        mobile.setName("\u624b\u673a\u53f7\u7801");
        mobile.setNotBlank(true);
        mobile.setSort(2);
        mobile.setSystem(true);
        mobile.setType(FieldTypeEnum.MOBILE.value());
        list.add(mobile);
        this.mapper.insertBatch(list);
        return list;
    }

    private void checkValue(String value, DistributerRegistField field) {
        String fieldName = field.getName();
        int maxLength = field.getMaxLength();
        String type = field.getType();
        if (StringUtil.equals((String)type, (String)FieldTypeEnum.MOBILE.value())) {
            Checker.checkMobilePhoneNumber((String)value);
        } else if (StringUtil.equals((String)type, (String)FieldTypeEnum.NUMBER.value())) {
            int intValue = Checker.checkStringIsPositiveInteger((String)value, (String)fieldName);
            Checker.checkCondition((intValue > maxLength ? 1 : 0) != 0, (String)(String.valueOf(fieldName) + "\u4e0d\u80fd\u8d85\u8fc7" + maxLength));
        } else if (StringUtil.equals((String)type, (String)FieldTypeEnum.TEXT.value())) {
            boolean notBlank = field.getNotBlank();
            if (notBlank) {
                if (maxLength > 0) {
                    Checker.checkBlankAndLength((String)value, (String)fieldName, (int)maxLength);
                } else {
                    Checker.checkBlank((String)value, (String)fieldName);
                }
            } else if (maxLength > 0) {
                Checker.checkBlankOrLength((String)value, (String)fieldName, (int)maxLength);
            } else {
                Checker.checkBlank((String)value, (String)fieldName);
            }
        }
    }
}

