/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.service.impl;

import com.simple.mybatis.JpaCriteria;
import com.wego168.authority.domain.SysAccount;
import com.wego168.authority.domain.SysAccountRole;
import com.wego168.authority.enums.SysAccountTypeEnum;
import com.wego168.authority.persistence.SysAccountMapper;
import com.wego168.authority.persistence.SysAccountRoleMapper;
import com.wego168.distribute.domain.DistributeChain;
import com.wego168.distribute.domain.DistributeLink;
import com.wego168.distribute.domain.DistributeOpenIdChain;
import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.domain.DistributerAccount;
import com.wego168.distribute.enums.DistributerStatusEnum;
import com.wego168.distribute.enums.WithdrawAccountTypeEnum;
import com.wego168.distribute.model.DistributerRegistData;
import com.wego168.distribute.persistence.DistributeChainMapper;
import com.wego168.distribute.persistence.DistributeLinkMapper;
import com.wego168.distribute.persistence.DistributeOpenIdChainMapper;
import com.wego168.distribute.persistence.DistributerAccountMapper;
import com.wego168.distribute.persistence.DistributerMapper;
import com.wego168.distribute.service.IDistributeChainService;
import com.wego168.distribute.service.IDistributeLinkService;
import com.wego168.distribute.service.IDistributerAccountService;
import com.wego168.distribute.service.IDistributerService;
import com.wego168.distribute.service.impl.DistributeOpenIdChainService;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DistributerService
extends BaseService<Distributer>
implements IDistributerService {
    @Autowired
    protected SysAccountMapper sysAccountMapper;
    @Autowired
    protected SysAccountRoleMapper sysAccountRoleMapper;
    @Autowired
    protected DistributeChainMapper distributeChainMapper;
    @Autowired
    protected DistributeOpenIdChainMapper distributeOpenIdChainMapper;
    @Autowired
    protected DistributeLinkMapper distributeLinkMapper;
    @Autowired
    protected DistributerMapper distributerMapper;
    @Autowired
    protected IDistributeChainService distributerChainService;
    @Autowired
    protected DistributeOpenIdChainService distributeOpenIdChainService;
    @Autowired
    protected IDistributeLinkService distributeLinkService;
    @Autowired
    protected DistributerAccountMapper distributerAccountMapper;
    @Autowired
    protected MemberAccountService memberAccountService;
    @Autowired
    protected MemberService memberService;
    @Autowired
    protected IDistributerAccountService distributerAccountService;
    protected static int defaultNumberLength = 10;

    public Distributer createByStore(String name, String mobile, String number, String storeId, String withdrawAccount, String appId) {
        Distributer distributer = new Distributer();
        distributer.setAppId(appId);
        distributer.setId(SequenceUtil.createUuid());
        distributer.setCreateTime(new Date());
        distributer.setIsDeleted(false);
        distributer.setMobile(mobile);
        distributer.setName(name);
        if (StringUtil.isBlank((String)number)) {
            number = SequenceUtil.createRandomNumberSequence((int)defaultNumberLength);
        }
        distributer.setNumber(number);
        distributer.setStoreId(storeId);
        distributer.setUpdateTime(new Date());
        distributer.setWithdrawAccount(withdrawAccount);
        distributer.setWithdrawAccountType(WithdrawAccountTypeEnum.APLIPAY.value());
        distributer.setStatus(DistributerStatusEnum.AUDITED.value());
        distributer.setType("default");
        return distributer;
    }

    @Override
    public Distributer selectByNumber(String number, String appId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("number", (Object)number).eq("appId", (Object)appId);
        return (Distributer)((Object)this.distributerMapper.select(criteria));
    }

    @Override
    public Distributer selectByMobile(String mobile, String appId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("mobile", (Object)mobile).eq("appId", (Object)appId);
        return (Distributer)((Object)this.distributerMapper.select(criteria));
    }

    @Override
    public Distributer selectById(String id) {
        return (Distributer)((Object)this.distributerMapper.selectById(id));
    }

    @Override
    public Distributer selectByMemberId(String memberId) {
        return this.distributerMapper.selectByMemberId(memberId);
    }

    public String ensureMemberAndAccountWhenRegist(DistributerRegistData distributerRegistData, String openId, String unionId, String appId) {
        MemberAccount mobileAccount;
        MemberAccount openWechatAccount;
        MemberAccount distibuterWechatAccount = this.memberAccountService.selectByUsername(openId, appId);
        String name = distributerRegistData.getName();
        String mobile = distributerRegistData.getMobile();
        if (distibuterWechatAccount == null) {
            int defaultSex = 0;
            Member member = this.memberService.createByWechat(name, null, Integer.valueOf(defaultSex));
            member.setMobilePhoneNumber(mobile);
            member.setAppId(appId);
            member.setName(name);
            String memberId = member.getId();
            MemberAccount wechatAccount = this.memberAccountService.createWechatAccount(openId, memberId, appId);
            MemberAccount mobileAccount2 = null;
            if (StringUtil.isNotBlank((String)mobile)) {
                mobileAccount2 = this.memberAccountService.createMobileAccount(mobile, memberId, appId);
            }
            MemberAccount openWechatAccount2 = null;
            if (StringUtil.isNotBlank((String)unionId)) {
                openWechatAccount2 = this.memberAccountService.createOpenWechatAccount(unionId, memberId, appId);
            }
            this.memberService.registInWechatWithMobile(member, wechatAccount, mobileAccount2, openWechatAccount2);
            return member.getId();
        }
        String memberId = distibuterWechatAccount.getMemberId();
        if (StringUtil.isNotBlank((String)unionId) && (openWechatAccount = this.memberAccountService.selectWechatAccount(memberId)) == null) {
            openWechatAccount = this.memberAccountService.createOpenWechatAccount(unionId, memberId, appId);
            this.memberAccountService.insert((Object)openWechatAccount);
        }
        if (StringUtil.isNotBlank((String)mobile) && (mobileAccount = this.memberAccountService.selectMobileAccount(memberId)) == null) {
            mobileAccount = this.memberAccountService.createMobileAccount(mobile, memberId, appId);
            this.memberAccountService.insert((Object)mobileAccount);
        }
        return memberId;
    }

    @Override
    @Transactional
    public void registByMobile(MemberAccount wechatAccount, MemberAccount mobileAccount, String mobile, String name, String openId, String appId) {
        if (mobileAccount != null) {
            String memberId = mobileAccount.getMemberId();
            String number = SequenceUtil.createRandomNumberSequence((int)12);
            Distributer distributer = this.createByStore(name, mobile, number, appId, null, appId);
            distributer.setId(memberId);
            DistributerAccount mobileDistributerAccount = this.distributerAccountService.createMobileAccount(mobile, memberId, appId);
            DistributerAccount wechatDistributerAccount = null;
            if (StringUtil.isNotBlank((String)openId)) {
                wechatDistributerAccount = this.distributerAccountService.createWechatAccount(openId, memberId, appId);
            }
            this.distributerMapper.insert((Object)distributer);
            this.distributerAccountMapper.insert((Object)mobileDistributerAccount);
            if (wechatDistributerAccount != null) {
                this.distributerAccountMapper.insert((Object)wechatDistributerAccount);
            }
        } else {
            String number = SequenceUtil.createRandomNumberSequence((int)12);
            Distributer distributer = this.createByStore(name, mobile, number, appId, null, appId);
            if (wechatAccount == null) {
                this.memberService.registInWechatWithMobile(openId, null, appId, name, null, null, mobile);
            } else {
                distributer.setId(wechatAccount.getMemberId());
                this.memberService.updateMobileBind(mobile, wechatAccount.getMemberId());
            }
            DistributerAccount mobileDistributerAccount = this.distributerAccountService.createMobileAccount(mobile, distributer.getId(), appId);
            DistributerAccount wechatDistributerAccount = null;
            if (StringUtil.isNotBlank((String)openId)) {
                wechatDistributerAccount = this.distributerAccountService.createWechatAccount(openId, distributer.getId(), appId);
            }
            this.distributerMapper.insert((Object)distributer);
            this.distributerAccountMapper.insert((Object)mobileDistributerAccount);
            if (wechatDistributerAccount != null) {
                this.distributerAccountMapper.insert((Object)wechatDistributerAccount);
            }
        }
    }

    @Override
    public void audit(String id) {
        Distributer distributer = new Distributer();
        distributer.setId(id);
        distributer.setStatus(DistributerStatusEnum.AUDITED.value());
        this.distributerMapper.updateSelective((Object)distributer);
    }

    @Override
    public Distributer selectAuditedById(String id) {
        JpaCriteria criteria = JpaCriteria.builder().eq("id", (Object)id).eq("status", (Object)DistributerStatusEnum.AUDITED.value());
        return (Distributer)((Object)this.distributerMapper.select(criteria));
    }

    @Override
    @Transactional
    public Distributer transferMember(Member member, String appId, SysAccount sysAccount, String distributerRoleId) {
        String memberId = member.getId();
        MemberAccount wechatAccount = this.memberAccountService.selectWechatAccount(memberId);
        if (wechatAccount != null) {
            String openId = wechatAccount.getUsername();
            DistributerAccount distributerWechatAccount = this.distributerAccountService.createWechatAccount(openId, memberId, appId);
            this.distributerAccountMapper.insert((Object)distributerWechatAccount);
        }
        String number = SequenceUtil.createRandomNumberSequence((int)12);
        Distributer distributer = this.createByStore(member.getName(), member.getMobilePhoneNumber(), number, appId, null, appId);
        distributer.setId(memberId);
        MemberAccount mobileAccount = this.memberAccountService.selectMobileAccount(memberId);
        if (mobileAccount != null) {
            String mobile = mobileAccount.getUsername();
            DistributerAccount distributerMobileAccount = this.distributerAccountService.createMobileAccount(mobile, memberId, appId);
            this.distributerAccountMapper.insert((Object)distributerMobileAccount);
        }
        DistributeChain chain = this.distributerChainService.createSystemVirtualChain(memberId, appId);
        this.distributeChainMapper.insert(chain);
        DistributeLink link = this.distributeLinkService.create(memberId, appId);
        this.distributeLinkMapper.insert(link);
        this.distributerMapper.insert((Object)distributer);
        sysAccount.setUserId(memberId);
        sysAccount.setType(Integer.valueOf(SysAccountTypeEnum.DISTRIBUTER_ACCOUNT.value()));
        this.sysAccountMapper.insert((Object)sysAccount);
        SysAccountRole sysAccountRole = new SysAccountRole();
        sysAccountRole.setAccountId(sysAccount.getId());
        sysAccountRole.setRoleId(distributerRoleId);
        this.sysAccountRoleMapper.insert((Object)sysAccountRole);
        return distributer;
    }

    @Override
    @Transactional
    public Distributer transferMemberWithoutAccount(Member member, String openId) {
        String memberId = member.getId();
        String number = SequenceUtil.createRandomNumberSequence((int)12);
        String appId = member.getAppId();
        Distributer distributer = this.createByStore(member.getName(), member.getMobilePhoneNumber(), number, appId, null, appId);
        distributer.setId(memberId);
        this.distributerMapper.insert((Object)distributer);
        List<DistributeChain> upperChainList = this.distributerChainService.listUpperChainsExcludeSystemVirtualChain(member.getId());
        if (upperChainList == null || upperChainList.size() == 0) {
            DistributeChain chain = this.distributerChainService.createSystemVirtualChain(memberId, appId);
            this.distributeChainMapper.insert(chain);
        }
        if (StringUtil.isBlank((String)this.distributeOpenIdChainService.getUpperOpenId(openId))) {
            DistributeOpenIdChain openIdChain = this.distributeOpenIdChainService.createSystemVirtualChain(openId, appId);
            this.distributeOpenIdChainMapper.insert(openIdChain);
        }
        return distributer;
    }

    public CrudMapper<Distributer> getMapper() {
        return this.distributerMapper;
    }

    @Override
    public void forbid(String id) {
        Distributer distributer = new Distributer();
        distributer.setStatus(DistributerStatusEnum.FORBIDDEN.value());
        distributer.setId(id);
        this.distributerMapper.updateSelective((Object)distributer);
    }

    @Override
    public void unForbid(String id) {
        Distributer distributer = new Distributer();
        distributer.setStatus(DistributerStatusEnum.AUDITED.value());
        distributer.setId(id);
        this.distributerMapper.updateSelective((Object)distributer);
    }
}

