/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.service.impl;

import com.simple.mybatis.JpaCriteria;
import com.wego168.distribute.domain.Withdraw;
import com.wego168.distribute.domain.WithdrawProgress;
import com.wego168.distribute.enums.WithdrawProgressStatusEnum;
import com.wego168.distribute.enums.WithdrawStatusEnum;
import com.wego168.distribute.enums.WithdrawTransferStatusEnum;
import com.wego168.distribute.persistence.WithdrawMapper;
import com.wego168.distribute.persistence.WithdrawProgressMapper;
import com.wego168.domain.BaseDomain;
import com.wego168.member.domain.WalletFlow;
import com.wego168.member.enums.WalletBusinessEnum;
import com.wego168.member.persistence.WalletFlowMapper;
import com.wego168.member.service.impl.WalletFlowService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.util.BaseDomainUtil;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WithdrawProgressService
extends BaseService<WithdrawProgress> {
    @Autowired
    private WithdrawMapper withdrawMapper;
    @Autowired
    private WalletFlowMapper walletFlowMapper;
    @Autowired
    private WalletFlowService walletFlowService;
    @Autowired
    private WithdrawProgressMapper mapper;

    @Transactional
    public WithdrawProgress apply(Withdraw withdraw, boolean needAudit) {
        WithdrawProgress progress = new WithdrawProgress();
        BaseDomainUtil.initBaseDomain((BaseDomain)progress, (String)withdraw.getAppId());
        progress.setOperator(withdraw.getAccountId());
        if (needAudit) {
            progress.setTitle("\u63d0\u4ea4\u63d0\u73b0\u7533\u8bf7");
            progress.setContent("\u7533\u8bf7\u63d0\u4ea4\u6210\u529f\uff0c\u6b63\u5728\u7b49\u5f85\u5ba1\u6838");
            progress.setRemark("\u9884\u8ba11~3\u4e2a\u5de5\u4f5c\u65e5\u5185\u5ba1\u6838\u5b8c\u6210");
            progress.setStatus(WithdrawProgressStatusEnum.WAITING_AUDIT.value());
        } else {
            progress.setTitle("\u63d0\u4ea4\u63d0\u73b0\u7533\u8bf7\u6210\u529f");
            progress.setContent("\u7533\u8bf7\u63d0\u4ea4\u6210\u529f\uff0c\u6b63\u5728\u7b49\u5f85\u6253\u6b3e");
            progress.setRemark("\u9884\u8ba11~3\u4e2a\u5de5\u4f5c\u65e5\u5185\u5230\u8d26");
            progress.setStatus(WithdrawProgressStatusEnum.WAITING_TRANSFER.value());
        }
        progress.setWithdrawId(withdraw.getId());
        this.mapper.insert((Object)progress);
        return progress;
    }

    @Transactional
    public WithdrawProgress tranfering(String id, String appId, String transactionNumber, String operator) {
        Withdraw param = new Withdraw();
        param.setId(id);
        param.setTransferTime(new Date());
        param.setTransferStatus(WithdrawTransferStatusEnum.ONGOING.value());
        param.setTransactionNumber(transactionNumber);
        this.withdrawMapper.updateSelective((Object)param);
        WithdrawProgress progress = new WithdrawProgress();
        BaseDomainUtil.initBaseDomain((BaseDomain)progress, (String)appId);
        progress.setOperator(operator);
        progress.setTitle("\u6253\u6b3e\u4e2d");
        progress.setContent("\u6253\u6b3e\u63d0\u4ea4\u6210\u529f\uff0c\u6b63\u5728\u7b49\u5f85\u5230\u8d26");
        progress.setRemark("\u4ea4\u6613\u5355\u53f7\uff1a" + transactionNumber);
        progress.setStatus(WithdrawProgressStatusEnum.TRANSFERRING.value());
        progress.setWithdrawId(id);
        this.mapper.insert((Object)progress);
        return progress;
    }

    @Transactional
    public WithdrawProgress tranferSuccess(String id, String appId, String transactionNumber, String transferTicket, String operator) {
        Withdraw param = new Withdraw();
        param.setId(id);
        param.setTransferTime(new Date());
        param.setTransferStatus(WithdrawTransferStatusEnum.FINISH.value());
        param.setStatus(WithdrawStatusEnum.FINISH.value());
        param.setTransactionNumber(transactionNumber);
        param.setTransferTicket(transferTicket);
        param.setReceiveTime(new Date());
        this.withdrawMapper.updateSelective((Object)param);
        WithdrawProgress progress = new WithdrawProgress();
        BaseDomainUtil.initBaseDomain((BaseDomain)progress, (String)appId);
        progress.setOperator(operator);
        progress.setTitle("\u6253\u6b3e\u6210\u529f");
        progress.setContent("\u8d44\u91d1\u5df2\u5230\u8fbe\u6307\u5b9a\u8d26\u6237");
        progress.setRemark("\u4ea4\u6613\u5355\u53f7\uff1a" + transactionNumber);
        progress.setStatus(WithdrawProgressStatusEnum.RECEIVED.value());
        progress.setWithdrawId(id);
        this.mapper.insert((Object)progress);
        return progress;
    }

    public WithdrawProgress tranferFail(String id, String appId, String failMessage, String operator) {
        Withdraw param = new Withdraw();
        param.setId(id);
        param.setTransferTime(new Date());
        param.setTransferStatus(WithdrawTransferStatusEnum.FAIL.value());
        param.setStatus(WithdrawStatusEnum.FAIL.value());
        param.setTransferFailMessage(failMessage);
        this.withdrawMapper.updateSelective((Object)param);
        WithdrawProgress progress = new WithdrawProgress();
        BaseDomainUtil.initBaseDomain((BaseDomain)progress, (String)appId);
        progress.setOperator(operator);
        progress.setTitle("\u6253\u6b3e\u5931\u8d25");
        progress.setContent("\u5931\u8d25\u539f\u56e0\uff1a" + failMessage);
        progress.setRemark("\u8d44\u91d1\u5c06\u539f\u8def\u9000\u56de\u63d0\u73b0\u8d26\u6237");
        progress.setStatus(WithdrawProgressStatusEnum.TRANSFER_FAIL.value());
        progress.setWithdrawId(id);
        this.mapper.insert((Object)progress);
        String businessId = id;
        String businessType = WalletBusinessEnum.WITHDRAW.value();
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("businessId", (Object)businessId);
        criteria.eq("businessType", (Object)businessType);
        WalletFlow walletFlow = (WalletFlow)this.walletFlowMapper.select(criteria);
        if (walletFlow != null) {
            String walletFlowId = walletFlow.getId();
            int refundAmount = Math.abs(walletFlow.getAmount());
            this.walletFlowService.refund(walletFlowId, refundAmount);
        }
        return progress;
    }

    public CrudMapper<WithdrawProgress> getMapper() {
        return this.mapper;
    }
}

