/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.service.impl;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.distribute.domain.DistributerCommissionConfig;
import com.wego168.distribute.domain.Withdraw;
import com.wego168.distribute.enums.TransferTypeEnum;
import com.wego168.distribute.enums.TransferWayEnum;
import com.wego168.distribute.enums.WithdrawAccountTypeEnum;
import com.wego168.distribute.enums.WithdrawAuditStatusEnum;
import com.wego168.distribute.enums.WithdrawStatusEnum;
import com.wego168.distribute.enums.WithdrawTransferStatusEnum;
import com.wego168.distribute.enums.WithdrawWayEnum;
import com.wego168.distribute.persistence.WithdrawMapper;
import com.wego168.distribute.service.impl.DistributerCommissionConfigService;
import com.wego168.distribute.service.impl.WithdrawProgressService;
import com.wego168.domain.BaseDomain;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.CrudService;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import com.wego168.wx.enums.ServiceTypeEnum;
import com.wego168.wxpay.domain.WxpayConfig;
import com.wego168.wxpay.impl.JoinTransferHelper;
import com.wego168.wxpay.model.response.JoinTransferResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WithdrawService
extends CrudService<Withdraw> {
    @Autowired
    private WithdrawMapper mapper;
    @Autowired
    private WithdrawProgressService withdrawProgressService;
    @Autowired
    private DistributerCommissionConfigService distributerCommissionConfigService;
    @Autowired
    private JoinTransferHelper joinTransferHelper;

    @Transactional
    public Withdraw apply(int amount, int poundage, String account, String accountType, String name, String mobile, String memberId, boolean needAudit, String transferMerchantId, String appId) {
        Withdraw withdraw = new Withdraw();
        BaseDomainUtil.initBaseDomain((BaseDomain)withdraw, (String)appId);
        withdraw.setAccount(account);
        withdraw.setAccountId(memberId);
        withdraw.setAccountType(accountType);
        withdraw.setAmount(amount);
        withdraw.setAuditedFailMessage(null);
        if (needAudit) {
            withdraw.setAuditStatus(WithdrawAuditStatusEnum.NEW.value());
            withdraw.setAuditTime(null);
        } else {
            withdraw.setAuditStatus(WithdrawAuditStatusEnum.AUDITED.value());
            withdraw.setAuditTime(new Date());
        }
        withdraw.setMobile(mobile);
        withdraw.setName(name);
        withdraw.setNumber(String.valueOf(new SimpleDateFormat("yyyyMMdd").format(new Date())) + SequenceUtil.createRandomNumberSequence((int)16));
        withdraw.setOperator(appId);
        withdraw.setPoundage(poundage);
        withdraw.setRealAmount(amount - poundage);
        withdraw.setReceiveTime(null);
        withdraw.setStatus(WithdrawStatusEnum.ONGOING.value());
        withdraw.setTransactionNumber(null);
        withdraw.setTransferFailMessage(null);
        withdraw.setTransferTime(null);
        withdraw.setTransferStatus(WithdrawTransferStatusEnum.WAITING.value());
        withdraw.setTransferMerchantId(transferMerchantId);
        withdraw.setTransferMerchantType(ServiceTypeEnum.PROGRAM.id());
        withdraw.setWay(WithdrawWayEnum.MANUAL.value());
        DistributerCommissionConfig config = this.distributerCommissionConfigService.select(appId);
        String transferWay = config.getTransferWay();
        withdraw.setTransferWay(transferWay);
        if (StringUtil.equals((String)transferWay, (String)TransferWayEnum.AUTO.value())) {
            withdraw.setTransferType(TransferTypeEnum.JOIN.value());
        } else {
            withdraw.setTransferType(TransferTypeEnum.MANUAL.value());
        }
        this.mapper.insert((Object)withdraw);
        this.withdrawProgressService.apply(withdraw, needAudit);
        return withdraw;
    }

    @Transactional
    public JoinTransferResponse joinTransfer(WxpayConfig payConfig, Withdraw withdraw) {
        String transferNotifyUrl = "";
        String merchantId = payConfig.getMchId();
        String merchantKey = payConfig.getMchKey();
        String bankNumber = withdraw.getAccount();
        String name = withdraw.getName();
        String bankChannelNumber = "";
        int amount = withdraw.getRealAmount();
        String id = withdraw.getId();
        String appId = withdraw.getAppId();
        String description = "\u94b1\u5305\u63d0\u73b0";
        String accountType = withdraw.getAccountType();
        accountType = StringUtil.equals((String)accountType, (String)WithdrawAccountTypeEnum.PRIVATE_BANK.value()) ? "203" : "204";
        JoinTransferResponse transferResponse = this.joinTransferHelper.singleTransfer(merchantId, merchantKey, bankNumber, name, accountType, bankChannelNumber, amount, description, transferNotifyUrl);
        if (transferResponse.isSuccess()) {
            String transactionNumber = transferResponse.getMerchantOrderNo();
            this.withdrawProgressService.tranfering(id, appId, transactionNumber, appId);
        } else {
            String failMessage = transferResponse.getErrorDesc();
            this.withdrawProgressService.tranferFail(id, appId, failMessage, appId);
        }
        return transferResponse;
    }

    public void manualTransfer(String id, String appId, String transactionNumber, String transferTicket) {
        this.withdrawProgressService.tranferSuccess(id, appId, transactionNumber, transferTicket, appId);
    }

    public int sumWithdrawAmount(String memberId) {
        JpaCriteria criteria = JpaCriteria.builder();
        criteria.eq("accountId", (Object)memberId);
        criteria.in("status", (Object[])new String[]{WithdrawStatusEnum.FINISH.value(), WithdrawStatusEnum.ONGOING.value()});
        criteria.select("SUM(amount)");
        Integer sum = (Integer)this.select(criteria, Integer.class);
        return sum == null ? 0 : sum;
    }

    public List<Withdraw> selectPageForMember(String memberId, Page page) {
        page.eq("accountId", (Object)memberId);
        page.orderBy("createTime DESC");
        return this.mapper.selectPage(page);
    }

    public CrudMapper<Withdraw> getMapper() {
        return this.mapper;
    }
}

