/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.task;

import com.wego168.distribute.domain.DistributeChain;
import com.wego168.distribute.domain.DistributeLink;
import com.wego168.distribute.domain.Distributer;
import com.wego168.distribute.service.impl.DistributeChainService;
import com.wego168.distribute.service.impl.DistributeLinkService;
import com.wego168.distribute.service.impl.DistributerService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class DistributeTask {
    private static Logger logger = LoggerFactory.getLogger(DistributeTask.class);
    @Autowired
    private DistributeChainService distributeChainService;
    @Autowired
    private DistributeLinkService distributeLinkService;
    @Autowired
    private DistributerService distributerService;
    private List<DistributeChain> chainList;
    private DistributeLink link;

    @Async
    public void createDistributeRelationship(String upperDistributerId, String distributerId) {
        logger.error("distributer filter asycn start:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        this.resetChainListAndLink();
        this.createDistributeChain(upperDistributerId, distributerId);
        this.createDistributeLink(upperDistributerId, distributerId);
        this.distributeChainService.join(this.chainList, this.link);
        logger.error("distributer filter asycn end:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
    }

    private void createDistributeChain(String upperDistributerId, String distributerId) {
        boolean upperDistributerIsDistributer;
        boolean distributerHasUpperDistributer;
        boolean bl = distributerHasUpperDistributer = this.distributeChainService.getNearestChainIncludeSystemVirtualChain(distributerId) != null;
        if (distributerHasUpperDistributer) {
            logger.error("{} already has upper chain,no new chain created", (Object)distributerId);
            return;
        }
        String realUpperDistributerId = upperDistributerId;
        boolean bl2 = upperDistributerIsDistributer = this.distributerService.selectAuditedById(upperDistributerId) != null;
        if (!upperDistributerIsDistributer) {
            DistributeChain finalChain = this.distributeChainService.getNearestChainExcludeSystemVirtualChain(upperDistributerId);
            if (finalChain == null) {
                logger.error("{} has no upper chain either, no new chain created", (Object)upperDistributerId);
                return;
            }
            if (this.distributerService.selectAuditedById(finalChain.getUpperDistributerId()) == null) {
                logger.error("{}'s upper chain distributer is not audited, no new chain created", (Object)upperDistributerId);
                return;
            }
            realUpperDistributerId = finalChain.getUpperDistributerId();
        }
        ArrayList<DistributeChain> newChainList = new ArrayList<DistributeChain>();
        List<DistributeChain> chainList = this.distributeChainService.listUpperChainsExcludeSystemVirtualChain(realUpperDistributerId);
        if (chainList != null && chainList.size() > 0) {
            DistributeChain level1Chain = this.distributeChainService.create(distributerId, realUpperDistributerId, 1, false);
            int maxLevel = this.distributeChainService.maxLevel;
            newChainList.add(level1Chain);
            int size = chainList.size();
            int realSize = size > maxLevel - 1 ? maxLevel - 1 : size;
            boolean theFarestDistributerIsRoot = size <= maxLevel;
            int i = 1;
            while (i <= realSize) {
                boolean isRoot = false;
                if (i == realSize && theFarestDistributerIsRoot) {
                    isRoot = true;
                }
                DistributeChain chain = chainList.get(i - 1);
                DistributeChain newChain = this.distributeChainService.create(distributerId, chain.getUpperDistributerId(), i + 1, isRoot);
                newChainList.add(newChain);
                ++i;
            }
            this.setChainList(newChainList);
        } else {
            DistributeChain level1Chain = this.distributeChainService.create(distributerId, realUpperDistributerId, 1, true);
            newChainList.add(level1Chain);
            this.setChainList(newChainList);
        }
    }

    private void createDistributeLink(String upperDistributerId, String distributerId) {
        Distributer upperDistributer = this.distributerService.selectAuditedById(upperDistributerId);
        if (upperDistributer == null) {
            logger.error("\u8f6c\u53d1\u8005\u4e0d\u662f\u5206\u9500\u8005\uff0c\u65e0\u6cd5\u8bb0\u5f55link");
            return;
        }
        DistributeLink distributerLink = this.distributeLinkService.select(distributerId, upperDistributerId);
        if (distributerLink != null) {
            logger.error(String.valueOf(distributerId) + "\u5df2\u6709\u4e0a\u7ea7link,\u6ca1\u6709\u65b0\u7684link\u751f\u6210");
            return;
        }
        distributerLink = this.distributeLinkService.create(distributerId, upperDistributerId);
        this.setLink(distributerLink);
    }

    private void setChainList(List<DistributeChain> chainList) {
        this.chainList = chainList;
    }

    private void setLink(DistributeLink link) {
        this.link = link;
    }

    private void resetChainListAndLink() {
        this.chainList = null;
        this.link = null;
    }
}

