/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.distribute.task;

import com.wego168.distribute.domain.Withdraw;
import com.wego168.distribute.service.impl.WithdrawProgressService;
import com.wego168.util.IntegerUtil;
import com.wego168.wxpay.domain.WxpayConfig;
import com.wego168.wxpay.impl.JoinTransferHelper;
import com.wego168.wxpay.model.response.JoinTransferResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class WithdrawTask {
    @Autowired
    private JoinTransferHelper joinTransferHelper;
    @Autowired
    private WithdrawProgressService withdrawProgressService;
    private Logger logger = LoggerFactory.getLogger(WithdrawTask.class);

    @Async
    public JoinTransferResponse queryAndUpdateStatus(WxpayConfig payConfig, Withdraw withdrawDb) {
        String mchId = payConfig.getMchId();
        String mchKey = payConfig.getMchKey();
        String transactionNo = withdrawDb.getTransactionNumber();
        JoinTransferResponse transferResponse = this.joinTransferHelper.querySinglePay(mchId, mchKey, transactionNo);
        String id = withdrawDb.getId();
        String appId = withdrawDb.getAppId();
        if (IntegerUtil.equals((Integer)transferResponse.getStatus(), (Integer)205)) {
            this.withdrawProgressService.tranferSuccess(id, appId, transactionNo, null, appId);
            this.logger.error("transfer success,id:{}", (Object)withdrawDb.getId());
        } else if (IntegerUtil.equals((Integer)transferResponse.getStatus(), (Integer)204)) {
            String failMessage = transferResponse.getErrorDesc();
            this.withdrawProgressService.tranferFail(id, appId, failMessage, appId);
            this.logger.error("transfer fail,id:{},message:{}", (Object)withdrawDb.getId(), (Object)failMessage);
        }
        return transferResponse;
    }
}

