/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.component;

import com.wego168.share.domain.BonusWithdraw;
import com.wego168.share.enums.BonusWithdrawStatus;
import com.wego168.share.service.BonusWithdrawService;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wxpay.domain.WxpayConfig;
import com.wego168.wxpay.impl.JoinTransferHelper;
import com.wego168.wxpay.model.response.JoinTransferResponse;
import com.wego168.wxpay.service.WxpayConfigService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BonusWithdrawComponent {
    @Autowired
    private BonusWithdrawService bonusWithdrawService;
    @Autowired
    private WxpayConfigService wxpayConfigService;
    @Autowired
    private JoinTransferHelper joinTransferHelper;

    public int joinTransfer(BonusWithdraw bonusWithdraw) {
        WxpayConfig wxpayConfig = this.wxpayConfigService.selectMostSuitableOne(bonusWithdraw.getAppId(), WxAppServiceTypeEnum.SERVICE.value());
        int transferAmount = bonusWithdraw.getAmount();
        JoinTransferResponse joinTransferResponse = this.joinTransferHelper.singleTransfer(wxpayConfig.getMchId(), wxpayConfig.getMchKey(), bonusWithdraw.getPayeeAccount(), bonusWithdraw.getPayeeRealName(), "203", null, transferAmount, "\u6536\u76ca\u63d0\u73b0", null);
        if (joinTransferResponse.isSuccess()) {
            bonusWithdraw.setStatus(BonusWithdrawStatus.PAYING.id);
            bonusWithdraw.setTradeId(joinTransferResponse.getMerchantOrderNo());
        } else {
            bonusWithdraw.setStatus(BonusWithdrawStatus.FAIL.id);
            String errorDesc = "[" + joinTransferResponse.getErrorCode() + "]" + joinTransferResponse.getErrorDesc();
            errorDesc = errorDesc.length() > 256 ? errorDesc.substring(0, 256) : errorDesc;
            bonusWithdraw.setTransferErrorDesc(errorDesc);
        }
        bonusWithdraw.setTransferMchId(wxpayConfig.getMchId());
        bonusWithdraw.setMchId(wxpayConfig.getMchId());
        bonusWithdraw.setMchType(wxpayConfig.getMchType());
        bonusWithdraw.setUpdateTime(new Date());
        int row = this.bonusWithdrawService.doAfterTransfer(bonusWithdraw);
        return row;
    }
}

