/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.component;

import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.share.domain.BonusFlow;
import com.wego168.share.domain.BonusWithdraw;
import com.wego168.share.domain.ShareChain;
import com.wego168.share.service.DistributeConfigService;
import com.wego168.util.SimpleJackson;
import com.wego168.wx.component.WxMsgTemplateSender;
import com.wego168.wx.enums.WxMsgTemplateTypeEnum;
import com.wego168.wx.model.WxMsgTemplateParamter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class DistributeWxMsgTemplateTask {
    private static final Logger logger = LoggerFactory.getLogger(DistributeWxMsgTemplateTask.class);
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private WxMsgTemplateSender wxMsgTemplateSender;
    @Autowired
    private DistributeConfigService distributeConfigService;
    @Autowired
    private MemberService memberService;
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String H5_MINE_URL = "DOMAIN/CONTEXT/mobile/POUND/pages/mine/index?wo=1&wot=2&woacm=1&mpl=1";
    private static final String MINI_MINE_URL = "pages/mine/index";

    private String getOpenId(String memberId, int serviceType) {
        MemberAccount memberAccount = null;
        memberAccount = serviceType == 3 ? this.memberAccountService.selectProgramAccount(memberId) : this.memberAccountService.selectWechatAccount(memberId);
        if (memberAccount != null && StringUtils.isNotBlank((CharSequence)memberAccount.getUsername())) {
            return memberAccount.getUsername();
        }
        return "";
    }

    @Async
    public void sendBonusWithdrawMsg(BonusWithdraw bonusWithdraw) {
        String templateType = WxMsgTemplateTypeEnum.DISTRIBUTE_BONUS_WITHFRAW.name();
        if (bonusWithdraw != null) {
            String openId;
            int serviceType = bonusWithdraw.getSourceType() == null ? 3 : bonusWithdraw.getSourceType();
            String skipUrl = H5_MINE_URL;
            if (serviceType == 3) {
                skipUrl = MINI_MINE_URL;
            }
            if (StringUtils.isNotBlank((CharSequence)(openId = this.getOpenId(bonusWithdraw.getMemberId(), serviceType)))) {
                String status = bonusWithdraw.getStatusName();
                String withdrawTime = "";
                String applyTime = TIME_FORMAT.format(new Date());
                if (bonusWithdraw.getWithdrawTime() != null) {
                    withdrawTime = TIME_FORMAT.format(bonusWithdraw.getWithdrawTime());
                }
                Integer amount = bonusWithdraw.getAmount() == null ? 0 : bonusWithdraw.getAmount();
                Integer feeAmount = bonusWithdraw.getFeeAmount() == null ? 0 : bonusWithdraw.getFeeAmount();
                WxMsgTemplateParamter paramter = WxMsgTemplateParamter.builder((String)bonusWithdraw.getAppId(), (String)templateType, Arrays.asList(openId), (String)skipUrl);
                paramter.setServiceType(Integer.valueOf(serviceType));
                paramter.set("orderNo", (Object)bonusWithdraw.getOrderNo()).set("status", (Object)status).set("payeeAccount", (Object)bonusWithdraw.getPayeeAccount()).set("withdrawTime", (Object)withdrawTime).set("applyTime", (Object)applyTime).set("amount", (Object)((double)amount.intValue() / 100.0)).set("feeAmount", (Object)((double)feeAmount.intValue() / 100.0));
                logger.error(" sendBonusWithdrawMsg -> paramter", (Object)SimpleJackson.toJson((Object)paramter));
                this.wxMsgTemplateSender.sendTemplate(paramter);
            }
        }
    }

    @Async
    public void sendShareChainMsg(List<ShareChain> chainList, Member member, Member parentMember) {
        if (chainList != null && chainList.size() > 0) {
            int serviceType = 3;
            String templateType = WxMsgTemplateTypeEnum.DISTRIBUTE_SHARE_CHAIN.name();
            int index = 0;
            while (index < chainList.size()) {
                String openId;
                int levelCount;
                ShareChain chain = chainList.get(index);
                int level = chain.getLevel();
                if (level <= (levelCount = this.distributeConfigService.getConfig(chain.getAppId()).getShareLevelCount().intValue()) && StringUtils.isNotBlank((CharSequence)(openId = this.getOpenId(chain.getParentId(), serviceType)))) {
                    WxMsgTemplateParamter paramter = WxMsgTemplateParamter.builder((String)chain.getAppId(), (String)templateType, Arrays.asList(openId), null);
                    paramter.set("level", (Object)chain.getLevel()).set("referee", (Object)parentMember.getAppellation()).set("user", (Object)member.getAppellation()).set("refereeTime", (Object)TIME_FORMAT.format(chain.getCreateTime()));
                    logger.error("\u63a8\u8350\u4e0b\u7ebf\u7684\u53d1\u9001\u6a21\u677f\u6d88\u606f\u5185\u5bb9\uff0c{}", (Object)SimpleJackson.toJson((Object)paramter));
                    this.wxMsgTemplateSender.sendTemplate(paramter);
                }
                ++index;
            }
        }
    }

    @Async
    public void sendFinishBonusMsg(List<BonusFlow> bonusFlowList) {
        String templateType = "DISTRIBUTE_BONUS_FINISH";
        if (bonusFlowList != null) {
            for (BonusFlow flow : bonusFlowList) {
                int serviceType = flow.getSourceType() == null ? 3 : flow.getSourceType();
                String openId = this.getOpenId(flow.getMemberId(), serviceType);
                String skipUrl = H5_MINE_URL;
                if (serviceType == 3) {
                    skipUrl = MINI_MINE_URL;
                }
                String awardTime = "";
                if (flow.getAwardTime() != null) {
                    awardTime = TIME_FORMAT.format(flow.getAwardTime());
                }
                String orderMemberId = flow.getOrderMemberId();
                Member member = this.memberService.selectById(orderMemberId);
                String appellation = "";
                if (member != null && StringUtils.isNotBlank((CharSequence)member.getAppellation())) {
                    appellation = member.getAppellation();
                }
                WxMsgTemplateParamter paramter = WxMsgTemplateParamter.builder((String)flow.getAppId(), (String)templateType, Arrays.asList(openId), (String)skipUrl);
                paramter.setServiceType(Integer.valueOf(serviceType));
                paramter.set("user", (Object)appellation).set("amount", (Object)("\uffe5" + (double)flow.getAmount().intValue() / 100.0)).set("awardTime", (Object)awardTime);
                logger.error(" sendFinishBonusMsg -> paramter", (Object)SimpleJackson.toJson((Object)paramter));
                this.wxMsgTemplateSender.sendTemplate(paramter);
            }
        }
    }
}

