/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.component;

import com.wego168.member.domain.MemberAccount;
import com.wego168.member.handler.MemberBindHandler;
import com.wego168.share.domain.ShareLink;
import com.wego168.share.filter.ShareFilter;
import com.wego168.share.model.ShareParam;
import com.wego168.share.scheduler.ShareScheduler;
import com.wego168.share.service.ShareChainService;
import com.wego168.share.service.ShareLinkService;
import com.wego168.util.RequestUtil;
import com.wego168.util.StringUtil;
import com.wego168.web.util.ServletContextHolder;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShareChainComponent
implements MemberBindHandler {
    private static Logger logger = LoggerFactory.getLogger(ShareFilter.class);
    @Autowired
    private ShareLinkService shareLinkService;
    @Autowired
    private ShareChainService shareChainService;
    @Autowired
    private ShareScheduler shareScheduler;

    public void joinShare(ShareParam shareParam, HttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String key = (String)paramNames.nextElement();
            String value = request.getParameter(key);
            shareParam.put(key, value);
        }
        shareParam.setAppId(ServletContextHolder.getAppId());
        String share = request.getParameter("shp");
        if (StringUtil.equals((String)share, (String)"1")) {
            String parentId = shareParam.getParentId();
            String openId = shareParam.getOpenId();
            logger.info("===>>> \u8fdb\u5165\u5206\u4eab\u7684\u94fe\u63a5\uff0c\u5206\u4eab\u4eba[openId]\uff1a{}\uff0c\u5206\u4eab\u4eba\u4e0a\u7ebf[parentId]\uff1a{}\uff0c\u5206\u4eab\u94fe\u63a5[url]\uff1a{} ", new Object[]{openId, parentId, RequestUtil.getCurrentUrl((HttpServletRequest)request)});
            if (StringUtil.isNotBlank((String)openId) && StringUtil.isNotBlank((String)parentId) && !openId.equals(parentId)) {
                this.shareScheduler.saveShareChain(shareParam);
            }
        }
    }

    public void doAfterMemberBind(MemberAccount memberAccount) {
        ShareLink shareLink = this.shareLinkService.selectByMemberId(memberAccount.getUsername(), memberAccount.getAppId());
        if (shareLink != null) {
            this.shareChainService.saveShareChain(shareLink);
        }
    }
}

