/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.component;

import com.wego168.distribute.enums.SharerAuditStatusEnum;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.util.SessionUtil;
import com.wego168.share.domain.Sharer;
import com.wego168.share.domain.SharerBecomeCondition;
import com.wego168.share.enums.SharerBecomeConditionEnum;
import com.wego168.share.service.SharerRegistFieldService;
import com.wego168.share.service.SharerService;
import com.wego168.util.StringUtil;
import com.wego168.web.response.RestResponse;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SharerRegistComponent {
    @Autowired
    private SharerService sharerService;
    @Autowired
    private SharerRegistFieldService sharerRegistFieldService;
    @Autowired
    private MemberAccountService memberAccountService;

    public String ensureOpenId(HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        String openId = SessionUtil.getOpenId((HttpServletRequest)request);
        if (StringUtil.isBlank((String)openId)) {
            return this.ensureOpenId(memberId);
        }
        return openId;
    }

    public String ensureOpenId(String memberId) {
        MemberAccount miniProgramAccount;
        String openId = null;
        if (StringUtil.isBlank(openId) && (miniProgramAccount = this.memberAccountService.selectWechatAccount(memberId)) != null) {
            openId = miniProgramAccount.getUsername();
        }
        return openId;
    }

    public RestResponse registByCondition(Map<String, String> registrationData, Member member, String openId, SharerBecomeCondition condition) {
        String conditionCode = condition.getCondition();
        if (StringUtil.equals((String)conditionCode, (String)SharerBecomeConditionEnum.NO_CONDITION.value())) {
            return this.becomeByMember(member, openId);
        }
        if (StringUtil.equals((String)conditionCode, (String)SharerBecomeConditionEnum.REGIST_AND_AUDIT.value())) {
            this.sharerRegistFieldService.checkRegistrationData(registrationData, condition.getAppId());
            String auditStatus = SharerAuditStatusEnum.WAITING.value();
            return this.regist(registrationData, member, openId, auditStatus);
        }
        if (StringUtil.equals((String)conditionCode, (String)SharerBecomeConditionEnum.REGIST.value())) {
            String auditStatus = SharerAuditStatusEnum.AUDITED.value();
            this.sharerRegistFieldService.checkRegistrationData(registrationData, condition.getAppId());
            return this.regist(registrationData, member, openId, auditStatus);
        }
        return this.registByExternalCondition(registrationData, member, condition);
    }

    public void updateRegistrationData(Map<String, String> registrationData, String id, String appId) {
        this.sharerRegistFieldService.checkRegistrationData(registrationData, appId);
        StringBuffer registrationDataBuffer = new StringBuffer("{");
        Sharer param = new Sharer();
        for (Map.Entry<String, String> entry : registrationData.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            registrationDataBuffer.append("\"" + key + "\": ").append("\"" + value + "\",");
            if (StringUtil.equals((String)key, (String)"name")) {
                param.setName(value);
                continue;
            }
            if (!StringUtil.equals((String)key, (String)"phone")) continue;
            param.setMobile(value);
        }
        registrationDataBuffer.deleteCharAt(registrationDataBuffer.length() - 1);
        registrationDataBuffer.append("}");
        param.setId(id);
        param.setAuditStatus(SharerAuditStatusEnum.WAITING.value());
        param.setStatus(SharerAuditStatusEnum.WAITING.value());
        param.setRegistrationData(registrationDataBuffer.toString());
        this.sharerService.updateSelective((Object)param);
    }

    protected RestResponse becomeByMember(Member member, String openId) {
        this.sharerService.transferMemberWithoutAccount(member, openId);
        return RestResponse.success((String)"\u6ce8\u518c\u6210\u529f");
    }

    protected RestResponse regist(Map<String, String> registrationData, Member member, String openId, String auditStatus) {
        if (registrationData == null || registrationData.size() == 0) {
            return RestResponse.error((String)"\u8bf7\u5148\u6ce8\u518c");
        }
        String storeId = registrationData.get("storeId");
        this.sharerService.transferMemberWithoutAccount(registrationData, member, openId, storeId, auditStatus);
        return RestResponse.success((String)"\u6ce8\u518c\u6210\u529f");
    }

    protected RestResponse registByExternalCondition(Map<String, String> registrationData, Member member, SharerBecomeCondition condition) {
        return RestResponse.error(null, (String)"\u6ce8\u518c\u5931\u8d25\uff1a\u672a\u914d\u7f6e\u6ce8\u518c\u6761\u4ef6");
    }
}

