/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.admin;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.service.CrudService;
import com.wego168.share.domain.Bonus;
import com.wego168.share.domain.BonusFlow;
import com.wego168.share.enums.BonusFlowStatusEnum;
import com.wego168.share.response.BonusFlowResponse;
import com.wego168.share.service.BonusFlowService;
import com.wego168.share.service.BonusService;
import com.wego168.share.service.DistributeConfigService;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.GuidGenerator;
import com.wego168.web.util.ParamUtils;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminBonusFlowController")
@RequestMapping(value={"/api/admin/v1/bonusFlow"})
public class BonusFlowController
extends CrudController<BonusFlow> {
    @Autowired
    private BonusFlowService service;
    @Autowired
    private BonusService bonusService;
    @Autowired
    private DistributeConfigService distributeConfigService;

    public CrudService<BonusFlow> getService() {
        return this.service;
    }

    @GetMapping(value={"/pageFlows"})
    public RestResponse pageFlows(HttpServletRequest request) {
        Page page = this.buildPage(request);
        List<BonusFlowResponse> lists = this.service.pageFlows(page);
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request) {
        String memberId = ParamUtils.getString((ServletRequest)request, (String)"memberId");
        Page page = this.buildPage(request);
        if (StringUtils.isNotBlank((CharSequence)memberId)) {
            page.put((Object)"memberId", (Object)memberId);
            List<Bootmap> lists = this.service.pageForAdmin(page);
            page.setList(lists);
        }
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/testCharges"})
    public void testCharges(BonusFlow flow, HttpServletRequest request) {
        flow.setId(GuidGenerator.generate());
        flow.setCreateTime(new Date());
        flow.setAppId(this.getAppId());
        flow.setIsDeleted(false);
        flow.setOrderAmount(0);
        flow.setOrderId("0");
        flow.setType(4);
        flow.setLevel(0);
        flow.setOrderMemberId(null);
        flow.setStatus(BonusFlowStatusEnum.SUCCESS.id());
        flow.setDetail("\u4f1a\u5458\u5145\u503c");
        this.service.insert((Object)flow);
        this.handleBonus(flow);
        flow.setStoreId("0");
        this.handleBonus(flow);
    }

    private void handleBonus(BonusFlow flow) {
        Bonus bonus = this.bonusService.selectByStoreMember(flow.getStoreId(), flow.getMemberId());
        if (bonus != null) {
            bonus.setAmount(bonus.getAmount() + flow.getAmount());
            bonus.setTotalAmount(bonus.getTotalAmount() + flow.getAmount());
            this.bonusService.update((Object)bonus);
        } else {
            bonus = this.bonusService.buildBonus(flow);
            this.bonusService.insert((Object)bonus);
        }
    }
}

