/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.admin;

import com.simple.mybatis.Page;
import com.wego168.alipay.domain.AlipayConfig;
import com.wego168.alipay.domain.AlipayTransferRequest;
import com.wego168.alipay.model.TransferRequestStatus;
import com.wego168.alipay.model.request.AlipayTransferRequestParameter;
import com.wego168.alipay.service.AlipayConfigService;
import com.wego168.alipay.service.AlipayTransferRequestService;
import com.wego168.alipay.service.SimpleAlipayTransferService;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.service.CrudService;
import com.wego168.share.component.BonusWithdrawComponent;
import com.wego168.share.domain.Bonus;
import com.wego168.share.domain.BonusWithdraw;
import com.wego168.share.domain.BonusWithdrawProgress;
import com.wego168.share.enums.BonusWithdrawAccountType;
import com.wego168.share.enums.BonusWithdrawStatus;
import com.wego168.share.scheduler.BonusWithdrawScheduler;
import com.wego168.share.service.BonusService;
import com.wego168.share.service.BonusWithdrawAccountService;
import com.wego168.share.service.BonusWithdrawProgressService;
import com.wego168.share.service.BonusWithdrawService;
import com.wego168.share.service.ShareConfigService;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.ParamUtils;
import com.wego168.wxpay.domain.WxpayConfig;
import com.wego168.wxpay.domain.WxpayTransferRequest;
import com.wego168.wxpay.impl.JoinTransferHelper;
import com.wego168.wxpay.model.request.WxpayTransferRequestParameter;
import com.wego168.wxpay.service.SimpleWxpayTransferService;
import com.wego168.wxpay.service.WxpayConfigService;
import com.wego168.wxpay.service.WxpayTransferRequestService;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminBonusWithdrawController")
@RequestMapping(value={"/api/admin/v1/bonusWithdraw"})
public class BonusWithdrawController
extends CrudController<BonusWithdraw> {
    @Autowired
    private BonusWithdrawService service;
    @Autowired
    private BonusWithdrawAccountService bonusWithdrawAccountService;
    @Autowired
    private SimpleAlipayTransferService simpleAlipayTransferService;
    @Autowired
    private AlipayConfigService alipayConfigService;
    @Autowired
    private WxpayConfigService wxpayConfigService;
    @Autowired
    private SimpleWxpayTransferService simpleWxpayTransferService;
    @Autowired
    private BonusWithdrawProgressService bonusWithdrawProgressService;
    @Autowired
    private AlipayTransferRequestService alipayTransferRequestService;
    @Autowired
    private WxpayTransferRequestService wxpayTransferRequestService;
    @Autowired
    private JoinTransferHelper joinTransferHelper;
    @Autowired
    private BonusWithdrawComponent bonusWithdrawComponent;
    @Autowired
    private ShareConfigService shareConfigService;
    @Autowired
    private BonusService bonusService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private BonusWithdrawScheduler bonusWithdrawScheduler;

    public CrudService<BonusWithdraw> getService() {
        return this.service;
    }

    @PostMapping(value={"/audit"})
    public RestResponse audit(HttpServletRequest request) {
        int row;
        String id = ParamUtils.getString((ServletRequest)request, (String)"id");
        String remarks = ParamUtils.getString((ServletRequest)request, (String)"remarks");
        Integer status = ParamUtils.getInteger((ServletRequest)request, (String)"status");
        Shift.throwsIfNull((Object)id, (String)"\u63d0\u73b0\u5355\u636e\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        Shift.throwsIfNull((Object)status, (String)"\u63d0\u73b0\u5355\u636e\u7684\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        String operator = this.authenticationUser.getUserId();
        BonusWithdraw bonusWithdraw = (BonusWithdraw)((Object)this.service.selectById(id));
        bonusWithdraw.setOperator(operator);
        Shift.throwsIfInvalid((bonusWithdraw.getStatus() != BonusWithdrawStatus.APPLY.id ? 1 : 0) != 0, (String)"\u8be5\u63d0\u73b0\u5355\u636e\u5df2\u5904\u7406\uff0c\u8bf7\u52ff\u91cd\u590d\u5ba1\u6838");
        int result = 0;
        if (BonusWithdrawStatus.REJECT.id == status) {
            result = this.service.auditNotPass(id, operator, remarks);
        } else if (BonusWithdrawStatus.PAYING.id == status && (row = this.service.auditPass(id, operator, remarks)) == 1) {
            if (bonusWithdraw.getAccountType() == BonusWithdrawAccountType.ALIPAY.id) {
                result = this.alipayTransfer(bonusWithdraw);
            } else if (bonusWithdraw.getAccountType() == BonusWithdrawAccountType.JOIN.id) {
                result = this.bonusWithdrawComponent.joinTransfer(bonusWithdraw);
            } else if (bonusWithdraw.getAccountType() == BonusWithdrawAccountType.WXPAY.id) {
                result = this.wxpayTransfer(bonusWithdraw);
            }
        }
        return RestResponse.success((Object)result);
    }

    @PostMapping(value={"/cancel"})
    public RestResponse cancel(HttpServletRequest request) {
        String id = ParamUtils.getString((ServletRequest)request, (String)"id");
        String remarks = ParamUtils.getString((ServletRequest)request, (String)"remarks");
        Shift.throwsIfNull((Object)id, (String)"\u63d0\u73b0\u5355\u636e\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        BonusWithdraw bonusWithdraw = (BonusWithdraw)((Object)this.service.selectById(id));
        Shift.throwsIfInvalid((bonusWithdraw.getStatus() == BonusWithdrawStatus.SUCCESS.id ? 1 : 0) != 0, (String)"\u8be5\u63d0\u73b0\u5355\u636e\u5df2\u63d0\u73b0\u5230\u8d26\uff0c\u4e0d\u53ef\u4f5c\u5e9f");
        String operator = this.authenticationUser.getUserId();
        int row = this.service.cancel(id, operator, BonusWithdrawStatus.CANCEL.id, remarks);
        return RestResponse.success((Object)row);
    }

    @PostMapping(value={"/redoTransfer"})
    public RestResponse redoTransfer(HttpServletRequest request) {
        String id = ParamUtils.getString((ServletRequest)request, (String)"id");
        Shift.throwsIfNull((Object)id, (String)"\u63d0\u73b0\u5355\u636e\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        BonusWithdraw bonusWithdraw = (BonusWithdraw)((Object)this.service.selectById(id));
        int status = bonusWithdraw.getStatus();
        boolean flag = status == BonusWithdrawStatus.FAIL.id || status == BonusWithdrawStatus.PAYING.id;
        Shift.throwsIfInvalid((!flag ? 1 : 0) != 0, (String)"\u63d0\u73b0\u5931\u8d25\u6216\u63d0\u73b0\u5ba1\u6838\u901a\u8fc7\u7684\u624d\u53ef\u4ee5\u91cd\u8bd5\u8f6c\u8d26");
        String operator = this.authenticationUser.getUserId();
        bonusWithdraw.setOperator(operator);
        int result = 0;
        AlipayTransferRequest alipayTransferRequest = this.alipayTransferRequestService.selectTop1ByOutOrderId(bonusWithdraw.getId());
        int transferStatus = alipayTransferRequest.getStatus();
        Shift.throwsIfInvalid((TransferRequestStatus.NEW.id == transferStatus ? 1 : 0) != 0, (String)"\u8f6c\u8d26\u5904\u7406\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85...");
        if (TransferRequestStatus.SUCCESS.id == transferStatus) {
            if (bonusWithdraw.getStatus() == BonusWithdrawStatus.PAYING.id) {
                result = this.service.finishAfterTransfer(bonusWithdraw);
            } else {
                Shift.throwsIfInvalid((boolean)true, (String)"\u63d0\u73b0\u5df2\u5230\u8d26\uff0c\u8bf7\u52ff\u91cd\u8bd5");
            }
        } else if (bonusWithdraw.getAccountType() == BonusWithdrawAccountType.ALIPAY.id) {
            result = this.alipayTransfer(bonusWithdraw);
        } else if (bonusWithdraw.getAccountType() == BonusWithdrawAccountType.WXPAY.id) {
            result = this.wxpayTransfer(bonusWithdraw);
        } else if (bonusWithdraw.getAccountType() == BonusWithdrawAccountType.WXPAY.id) {
            result = this.bonusWithdrawComponent.joinTransfer(bonusWithdraw);
        }
        return RestResponse.success((Object)result);
    }

    private int alipayTransfer(BonusWithdraw bonusWithdraw) {
        AlipayConfig alipayConfig = this.alipayConfigService.selectByApplicationId(this.getAppId());
        String outBizNo = bonusWithdraw.getOrderNo();
        String payeeAccount = bonusWithdraw.getPayeeAccount();
        String payeeRealName = bonusWithdraw.getPayeeRealName();
        double amount = (double)(bonusWithdraw.getAmount() - bonusWithdraw.getFeeAmount()) / 100.0;
        AlipayTransferRequestParameter transferParameter = AlipayTransferRequestParameter.builder((AlipayConfig)alipayConfig);
        transferParameter.buildTransferRequestParameter(bonusWithdraw.getId(), outBizNo, payeeAccount, String.valueOf(amount), payeeRealName, "\u4f63\u91d1\u63d0\u73b0");
        AlipayTransferRequest alipayTransferRequest = this.simpleAlipayTransferService.transfer(transferParameter);
        Shift.throwsIfInvalid((boolean)StringUtils.isNotBlank((CharSequence)alipayTransferRequest.getSubMsg()), (String)alipayTransferRequest.getSubMsg());
        if (alipayTransferRequest.getStatus() == BonusWithdrawStatus.PAYING.id) {
            bonusWithdraw.setRemarks("\u5df2\u5230\u8d26");
            bonusWithdraw.setStatus(BonusWithdrawStatus.SUCCESS.id);
            bonusWithdraw.setTradeId(alipayTransferRequest.getOrderId());
        } else {
            bonusWithdraw.setStatus(BonusWithdrawStatus.FAIL.id);
            bonusWithdraw.setRemarks(alipayTransferRequest.getSubMsg());
        }
        int row = this.service.finishAfterTransfer(bonusWithdraw);
        return row;
    }

    private int wxpayTransfer(BonusWithdraw bonusWithdraw) {
        WxpayConfig wxpayConfig = (WxpayConfig)this.wxpayConfigService.selectById((Object)this.getAppId());
        String partnerTradeNo = bonusWithdraw.getOrderNo();
        String openId = bonusWithdraw.getPayeeAccount();
        String reUserName = bonusWithdraw.getPayeeRealName();
        int amount = bonusWithdraw.getAmount() - bonusWithdraw.getFeeAmount();
        WxpayTransferRequestParameter transferParameter = WxpayTransferRequestParameter.builder((WxpayConfig)wxpayConfig);
        transferParameter.buildTransferRequestParameter(partnerTradeNo, openId, reUserName, String.valueOf(amount), "\u6536\u76ca\u63d0\u73b0");
        WxpayTransferRequest wxpayTransferRequest = this.simpleWxpayTransferService.transfer(transferParameter);
        Shift.throwsIfInvalid((boolean)StringUtils.isNotBlank((CharSequence)wxpayTransferRequest.getErrCode()), (String)wxpayTransferRequest.getErrCodeDes());
        if (wxpayTransferRequest.getStatus() == BonusWithdrawStatus.PAYING.id) {
            bonusWithdraw.setRemarks(BonusWithdrawStatus.PAYING.desc);
            bonusWithdraw.setStatus(BonusWithdrawStatus.SUCCESS.id);
            bonusWithdraw.setTradeId(wxpayTransferRequest.getPartnerTradeNo());
        } else {
            bonusWithdraw.setStatus(BonusWithdrawStatus.FAIL.id);
            bonusWithdraw.setRemarks(wxpayTransferRequest.getErrCode());
        }
        int row = this.service.finishAfterTransfer(bonusWithdraw);
        return row;
    }

    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request) {
        String memberId = ParamUtils.getString((ServletRequest)request, (String)"memberId");
        Page page = this.buildPage(request);
        if (StringUtils.isNotBlank((CharSequence)memberId)) {
            page.put((Object)"appId", (Object)this.getAppId());
            page.put((Object)"memberId", (Object)memberId);
            List<BonusWithdraw> lists = this.service.page(page);
            page.setList(lists);
        }
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/get"})
    public RestResponse get(String id, HttpServletRequest request) {
        BonusWithdraw bonusWithdraw = (BonusWithdraw)((Object)this.service.selectById(id));
        if (bonusWithdraw != null) {
            List<BonusWithdrawProgress> progressList = this.bonusWithdrawProgressService.selectListByBonusWithdrawId(bonusWithdraw.getId());
            bonusWithdraw.setProgressList(progressList);
            Member member = this.memberService.selectById(bonusWithdraw.getMemberId());
            if (member != null) {
                bonusWithdraw.setMemberName(member.getAppellation());
            }
        }
        return RestResponse.success((Object)((Object)bonusWithdraw));
    }

    @PostMapping(value={"/applyByManual"})
    public RestResponse applyByManual(BonusWithdraw param, int accountType, HttpServletRequest request) {
        MemberAccount memberAccount;
        BonusWithdraw dbBonusWithdraw = null;
        if (StringUtils.isNotBlank((CharSequence)param.getWithdrawId()) && (dbBonusWithdraw = (BonusWithdraw)((Object)this.service.selectById(param.getWithdrawId()))) != null) {
            Shift.throwsIfInvalid((boolean)StringUtils.isNotBlank((CharSequence)dbBonusWithdraw.getWithdrawId()), (String)"\u8be5\u63d0\u73b0\u5355\u636e\u5df2\u5904\u7406");
            param.setSourceType(dbBonusWithdraw.getSourceType());
        }
        int sourceType = param.getSourceType() == null ? 3 : param.getSourceType();
        param.setSourceType(sourceType);
        int withdramServiceFee = this.shareConfigService.getWithdramServiceFee(this.getAppId());
        int withdramAmount = this.shareConfigService.getWithdramAmount(this.getAppId());
        Shift.throwsIfNull((Object)param.getAmount(), (String)"\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Shift.throwsIfInvalid((param.getAmount() < withdramAmount ? 1 : 0) != 0, (String)("\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e" + (double)withdramAmount / 100.0 + "\u5143"));
        String memberId = param.getMemberId();
        Shift.throwsIfNull((Object)memberId, (String)"\u4f1a\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        Bonus bonus = this.bonusService.selectByStoreMember("0", memberId);
        Shift.throwsIfNull((Object)((Object)bonus), (String)"\u6ca1\u6709\u53ef\u63d0\u73b0\u7684\u91d1\u989d");
        int balanceAmount = bonus.getAmount();
        int applyAmount = param.getAmount() + withdramServiceFee;
        Shift.throwsIfInvalid((balanceAmount < applyAmount ? 1 : 0) != 0, (String)("\u63d0\u73b0\u91d1\u989d\uff08\u5305\u542b\u624b\u7eed\u8d39\uff09\u4e0d\u80fd\u5927\u4e8e\u4f59\u989d\uff0c\u60a8\u5f53\u524d\u4f59\u989d\u4e3a" + (double)bonus.getAmount().intValue() / 100.0 + "\u5143"));
        if (BonusWithdrawAccountType.WXPAY.id == accountType && (memberAccount = this.memberAccountService.selectWechatAccount(memberId)) != null) {
            param.setPayeeAccount(memberAccount.getUsername());
            param.setPayeeRealName("");
        }
        Shift.throwsIfInvalid((boolean)StringUtils.isBlank((CharSequence)param.getPayeeAccount()), (String)"\u6536\u6b3e\u65b9\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        if (BonusWithdrawAccountType.WXPAY.id != accountType) {
            Shift.throwsIfInvalid((boolean)StringUtils.isBlank((CharSequence)param.getPayeeRealName()), (String)" \u6536\u6b3e\u65b9\u771f\u5b9e\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        param.setAccountType(accountType);
        param.setMemberId(memberId);
        param.setFeeAmount(withdramServiceFee);
        param.setStatus(BonusWithdrawStatus.SUCCESS.id);
        param.setIsManual(true);
        this.service.applyByManual(param, dbBonusWithdraw);
        return RestResponse.success((Object)((Object)param));
    }

    @GetMapping(value={"/testWithdraw"})
    public RestResponse testWithdraw(String id, HttpServletRequest request) {
        BonusWithdraw bonusWithdraw = (BonusWithdraw)((Object)this.service.selectById(id));
        return RestResponse.success((Object)((Object)bonusWithdraw));
    }
}

