/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.admin;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.base.util.FileUtil;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberLevel;
import com.wego168.member.domain.MemberLevelOrder;
import com.wego168.member.domain.MemberLogin;
import com.wego168.member.service.impl.MemberLevelOrderService;
import com.wego168.member.service.impl.MemberLevelService;
import com.wego168.member.service.impl.MemberLoginService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.service.CrudService;
import com.wego168.share.domain.Bonus;
import com.wego168.share.domain.ShareLink;
import com.wego168.share.enums.BonusFlowTypeEnum;
import com.wego168.share.model.ShareMember;
import com.wego168.share.service.BonusFlowService;
import com.wego168.share.service.BonusService;
import com.wego168.share.service.BonusWithdrawService;
import com.wego168.share.service.ShareChainService;
import com.wego168.share.service.ShareLinkService;
import com.wego168.share.service.ShareMemberService;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.ParamUtils;
import com.wego168.wx.domain.WxFans;
import com.wego168.wx.service.WxFansService;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminShareMemberController")
@RequestMapping(value={"/api/admin/v1/shareMember"})
public class MemberController
extends CrudController<ShareMember> {
    private static final Logger logger = LoggerFactory.getLogger(MemberController.class);
    @Autowired
    private MemberService memberService;
    @Autowired
    private ShareChainService shareChainService;
    @Autowired
    private ShareMemberService shareMemberService;
    @Autowired
    private MemberLevelService memberLevelService;
    @Autowired
    private BonusService bonusService;
    @Autowired
    private BonusFlowService bonusFlowService;
    @Autowired
    private BonusWithdrawService bonusWithdrawService;
    @Autowired
    private MemberLevelOrderService memberLevelOrderService;
    @Autowired
    private MemberLoginService memberLoginService;
    @Autowired
    private WxFansService wxFansService;
    @Autowired
    private ShareLinkService shareLinkService;

    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request, HttpServletResponse response) {
        Page page = this.buildPage(request);
        List<ShareMember> lists = this.shareMemberService.pageFans(page);
        if (lists != null && lists.size() > 0) {
            LinkedList<String> idList = new LinkedList<String>();
            for (ShareMember sm : lists) {
                if (!StringUtils.isNotBlank((CharSequence)sm.getId())) continue;
                idList.add(sm.getId());
            }
            if (idList.size() > 0) {
                List<ShareMember> memberList = this.shareChainService.selectParentList(idList);
                HashMap<String, String> memberMap = new HashMap<String, String>();
                if (memberList != null && memberList.size() > 0) {
                    for (ShareMember m : memberList) {
                        memberMap.putIfAbsent(m.getId(), m.getParentAppellation());
                    }
                }
                Bootmap amountBoot = new Bootmap();
                List<Bootmap> amountList = this.bonusFlowService.sumTotalBonusByTypeAndParentIdList(idList, BonusFlowTypeEnum.ORDER.id());
                if (amountList != null && amountList.size() > 0) {
                    for (Bootmap boot : amountList) {
                        amountBoot.put((Object)boot.getString("memberId"), (Object)boot.getInteger("amount"));
                    }
                }
                Bootmap memberAmountBoot = new Bootmap();
                List memberAmountList = this.memberLevelOrderService.selectMemberAmount(idList);
                if (memberAmountList != null && memberAmountList.size() > 0) {
                    for (MemberLevelOrder order : memberAmountList) {
                        memberAmountBoot.put((Object)order.getMemberId(), (Object)order.getPayAmount());
                    }
                }
                for (ShareMember sm : lists) {
                    sm.setParentAppellation((String)memberMap.get(sm.getId()));
                    sm.setAmount(amountBoot.getInteger(sm.getId(), Integer.valueOf(0)));
                    sm.setMemberAmount(memberAmountBoot.getInteger(sm.getId(), Integer.valueOf(0)));
                }
            }
        }
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/pageFans"})
    public RestResponse pageFans(HttpServletRequest request, HttpServletResponse response) {
        Page page = this.buildPage(request);
        List<ShareMember> lists = this.shareMemberService.pageFans(page);
        if (lists != null && lists.size() > 0) {
            LinkedList<String> idList = new LinkedList<String>();
            for (ShareMember sm : lists) {
                if (!StringUtils.isNotBlank((CharSequence)sm.getId())) continue;
                idList.add(sm.getId());
            }
            if (idList.size() > 0) {
                Bootmap amountBoot = new Bootmap();
                List<Bootmap> amountList = this.bonusFlowService.sumTotalBonusByTypeAndParentIdList(idList, BonusFlowTypeEnum.ORDER.id());
                if (amountList != null && amountList.size() > 0) {
                    for (Bootmap boot : amountList) {
                        amountBoot.put((Object)boot.getString("memberId"), (Object)boot.getInteger("amount"));
                    }
                }
                Bootmap memberAmountBoot = new Bootmap();
                List memberAmountList = this.memberLevelOrderService.selectMemberAmount(idList);
                if (memberAmountList != null && memberAmountList.size() > 0) {
                    for (MemberLevelOrder order : memberAmountList) {
                        memberAmountBoot.put((Object)order.getMemberId(), (Object)order.getPayAmount());
                    }
                }
                for (ShareMember sm : lists) {
                    sm.setAmount(amountBoot.getInteger(sm.getId(), Integer.valueOf(0)));
                    sm.setMemberAmount(memberAmountBoot.getInteger(sm.getId(), Integer.valueOf(0)));
                }
            }
        }
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        DecimalFormat moneyFormat = new DecimalFormat("0.##");
        ArrayList<ExcelExportEntity> entity = new ArrayList<ExcelExportEntity>();
        entity.add(new ExcelExportEntity("\u4f1a\u5458\u624b\u673a\u53f7", (Object)"mobile", 20));
        entity.add(new ExcelExportEntity("\u5fae\u4fe1\u6635\u79f0", (Object)"appellation", 20));
        entity.add(new ExcelExportEntity("\u7b49\u7ea7", (Object)"levelName", 20));
        entity.add(new ExcelExportEntity("\u4e0a\u7ea7", (Object)"parentAppellation", 20));
        entity.add(new ExcelExportEntity("\u6536\u76ca", (Object)"profit", 20));
        entity.add(new ExcelExportEntity("\u4e2a\u4eba\u6536\u76ca", (Object)"personProfit", 20));
        entity.add(new ExcelExportEntity("\u56e2\u961f\u6536\u76ca", (Object)"teamProfit", 20));
        entity.add(new ExcelExportEntity("\u4f59\u989d", (Object)"blanceAmount", 20));
        ArrayList dataList = new ArrayList();
        int pageNum = 1;
        Page page = this.buildPage(request);
        block0: while (true) {
            page.setPageSize(100);
            page.setPageNum(pageNum++);
            page.setCount(false);
            List<ShareMember> lists = this.shareMemberService.page(page);
            if (lists == null || lists.size() == 0) break;
            List<String> idList = lists.stream().map(ShareMember::getId).collect(Collectors.toList());
            List<ShareMember> memberList = this.shareChainService.selectParentList(idList);
            HashMap<String, String> memberMap = new HashMap<String, String>();
            if (memberList != null && memberList.size() > 0) {
                for (ShareMember m : memberList) {
                    memberMap.putIfAbsent(m.getId(), m.getParentAppellation());
                }
            }
            HashMap<String, Bootmap> profitMap = new HashMap<String, Bootmap>();
            List<Bootmap> profitFlowList = this.bonusFlowService.sumPersonAndTeamProfitByMemberIdList(idList);
            if (profitFlowList != null && profitFlowList.size() > 0) {
                for (Bootmap boot : profitFlowList) {
                    profitMap.put(boot.getString("memberId"), boot);
                }
            }
            Iterator<ShareMember> iterator = lists.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                ShareMember sm = iterator.next();
                String memberId = sm.getId();
                sm.setParentAppellation((String)memberMap.get(sm.getId()));
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("mobile", sm.getMobile());
                map.put("appellation", sm.getAppellation());
                map.put("levelName", sm.getLevelName());
                map.put("parentAppellation", sm.getParentAppellation());
                Bootmap profitBoot = (Bootmap)profitMap.get(memberId);
                if (profitBoot != null) {
                    int personProfit = profitBoot.getInteger("personProfit", Integer.valueOf(0));
                    int teamProfit = profitBoot.getInteger("teamProfit", Integer.valueOf(0));
                    int blanceAmount = profitBoot.getInteger("blanceAmount", Integer.valueOf(0));
                    int profit = personProfit + teamProfit;
                    map.put("profit", moneyFormat.format((float)profit / 100.0f));
                    map.put("personProfit", moneyFormat.format((float)personProfit / 100.0f));
                    map.put("teamProfit", moneyFormat.format((float)teamProfit / 100.0f));
                    map.put("blanceAmount", moneyFormat.format((float)blanceAmount / 100.0f));
                }
                dataList.add(map);
            }
            break;
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(null, "\u4f1a\u5458\u660e\u7ec6"), entity, dataList);
        FileUtil.downLoadExcel((String)"\u4f1a\u5458\u660e\u7ec6\u8868.xls", (HttpServletResponse)response, (Workbook)workbook);
    }

    @GetMapping(value={"/get"})
    public RestResponse get(String id, HttpServletRequest request, HttpServletResponse response) {
        String openId = ParamUtils.getString((ServletRequest)request, (String)"openId");
        if (StringUtils.isBlank((CharSequence)id)) {
            return this.getByFans(openId, request, response);
        }
        Member member = this.memberService.selectById(id);
        Shift.throwsIfNull((Object)member, (String)"\u4f1a\u5458\u4e0d\u5b58\u5728");
        Member parent = this.shareChainService.selectParent(id);
        Bonus bonus = this.bonusService.selectByMember(id);
        int bonusAmount = this.bonusFlowService.sumTotalBonusByType(id, BonusFlowTypeEnum.ORDER.id());
        int withdrawAmount = this.bonusWithdrawService.sumTotalWithdrawAmount(id);
        MemberLogin login = this.memberLoginService.selectByMember(member.getId());
        Optional<Bonus> bonusOps = Optional.ofNullable(bonus);
        int balanceAmount = bonusOps.map(Bonus::getAmount).orElse(0);
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        res.put("id", member.getId());
        res.put("name", member.getName());
        res.put("headImage", member.getHeadImage());
        res.put("number", member.getNumber());
        res.put("mobile", member.getMobilePhoneNumber());
        res.put("appellation", member.getAppellation());
        res.put("isFrozen", member.getIsFrozen());
        res.put("parentAppellation", parent != null ? parent.getAppellation() : "");
        res.put("bonusAmount", bonusAmount);
        res.put("balanceAmount", balanceAmount);
        res.put("withdrawAmount", withdrawAmount);
        res.put("createTime", member.getCreateTime());
        res.put("lastLoginTime", login != null ? login.getCreateTime() : "");
        return RestResponse.success(res);
    }

    @GetMapping(value={"/getByFans"})
    public RestResponse getByFans(String openId, HttpServletRequest request, HttpServletResponse response) {
        WxFans wxFans = (WxFans)this.wxFansService.selectById((Object)openId);
        Shift.throwsIfNull((Object)wxFans, (String)"\u7c89\u4e1d\u4e0d\u5b58\u5728");
        ShareLink shareLink = this.shareLinkService.selectByMemberId(wxFans.getId(), this.getAppId());
        WxFans parent = null;
        if (shareLink != null) {
            parent = (WxFans)this.wxFansService.selectById((Object)shareLink.getParentId());
        }
        MemberLevel shareLevel = this.memberLevelService.selectByLevel(0);
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        res.put("headImage", wxFans.getHeadImage());
        res.put("appellation", wxFans.getAppellation());
        res.put("isFrozen", false);
        res.put("parentAppellation", parent != null ? parent.getAppellation() : "");
        res.put("levelName", shareLevel != null ? shareLevel.getName() : "");
        res.put("levelIconUrl", shareLevel != null ? shareLevel.getIconUrl() : "");
        res.put("bonusAmount", 0);
        res.put("balanceAmount", 0);
        res.put("withdrawAmount", 0);
        res.put("createTime", wxFans.getUpdateTime());
        return RestResponse.success(res);
    }

    @GetMapping(value={"/myPageWithMember"})
    public RestResponse myPageWithMember(HttpServletRequest request) {
        List<Bootmap> lists;
        String memberId = ParamUtils.getString((ServletRequest)request, (String)"memberId");
        Page page = this.buildPage(request);
        if (StringUtils.isNotBlank((CharSequence)memberId)) {
            page.put((Object)"memberId", (Object)memberId);
        }
        if ((lists = this.shareChainService.pageMyMemberListWithMemberForAdmin(page)) != null && lists.size() > 0) {
            List<Bootmap> amountList;
            List<Bootmap> countList;
            List<String> idList = lists.stream().map(e -> e.getString("id")).collect(Collectors.toList());
            Bootmap countBoot = new Bootmap();
            Bootmap amountBoot = new Bootmap();
            if (page.getInteger("isMember", Integer.valueOf(0)) == 1 && (countList = this.shareChainService.countTeamUserByParentIdList(idList)) != null && countList.size() > 0) {
                for (Bootmap boot : countList) {
                    countBoot.put((Object)boot.getString("memberId"), (Object)boot.getInteger("teamCount"));
                }
            }
            if ((amountList = this.bonusFlowService.sumTotalBonusByTypeAndParentIdList(idList, BonusFlowTypeEnum.ORDER.id())) != null && amountList.size() > 0) {
                for (Bootmap boot : amountList) {
                    amountBoot.put((Object)boot.getString("memberId"), (Object)boot.getInteger("amount"));
                }
            }
            for (Bootmap boot : lists) {
                boot.put((Object)"userCount", (Object)countBoot.getInteger(boot.getString("id"), Integer.valueOf(0)));
                boot.put((Object)"totalAmount", (Object)amountBoot.getInteger(boot.getString("id"), Integer.valueOf(0)));
            }
        }
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    public CrudService<ShareMember> getService() {
        return null;
    }
}

