/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.admin;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.service.CrudService;
import com.wego168.share.domain.ShareLink;
import com.wego168.share.service.ShareLinkService;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.ParamUtils;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminShareLinkController")
@RequestMapping(value={"/api/admin/v1/shareLink"})
public class ShareLinkController
extends CrudController<ShareLink> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShareLinkController.class);
    @Autowired
    private ShareLinkService service;
    @Autowired
    private MemberAccountService memberAccountService;

    @GetMapping(value={"/pageFirstFans"})
    public RestResponse pageFirstFans(HttpServletRequest request, HttpServletResponse response) {
        String openId = ParamUtils.getString((ServletRequest)request, (String)"openId");
        String memberId = ParamUtils.getString((ServletRequest)request, (String)"memberId");
        if (StringUtils.isBlank((CharSequence)openId)) {
            MemberAccount account = this.memberAccountService.selectProgramAccount(memberId);
            openId = account.getUsername();
        }
        Page page = this.buildPage(request);
        page.put((Object)"openId", (Object)openId);
        List<Bootmap> lists = this.service.selectFirstFansListForAdmin(page);
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/pageSecondFans"})
    public RestResponse pageSecondFans(HttpServletRequest request, HttpServletResponse response) {
        String openId = ParamUtils.getString((ServletRequest)request, (String)"openId");
        String memberId = ParamUtils.getString((ServletRequest)request, (String)"memberId");
        if (StringUtils.isBlank((CharSequence)openId)) {
            MemberAccount account = this.memberAccountService.selectProgramAccount(memberId);
            openId = account.getUsername();
        }
        Page page = this.buildPage(request);
        page.put((Object)"openId", (Object)openId);
        List<Bootmap> lists = this.service.selectSecondFansListForAdmin(page);
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    public CrudService<ShareLink> getService() {
        return this.service;
    }
}

