/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.admin;

import com.wego168.exception.WegoException;
import com.wego168.share.domain.SharerConfig;
import com.wego168.share.enums.SharerChainModeEnum;
import com.wego168.share.service.SharerConfigService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.validation.constraints.PositiveInteger;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController(value="adminSharerConfigController")
public class SharerConfigController
extends SimpleController {
    @Autowired
    private SharerConfigService service;

    @GetMapping(value={"/api/admin/v1/sharer-config/get"})
    public RestResponse get() {
        String appId = this.getAppId();
        return RestResponse.success((Object)((Object)this.service.selectByAppId(appId)));
    }

    @PostMapping(value={"/api/admin/v1/sharer-config/update"})
    public RestResponse update(@NotBlankAndLength(min=1, message="\u63a8\u5e7f\u5173\u7cfb\u6a21\u5f0f\u7684\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String chainMode, @RequestParam(name="maxCommissionLevel", required=false) @PositiveInteger(defaultValue=1, message="\u4f63\u91d1\u7b49\u7ea7\u5fc5\u987b\u662f\u6b63\u6574\u6570") String maxCommissionLevelString) {
        try {
            Checker.checkInRange((Object)((Object)SharerChainModeEnum.get(chainMode)), (Object[])SharerChainModeEnum.values(), (String)"\u9519\u8bef\u7684\u63a8\u5e7f\u5173\u7cfb\u6a21\u5f0f");
            if (StringUtil.isBlank((String)maxCommissionLevelString)) {
                maxCommissionLevelString = "1";
            }
            SharerConfig param = new SharerConfig();
            param.setId(this.getAppId());
            param.setUpdateTime(new Date());
            param.setChainMode(chainMode);
            param.setMaxCommissionLevel(Integer.parseInt(maxCommissionLevelString));
            this.service.updateSelective((Object)param);
            return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

