/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.admin;

import com.simple.mybatis.Page;
import com.wego168.distribute.component.DistributerRegistComponent;
import com.wego168.distribute.enums.SharerAuditStatusEnum;
import com.wego168.distribute.service.impl.DistributerCommissionService;
import com.wego168.exception.WegoException;
import com.wego168.member.domain.Member;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.service.impl.WalletService;
import com.wego168.share.domain.Sharer;
import com.wego168.share.model.response.SharerAdminGetResponse;
import com.wego168.share.model.response.SharerAdminPageResponse;
import com.wego168.share.model.response.SharerAdminPageResponseV2;
import com.wego168.share.model.response.SharerPlatformAuditResponse;
import com.wego168.share.service.ShareOpenIdChainService;
import com.wego168.share.service.SharerFriendsService;
import com.wego168.share.service.SharerService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.util.excel.ExcelBook;
import com.wego168.util.excel.ExcelSheet;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.validation.constraints.PositiveInteger;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController(value="adminSharerController")
public class SharerController
extends SimpleController {
    @Autowired
    private SharerService service;
    @Autowired
    private WalletService walletService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private ShareOpenIdChainService shareOpenIdChainService;
    @Autowired
    private DistributerRegistComponent distributerRegistComponent;
    @Autowired
    private DistributerCommissionService distributerCommissionService;
    @Autowired
    private SharerFriendsService sharerFriendsService;

    @GetMapping(value={"/api/admin/v1/sharer/page"})
    public RestResponse selectPage(String appellation, String mobile, String orderBy, HttpServletRequest request) {
        String appId = this.getAppId();
        Page page = this.buildPage(request);
        List<SharerAdminPageResponse> list = this.service.selectPageForAdmin(appellation, mobile, appId, orderBy, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1.1/sharer/page"})
    public RestResponse selectPageV2(String name, String mobile, String auditStatus, @RequestParam(name="level", required=false) @PositiveInteger(defaultValue=1) String levelString, HttpServletRequest request) {
        String appId = this.getAppId();
        Page page = this.buildPage(request);
        Integer level = null;
        if (StringUtil.isNotBlank((String)levelString)) {
            level = Integer.parseInt(levelString);
        }
        List<SharerAdminPageResponseV2> list = this.service.selectPageForAdminV2(name, mobile, auditStatus, level, appId, page);
        this.sharerFriendsService.assembleCustomerQuantity(list, appId);
        this.distributerCommissionService.assembleCommission(list, appId);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1.1/sharer/export"})
    public void exportV2(String name, String mobile, String auditStatus, @RequestParam(name="level", required=false) @PositiveInteger(defaultValue=1) String levelString, HttpServletRequest request, HttpServletResponse response) {
        String appId = this.getAppId();
        Page page = this.buildPage(request);
        page.setPageSize(1000);
        Integer level = null;
        if (StringUtil.isNotBlank((String)levelString)) {
            level = Integer.parseInt(levelString);
        }
        List<SharerAdminPageResponseV2> list = this.service.selectPageForAdminV2(name, mobile, auditStatus, level, appId, page);
        this.sharerFriendsService.assembleCustomerQuantity(list, appId);
        this.distributerCommissionService.assembleCommission(list, appId);
        ExcelBook excelBook = ExcelBook.builder();
        ExcelSheet sheet = excelBook.createExcelSheet("\u63a8\u5e7f\u8005");
        sheet.setDataList(list);
        DecimalFormat formatter = new DecimalFormat("#######0.00");
        sheet.addCell("\u59d3\u540d", 10, "name");
        sheet.addCell("\u624b\u673a", 14, "mobile");
        sheet.addCell("\u7b49\u7ea7", 10, "level");
        sheet.addCell("\u5ba2\u6237\u6570", 10, i -> String.valueOf(i.getCustomerQuantity()));
        sheet.addCell("\u63a8\u5e7f\u4f63\u91d1", 16, i -> "\uffe5" + formatter.format((double)i.getCommission() * 0.01));
        sheet.addCell("\u5546\u6237", 20, "store");
        sheet.addCell("\u6ce8\u518c\u65f6\u95f4", 18, "createTime");
        excelBook.export("\u63a8\u5e7f\u8005.xls", response);
    }

    @GetMapping(value={"/api/admin/v1/sharer/platform-audit-page"})
    public RestResponse selectPlatformAuditPage(String mobile, String auditStatus, HttpServletRequest request) {
        String appId = this.getAppId();
        Page page = this.buildPage(request);
        List<SharerPlatformAuditResponse> list = this.service.selectPlatformAuditPage(mobile, auditStatus, appId, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/api/admin/v1/sharer/audit"})
    public RestResponse audit(@NotBlankAndLength(max=0x7FFFFFFF, message="id\u975e\u6cd5") String id) {
        String[] idArray = id.split(",");
        Map<String, Sharer> map = this.service.selectMapByIdArray(idArray);
        int rows = 0;
        StringBuffer auditedName = new StringBuffer();
        Date now = new Date();
        for (Map.Entry<String, Sharer> entry : map.entrySet()) {
            Sharer sharer = entry.getValue();
            String auditStatus = sharer.getAuditStatus();
            if (StringUtil.equals((String)auditStatus, (String)SharerAuditStatusEnum.AUDITED.value())) {
                auditedName.append(String.valueOf(sharer.getName()) + ",");
                continue;
            }
            Sharer param = new Sharer();
            param.setId(entry.getKey());
            param.setAuditStatus(SharerAuditStatusEnum.AUDITED.value());
            param.setStatus(SharerAuditStatusEnum.AUDITED.value());
            param.setUpdateTime(now);
            this.service.updateSelective((Object)param);
            ++rows;
        }
        StringBuffer message = new StringBuffer();
        message.append(rows).append("\u4eba\u5ba1\u6838\u6210\u529f");
        if (auditedName.length() > 0) {
            message.append("\uff0c").append(StringUtil.deleteLastCharAndToString((StringBuffer)auditedName)).append("\u5df2\u7ecf\u662f\u5ba1\u6838\u72b6\u6001");
        }
        return RestResponse.success(null, (String)message.toString());
    }

    @PostMapping(value={"/api/admin/v1/sharer/refuse"})
    public RestResponse refuse(@NotBlankAndLength(max=0x7FFFFFFF, message="id\u975e\u6cd5") String id) {
        String[] idArray = id.split(",");
        Map<String, Sharer> map = this.service.selectMapByIdArray(idArray);
        int rows = 0;
        StringBuffer refusedName = new StringBuffer();
        Date now = new Date();
        for (Map.Entry<String, Sharer> entry : map.entrySet()) {
            Sharer sharer = entry.getValue();
            String auditStatus = sharer.getAuditStatus();
            if (StringUtil.equals((String)auditStatus, (String)SharerAuditStatusEnum.REFUSED.value())) {
                refusedName.append(String.valueOf(sharer.getName()) + ",");
                continue;
            }
            Sharer param = new Sharer();
            param.setId(entry.getKey());
            param.setStatus(SharerAuditStatusEnum.REFUSED.value());
            param.setAuditStatus(SharerAuditStatusEnum.REFUSED.value());
            param.setUpdateTime(now);
            this.service.updateSelective((Object)param);
            ++rows;
        }
        StringBuffer message = new StringBuffer();
        message.append(rows).append("\u4eba\u62d2\u7edd\u5ba1\u6838\u6210\u529f");
        if (refusedName.length() > 0) {
            message.append("\uff0c").append(StringUtil.deleteLastCharAndToString((StringBuffer)refusedName)).append("\u5df2\u7ecf\u662f\u5ba1\u6838\u4e0d\u901a\u8fc7\u72b6\u6001");
        }
        return RestResponse.success(null, (String)message.toString());
    }

    @GetMapping(value={"/api/admin/v1/sharer/get"})
    public RestResponse get(String id, HttpServletRequest request) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"\u63a8\u5e7f\u8005", (int)32);
            Sharer sharer = (Sharer)((Object)this.service.selectById(id));
            Checker.checkCondition((sharer == null ? 1 : 0) != 0, (String)"\u8be5\u63a8\u5e7f\u8005\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            String openId = this.distributerRegistComponent.ensureOpenId(id, request);
            Checker.checkCondition((boolean)StringUtil.isBlank((String)openId), (String)"\u8be5\u63a8\u5e7f\u8005\u672a\u7ed1\u5b9a\u5fae\u4fe1\u8d26\u53f7\uff0c\u65e0\u6cd5\u67e5\u770b\u8be6\u7ec6\u6570\u636e");
            Member member = this.memberService.selectById(id);
            String appId = super.getAppId();
            int customerQuantity = this.shareOpenIdChainService.sumCustomerQuantity(openId, appId);
            Page page = super.buildPage(request);
            this.distributerCommissionService.selectPageForMember(id, null, null, null, "share", page);
            int customerOrderQuantity = (int)page.getTotal();
            int wallet = this.walletService.getWalletAmount(id);
            return RestResponse.success((Object)new SharerAdminGetResponse(sharer, member, customerQuantity, customerOrderQuantity, wallet));
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

