/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.admin;

import com.simple.mybatis.Page;
import com.wego168.base.domain.FileServer;
import com.wego168.base.domain.Storable;
import com.wego168.base.service.FileServerService;
import com.wego168.base.service.StorableService;
import com.wego168.exception.WegoException;
import com.wego168.share.domain.SharerLevel;
import com.wego168.share.domain.SharerLevelCondition;
import com.wego168.share.enums.SharerLevelConditionGoalTypeEnum;
import com.wego168.share.model.response.SharerLevelAdminGetResponse;
import com.wego168.share.model.response.SharerLevelAdminPageResponse;
import com.wego168.share.service.SharerLevelConditionService;
import com.wego168.share.service.SharerLevelService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminSharerLevelController")
public class SharerLevelController
extends SimpleController {
    @Autowired
    private StorableService storableService;
    @Autowired
    private FileServerService fileServerService;
    @Autowired
    private SharerLevelService service;
    @Autowired
    private SharerLevelConditionService sharerLevelConditionService;

    @PostMapping(value={"/api/admin/v1/sharer-level/insert"})
    public RestResponse insert(String icon, String name, String goalType, @RequestParam(required=false, name="goalQuantity") String goalQuantityString, @RequestParam(required=false, name="commissionRate") String commissionRateString, @RequestParam(required=false, name="commissionRate2") String commissionRate2String, @RequestParam(required=false, name="pointRate") String pointRateString, @RequestParam(required=false, name="level") String levelString) {
        try {
            int level = Checker.checkStringIsPositiveInteger((String)levelString, (String)"\u7b49\u7ea7");
            int commissionRate = Checker.checkStringIsUnsignedInteger((String)commissionRateString, (String)"1\u7ea7\u63a8\u5e7f\u4f63\u91d1\u6bd4\u7387");
            int commissionRate2 = Checker.checkStringIsUnsignedInteger((String)commissionRate2String, (String)"2\u7ea7\u63a8\u5e7f\u4f63\u91d1\u6bd4\u7387");
            if (StringUtil.isBlank((String)pointRateString)) {
                pointRateString = "0";
            }
            int pointRate = Checker.checkStringIsUnsignedInteger((String)commissionRateString, (String)"\u63a8\u5e7f\u79ef\u5206\u6bd4\u7387");
            Checker.checkBlankAndLength((String)name, (String)"\u7b49\u7ea7\u540d\u79f0", (int)16);
            Checker.checkBlankOrLength((String)icon, (String)"\u7b49\u7ea7\u56fe\u6807", (int)256);
            Checker.checkCondition((!SharerLevelConditionGoalTypeEnum.isValid(goalType) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u7b49\u7ea7\u76ee\u6807\u7c7b\u578b");
            String goalTypeName = "\u5347\u7ea7\u6240\u9700" + SharerLevelConditionGoalTypeEnum.get(goalType).description();
            int goalQuantity = Checker.checkStringIsUnsignedInteger((String)goalQuantityString, (String)goalTypeName);
            String appId = this.getAppId();
            SharerLevel existLevel = this.service.selectByLevel(appId, level);
            Checker.checkCondition((existLevel != null ? 1 : 0) != 0, (String)("\u7b49\u7ea7" + level + "\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0\u76f8\u540c\u7b49\u7ea7"));
            String defaultServerId = "1";
            if (StringUtil.isNotBlank((String)icon)) {
                FileServer server = (FileServer)this.fileServerService.selectById((Object)defaultServerId);
                Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u56fe\u7247\u670d\u52a1\u5668\u672a\u914d\u7f6e");
            }
            String description = null;
            this.service.insert(icon, name, level, commissionRate, commissionRate2, pointRate, goalQuantity, goalType, description, defaultServerId, appId);
            return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/sharer-level/delete"})
    public RestResponse delete(String id) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"\u7b49\u7ea7", (int)32);
            this.service.deleteLevelAndCondition(id);
            return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/sharer-level/update"})
    public RestResponse update(String id, String icon, String name, String goalType, @RequestParam(required=false, name="goalQuantity") String goalQuantityString, @RequestParam(required=false, name="commissionRate") String commissionRateString, @RequestParam(required=false, name="commissionRate2") String commissionRate2String, @RequestParam(required=false, name="pointRate") String pointRateString, @RequestParam(required=false, name="level") String levelString) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"\u7b49\u7ea7", (int)32);
            int level = Checker.checkStringIsPositiveInteger((String)levelString, (String)"\u7b49\u7ea7");
            int commissionRate = Checker.checkStringIsUnsignedInteger((String)commissionRateString, (String)"1\u7ea7\u63a8\u5e7f\u4f63\u91d1\u6bd4\u7387");
            int commissionRate2 = Checker.checkStringIsUnsignedInteger((String)commissionRate2String, (String)"2\u7ea7\u63a8\u5e7f\u4f63\u91d1\u6bd4\u7387");
            if (StringUtil.isBlank((String)pointRateString)) {
                pointRateString = "0";
            }
            int pointRate = Checker.checkStringIsUnsignedInteger((String)commissionRateString, (String)"\u63a8\u5e7f\u79ef\u5206\u6bd4\u7387");
            Checker.checkBlankAndLength((String)name, (String)"\u7b49\u7ea7\u540d\u79f0", (int)16);
            Checker.checkBlankOrLength((String)icon, (String)"\u7b49\u7ea7\u56fe\u6807", (int)256);
            Checker.checkCondition((!SharerLevelConditionGoalTypeEnum.isValid(goalType) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u7b49\u7ea7\u76ee\u6807\u7c7b\u578b");
            String goalTypeName = "\u5347\u7ea7\u6240\u9700" + SharerLevelConditionGoalTypeEnum.get(goalType).description();
            int goalQuantity = Checker.checkStringIsUnsignedInteger((String)goalQuantityString, (String)goalTypeName);
            String appId = this.getAppId();
            SharerLevel existLevel = this.service.selectByLevel(appId, level);
            Checker.checkCondition((existLevel != null && !StringUtil.equals((String)existLevel.getId(), (String)id) ? 1 : 0) != 0, (String)("\u7b49\u7ea7" + level + "\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u4fee\u6539\u4e3a\u5df2\u5b58\u5728\u7684\u7b49\u7ea7"));
            String defaultServerId = "1";
            if (StringUtil.isNotBlank((String)icon)) {
                FileServer server = (FileServer)this.fileServerService.selectById((Object)defaultServerId);
                Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u56fe\u7247\u670d\u52a1\u5668\u672a\u914d\u7f6e");
            }
            String description = null;
            this.service.update(id, icon, name, level, commissionRate, commissionRate2, pointRate, goalQuantity, goalType, description, defaultServerId);
            return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/admin/v1/sharer-level/page"})
    public RestResponse selectPage(HttpServletRequest request) {
        String appId = this.getAppId();
        Page page = this.buildPage(request);
        List<SharerLevelAdminPageResponse> list = this.service.selectPageForAdmin(appId, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/sharer-level/get"})
    public RestResponse get(String id) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"\u7b49\u7ea7", (int)32);
            SharerLevel levelDb = (SharerLevel)((Object)this.service.selectById(id));
            Checker.checkCondition((levelDb == null ? 1 : 0) != 0, (String)"\u8be5\u7b49\u7ea7\u4e0d\u5b58\u5728");
            SharerLevelCondition levelConditionDb = this.sharerLevelConditionService.selectByLevelId(id);
            SharerLevelAdminGetResponse response = new SharerLevelAdminGetResponse(levelDb, levelConditionDb);
            this.storableService.assembleHost((Storable)response);
            return RestResponse.success((Object)response);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

