/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.member;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Config;
import com.wego168.base.domain.Storable;
import com.wego168.base.service.AppAbilityService;
import com.wego168.base.service.ConfigService;
import com.wego168.base.service.StorableService;
import com.wego168.distribute.enums.SharerAuditStatusEnum;
import com.wego168.distribute.enums.WithdrawAccountTypeEnum;
import com.wego168.exception.WegoException;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.enums.AccountTypeEnum;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.util.SessionUtil;
import com.wego168.share.component.SharerRegistComponent;
import com.wego168.share.domain.Sharer;
import com.wego168.share.domain.SharerBecomeCondition;
import com.wego168.share.domain.SharerLevel;
import com.wego168.share.enums.SharerBecomeConditionEnum;
import com.wego168.share.model.SharerRegistData;
import com.wego168.share.model.response.SharerFriendsWebPageResponse;
import com.wego168.share.service.ShareOpenIdChainService;
import com.wego168.share.service.SharerBecomeConditionConfigService;
import com.wego168.share.service.SharerLevelService;
import com.wego168.share.service.SharerService;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController(value="memberSharerController")
public class SharerController
extends SimpleController {
    @Autowired
    private ShareOpenIdChainService shareOpenIdChainService;
    @Autowired
    private SharerRegistComponent sharerRegistComponent;
    @Autowired
    private MemberService memberService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private SharerBecomeConditionConfigService sharerBecomeConditionConfigService;
    @Autowired
    private SharerService service;
    @Autowired
    private StorableService storableService;
    @Autowired
    private SharerLevelService sharerLevelService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private AppAbilityService abilityService;
    private Logger logger = LoggerFactory.getLogger(SharerController.class);

    @GetMapping(value={"/api/v1/sharer/get"})
    public RestResponse get() {
        try {
            String openId = SessionUtil.getOpenId();
            String memberId = null;
            if (StringUtil.isNotBlank((String)openId)) {
                MemberAccount account = this.memberAccountService.selectByUsername(openId);
                if (account != null) {
                    memberId = account.getMemberId();
                }
            } else {
                memberId = SessionUtil.getMemberIdIfNotAuthToThrow();
            }
            Bootmap response = new Bootmap();
            boolean isSharer = false;
            int level = 1;
            if (StringUtil.isBlank((String)memberId)) {
                response.put((Object)"id", (Object)memberId);
                response.put((Object)"name", null);
                response.put((Object)"appellation", null);
                response.put((Object)"headImage", null);
            } else {
                response.put((Object)"id", (Object)memberId);
                Sharer sharer = (Sharer)((Object)this.service.selectById(memberId));
                Member member = this.memberService.selectById(memberId);
                isSharer = sharer != null;
                int n = level = isSharer ? sharer.getLevel() : 1;
                if (isSharer) {
                    response.put((Object)"status", (Object)sharer.getStatus());
                    response.put((Object)"auditStatus", (Object)sharer.getAuditStatus());
                }
                response.put((Object)"name", (Object)member.getName());
                response.put((Object)"appellation", (Object)member.getAppellation());
                response.put((Object)"headImage", (Object)member.getHeadImage());
            }
            response.put((Object)"isSharer", (Object)isSharer);
            response.put((Object)"level", (Object)level);
            String appId = this.getAppId();
            SharerLevel sharerLevel = this.sharerLevelService.selectByLevel(appId, level);
            response.put((Object)"levelName", (Object)sharerLevel.getName());
            response.put((Object)"levelIcon", (Object)sharerLevel.getIcon());
            response.put((Object)"commissionRate", (Object)sharerLevel.getCommissionRate());
            this.storableService.assembleHost((Storable)sharerLevel);
            response.put((Object)"levelIconHost", (Object)sharerLevel.getHost());
            return RestResponse.success((Object)response);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/v1/sharer/regist"})
    public RestResponse registSharer(@RequestBody(required=false) Map<String, String> registrationData, HttpServletRequest request) {
        try {
            String appId = this.getAppId();
            String openId = SessionUtil.getOpenIdIfAbsentToThrow();
            String unionId = null;
            String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
            if (StringUtil.isBlank((String)memberId)) {
                memberId = this.service.ensureMemberAndAccountWhenRegist(new SharerRegistData(), openId, unionId, appId);
            }
            this.logger.error("\u6ce8\u518c\u63a8\u5e7f\u8005\uff1aappid->{},openid->{},memberid->{}", new Object[]{appId, openId, memberId});
            if (StringUtil.isBlank((String)memberId)) {
                return RestResponse.success(null, (String)"\u672a\u6ce8\u518c\uff0c\u56e0\u4e3a\u4f1a\u5458\u4e0d\u5b58\u5728");
            }
            Sharer sharer = (Sharer)((Object)this.service.selectById(memberId));
            SharerBecomeCondition condition = this.sharerBecomeConditionConfigService.selectConfig(appId).get(0);
            if (sharer != null) {
                String auditStatus = sharer.getAuditStatus();
                if (StringUtil.equals((String)condition.getCondition(), (String)SharerBecomeConditionEnum.REGIST_AND_AUDIT.value()) && (StringUtil.equals((String)auditStatus, (String)SharerAuditStatusEnum.REFUSED.value()) || StringUtil.equals((String)auditStatus, (String)SharerAuditStatusEnum.WAITING.value()))) {
                    this.sharerRegistComponent.updateRegistrationData(registrationData, memberId, appId);
                    return RestResponse.success(null, (String)"\u6ce8\u518c\u8d44\u6599\u5df2\u66f4\u65b0\uff0c\u6b63\u5728\u7b49\u5f85\u5ba1\u6838");
                }
                Checker.checkCondition((boolean)StringUtil.equals((String)auditStatus, (String)SharerAuditStatusEnum.WAITING.value()), (String)"\u60a8\u7684\u8d44\u6599\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019");
                Checker.checkCondition((boolean)true, (String)"\u60a8\u5df2\u7ecf\u6ce8\u518c\u8fc7\u4e86");
            }
            Member member = this.memberService.selectById(memberId);
            return this.sharerRegistComponent.registByCondition(registrationData, member, openId, condition);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1/sharer/customers"})
    public RestResponse getCustomers(String appellation, Boolean showCommission, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        String openId = this.sharerRegistComponent.ensureOpenId(request);
        Page page = this.buildPage(request);
        showCommission = showCommission == null ? true : showCommission;
        int accountType = AccountTypeEnum.PROGRAM.value();
        List<SharerFriendsWebPageResponse> friends = this.shareOpenIdChainService.selectFriendsPage(appellation, openId, memberId, showCommission, accountType, page);
        page.setList(friends);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1/sharer/get-withdraw-account"})
    public RestResponse getWithdrawAccount() {
        try {
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            Sharer sharer = (Sharer)((Object)this.service.selectById(memberId));
            Checker.checkCondition((sharer == null ? 1 : 0) != 0, (String)"\u672a\u6ce8\u518c\u7684\u7528\u6237");
            String withdrawAccount = sharer.getWithdrawAccount();
            String withdrawName = sharer.getWithdrawName();
            Bootmap response = new Bootmap();
            response.put((Object)"withdrawAccount", (Object)withdrawAccount);
            response.put((Object)"withdrawName", (Object)withdrawName);
            response.put((Object)"withdrawAccountType", (Object)sharer.getWithdrawAccountType());
            return RestResponse.success((Object)response, (String)"ok");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/v1/sharer/update-withdraw-account"})
    public RestResponse updateWithdrawAccount(@NotBlankAndLength(min=1, message="\u63d0\u73b0\u8d26\u53f7\u7684\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String withdrawAccount, @NotBlankAndLength(min=1, message="\u59d3\u540d\u7684\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String withdrawName) {
        try {
            String withdrawAccountType = WithdrawAccountTypeEnum.PRIVATE_BANK.value();
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            Sharer param = new Sharer();
            param.setId(memberId);
            param.setWithdrawAccount(withdrawAccount);
            param.setWithdrawAccountType(withdrawAccountType);
            param.setWithdrawName(withdrawName);
            this.service.updateSelective((Object)param);
            return RestResponse.success(null, (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/v1/sharer/update-name"})
    public RestResponse updateName(@NotBlankAndLength(min=1, max=16, message="\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a") String name) {
        try {
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            Sharer param = new Sharer();
            param.setId(memberId);
            param.setName(name);
            param.setUpdateTime(new Date());
            this.service.updateSelective((Object)param);
            return RestResponse.success(null, (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/v1.1/memberLevelFee/getTips"})
    public RestResponse getTips(HttpServletRequest request) {
        Sharer sharer;
        Config config = this.configService.getCache("memberLevelFeeTips", this.getAppId());
        if (config == null) {
            return RestResponse.success(null);
        }
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        if (StringUtil.isNotBlank((String)memberId) && this.abilityService.isOpen(super.getAppId(), "junk-sharer-buy-saving-commission") && (sharer = (Sharer)((Object)this.service.selectById(memberId))) != null) {
            return RestResponse.success(null);
        }
        return RestResponse.success((String)config.getValue());
    }
}

