/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.member;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.distribute.service.impl.DistributerCommissionService;
import com.wego168.distribute.service.impl.WithdrawService;
import com.wego168.exception.WegoException;
import com.wego168.member.service.impl.WalletService;
import com.wego168.member.util.SessionUtil;
import com.wego168.share.component.SharerRegistComponent;
import com.wego168.share.service.ShareOpenIdChainService;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="memberSharerSummaryController")
public class SharerSummaryController
extends SimpleController {
    @Autowired
    private ShareOpenIdChainService shareOpenIdChainService;
    @Autowired
    private WalletService walletService;
    @Autowired
    private WithdrawService withdrawService;
    @Autowired
    private DistributerCommissionService distributerCommissionService;
    @Autowired
    private SharerRegistComponent sharerRegistComponent;

    @GetMapping(value={"/api/v1/sharer-summary"})
    public RestResponse getSummary(HttpServletRequest request) {
        try {
            String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
            String openId = this.sharerRegistComponent.ensureOpenId(request);
            String appId = super.getAppId();
            int customerQuantity = this.shareOpenIdChainService.sumCustomerQuantity(openId, appId);
            Page page = super.buildPage(request);
            this.distributerCommissionService.selectPageForMember(memberId, null, null, null, "sharer", page);
            int customerOrderQuantity = (int)page.getTotal();
            int wallet = this.walletService.getWalletAmount(memberId);
            int withdrawed = this.withdrawService.sumWithdrawAmount(memberId);
            int commissionAmount = this.distributerCommissionService.sumCommissionAmount(memberId, "sharer");
            int totalCommissionAmount = this.distributerCommissionService.sumTotalCommissionAmount(memberId, "sharer");
            Bootmap response = new Bootmap();
            response.put((Object)"wallet", (Object)wallet);
            response.put((Object)"customerQuantity", (Object)customerQuantity);
            response.put((Object)"friendQuantity", (Object)0);
            response.put((Object)"customerOrderQuantity", (Object)customerOrderQuantity);
            response.put((Object)"totalCommission", (Object)totalCommissionAmount);
            response.put((Object)"currentCommission", (Object)(commissionAmount - withdrawed));
            response.put((Object)"withdrawed", (Object)withdrawed);
            return RestResponse.success((Object)response);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

