/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.mobile;

import com.simple.mybatis.Bootmap;
import com.wego168.member.domain.Member;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.util.SessionUtil;
import com.wego168.service.CrudService;
import com.wego168.share.domain.Bonus;
import com.wego168.share.service.BonusFlowService;
import com.wego168.share.service.BonusService;
import com.wego168.share.service.ShareChainService;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/bonus"})
public class BonusController
extends CrudController<Bonus> {
    static final SimpleDateFormat DATE_FOR_MAT = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private BonusService service;
    @Autowired
    private BonusFlowService bonusFlowService;
    @Autowired
    private ShareChainService shareChainService;
    @Autowired
    private MemberService memberService;

    public CrudService<Bonus> getService() {
        return this.service;
    }

    @GetMapping(value={"/myBonus"})
    public RestResponse myBonus(HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Member member = this.memberService.selectById(memberId);
        Bonus bonus = this.service.selectByStoreMember("0", memberId);
        int todayAmount = this.bonusFlowService.sumTodayAmount(memberId);
        int totalAmount = 0;
        int amount = 0;
        if (bonus != null) {
            totalAmount = bonus.getTotalAmount() == null ? 0 : bonus.getTotalAmount();
            amount = bonus.getAmount() == null ? 0 : bonus.getAmount();
        }
        Bootmap btm = new Bootmap();
        btm.put((Object)"appellation", (Object)member.getAppellation());
        btm.put((Object)"headImage", (Object)member.getHeadImage());
        btm.put((Object)"totalAmount", (Object)totalAmount);
        btm.put((Object)"amount", (Object)amount);
        btm.put((Object)"todayAmount", (Object)todayAmount);
        return RestResponse.success((Object)btm);
    }

    @GetMapping(value={"/myTeamBonus"})
    public RestResponse myTeamBonus(HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        int teamUsers = this.shareChainService.countTeamUser(memberId);
        Bootmap btp = this.bonusFlowService.sumTeamAmount(memberId);
        int todayAmount = 0;
        int totalAmount = 0;
        if (btp != null) {
            if (btp.getInteger("todayAmount") != null) {
                todayAmount = btp.getInteger("todayAmount");
            }
            if (btp.getInteger("totalAmount") != null) {
                totalAmount = btp.getInteger("totalAmount");
            }
        }
        Bootmap bootmap = new Bootmap();
        bootmap.put((Object)"teamUsers", (Object)teamUsers);
        bootmap.put((Object)"totalAmount", (Object)totalAmount);
        bootmap.put((Object)"todayAmount", (Object)todayAmount);
        return RestResponse.success((Object)bootmap);
    }

    @GetMapping(value={"/listByDays"})
    public RestResponse listByDays(Integer days, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        days = days == null ? 7 : days;
        List<Map<String, String>> paramList = this.getParams(days);
        Bootmap bootmap = this.service.selectListByDays(paramList, memberId);
        LinkedList<Bootmap> resultList = new LinkedList<Bootmap>();
        int i = 0;
        while (i < paramList.size()) {
            Map<String, String> param = paramList.get(i);
            String key = param.get("amount");
            Integer amount = bootmap == null ? 0 : bootmap.getInteger(key);
            Bootmap btm = new Bootmap();
            btm.put((Object)"date", (Object)param.get("startDate"));
            btm.put((Object)"amount", (Object)amount);
            resultList.add(btm);
            ++i;
        }
        return RestResponse.success(resultList);
    }

    private List<Map<String, String>> getParams(int days) {
        LinkedList<String> dayList = new LinkedList<String>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) - days);
        int i = -days;
        while (i <= 0) {
            calendar.set(6, calendar.get(6) + 1);
            Date day = calendar.getTime();
            dayList.add(format.format(day));
            ++i;
        }
        LinkedList<Map<String, String>> paramList = new LinkedList<Map<String, String>>();
        int i2 = 0;
        while (i2 < days) {
            LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
            param.put("startDate", (String)dayList.get(i2));
            param.put("endDate", (String)dayList.get(i2 + 1));
            param.put("amount", "amount" + i2);
            paramList.add(param);
            ++i2;
        }
        return paramList;
    }
}

