/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.mobile;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.member.domain.Member;
import com.wego168.member.domain.MemberAccount;
import com.wego168.member.service.impl.MemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.util.SessionUtil;
import com.wego168.service.CrudService;
import com.wego168.share.domain.Bonus;
import com.wego168.share.domain.BonusWithdraw;
import com.wego168.share.domain.BonusWithdrawAccount;
import com.wego168.share.domain.BonusWithdrawProgress;
import com.wego168.share.enums.BonusFlowTypeEnum;
import com.wego168.share.enums.BonusWithdrawAccountType;
import com.wego168.share.service.BonusFlowService;
import com.wego168.share.service.BonusService;
import com.wego168.share.service.BonusWithdrawAccountService;
import com.wego168.share.service.BonusWithdrawProgressService;
import com.wego168.share.service.BonusWithdrawService;
import com.wego168.share.service.ShareConfigService;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/bonusWithdraw"})
public class BonusWithdrawController
extends CrudController<BonusWithdraw> {
    @Autowired
    private BonusWithdrawService service;
    @Autowired
    private BonusService bonusService;
    @Autowired
    private BonusWithdrawProgressService bonusWithdrawProgressService;
    @Autowired
    private BonusWithdrawAccountService bonusWithdrawAccountService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private MemberAccountService memberAccountService;
    @Autowired
    private ShareConfigService shareConfigService;
    @Autowired
    private BonusFlowService bonusFlowService;

    public CrudService<BonusWithdraw> getService() {
        return this.service;
    }

    @GetMapping(value={"/preApply"})
    public RestResponse preApply(int accountType, HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Member member = this.memberService.selectById(memberId);
        Bonus bonus = this.bonusService.selectByStoreMember("0", memberId);
        int totalBonus = this.bonusFlowService.sumTotalBonusByType(memberId, BonusFlowTypeEnum.ORDER.id());
        String payeeAccount = null;
        String payeeRealName = null;
        if (BonusWithdrawAccountType.WXPAY.id == accountType) {
            MemberAccount memberAccount = this.memberAccountService.selectWechatAccount(memberId);
            Shift.throwsIfNull((Object)memberAccount, (String)"\u60a8\u5c1a\u672a\u8bf7\u7ed1\u5b9a\u5fae\u4fe1\u8d26\u53f7");
        } else {
            BonusWithdrawAccount bonusWithdrawAccount = this.bonusWithdrawAccountService.selectBind(memberId, accountType);
            if (bonusWithdrawAccount != null) {
                payeeAccount = bonusWithdrawAccount.getPayeeAccount();
                payeeRealName = bonusWithdrawAccount.getPayeeRealName();
            }
        }
        Optional<Bonus> bonusOps = Optional.ofNullable(bonus);
        int withdramServiceFee = this.shareConfigService.getWithdramServiceFee(this.getAppId());
        int withdrawAmount = this.service.sumTotalWithdrawAmount(memberId);
        Bootmap Bootmap2 = new Bootmap();
        Bootmap2.put((Object)"appellation", (Object)member.getAppellation());
        Bootmap2.put((Object)"headImage", (Object)member.getHeadImage());
        Bootmap2.put((Object)"payeeAccount", (Object)payeeAccount);
        Bootmap2.put((Object)"payeeRealName", (Object)payeeRealName);
        Bootmap2.put((Object)"amount", (Object)bonusOps.map(Bonus::getAmount).orElse(0));
        Bootmap2.put((Object)"totalAmount", (Object)totalBonus);
        Bootmap2.put((Object)"withdrawAmount", (Object)withdrawAmount);
        Bootmap2.put((Object)"withdramServiceFee", (Object)withdramServiceFee);
        return RestResponse.success((Object)Bootmap2);
    }

    @PostMapping(value={"/apply"})
    public RestResponse apply(BonusWithdraw param, int accountType, HttpServletRequest request) {
        MemberAccount memberAccount;
        int sourceType = param.getSourceType() == null ? 3 : param.getSourceType();
        param.setSourceType(sourceType);
        int withdramServiceFee = this.shareConfigService.getWithdramServiceFee(this.getAppId());
        int withdramAmount = this.shareConfigService.getWithdramAmount(this.getAppId());
        Shift.throwsIfNull((Object)param.getAmount(), (String)"\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Shift.throwsIfInvalid((param.getAmount() < withdramAmount ? 1 : 0) != 0, (String)("\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e" + (double)withdramAmount / 100.0 + "\u5143"));
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Bonus bonus = this.bonusService.selectByStoreMember("0", memberId);
        Shift.throwsIfNull((Object)((Object)bonus), (String)"\u6ca1\u6709\u53ef\u63d0\u73b0\u7684\u91d1\u989d");
        int balanceAmount = bonus.getAmount();
        int applyAmount = param.getAmount() + withdramServiceFee;
        Shift.throwsIfInvalid((balanceAmount < applyAmount ? 1 : 0) != 0, (String)("\u63d0\u73b0\u91d1\u989d\uff08\u5305\u542b\u624b\u7eed\u8d39\uff09\u4e0d\u80fd\u5927\u4e8e\u4f59\u989d\uff0c\u60a8\u5f53\u524d\u4f59\u989d\u4e3a" + (double)bonus.getAmount().intValue() / 100.0 + "\u5143"));
        if (BonusWithdrawAccountType.WXPAY.id == accountType && (memberAccount = this.memberAccountService.selectWechatAccount(memberId)) != null) {
            param.setPayeeAccount(memberAccount.getUsername());
            param.setPayeeRealName("");
        }
        Shift.throwsIfInvalid((boolean)StringUtils.isBlank((CharSequence)param.getPayeeAccount()), (String)"\u6536\u6b3e\u65b9\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        if (BonusWithdrawAccountType.WXPAY.id != accountType) {
            Shift.throwsIfInvalid((boolean)StringUtils.isBlank((CharSequence)param.getPayeeRealName()), (String)" \u6536\u6b3e\u65b9\u771f\u5b9e\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        param.setPayeeAccount(param.getPayeeAccount().trim());
        if (StringUtils.isNotBlank((CharSequence)param.getPayeeRealName())) {
            param.setPayeeRealName(param.getPayeeRealName().trim());
        }
        param.setAccountType(accountType);
        param.setMemberId(memberId);
        param.setFeeAmount(withdramServiceFee);
        param.setIsManual(false);
        this.service.apply(param);
        return RestResponse.success((Object)((Object)param));
    }

    @GetMapping(value={"/get"})
    public RestResponse get(String id, HttpServletRequest request) {
        BonusWithdraw bonusWithdraw = (BonusWithdraw)((Object)this.service.selectById(id));
        if (bonusWithdraw != null) {
            List<BonusWithdrawProgress> progressList = this.bonusWithdrawProgressService.selectListByBonusWithdrawId(bonusWithdraw.getId());
            bonusWithdraw.setProgressList(progressList);
        }
        return RestResponse.success((Object)((Object)bonusWithdraw));
    }

    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Page page = this.buildPage(request);
        page.put((Object)"memberId", (Object)memberId);
        List<BonusWithdraw> lists = this.service.page(page);
        page.setList(lists);
        return RestResponse.success((Object)page);
    }
}

