/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.mobile;

import com.simple.mybatis.Bootmap;
import com.wego168.member.domain.Member;
import com.wego168.member.service.impl.MemberService;
import com.wego168.member.util.SessionUtil;
import com.wego168.share.domain.Bonus;
import com.wego168.share.service.BonusService;
import com.wego168.share.service.ShareChainService;
import com.wego168.util.Shift;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.response.RestStatus;
import com.wego168.web.response.StatusCode;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/share"})
public class ShareAssembleController
extends SimpleController {
    @Autowired
    private BonusService bonusService;
    @Autowired
    private ShareChainService shareChainService;
    @Autowired
    private MemberService memberService;

    @GetMapping(value={"/index"})
    public RestResponse get(HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Bootmap lnumMap = this.shareChainService.groupByLevel(memberId);
        Bonus bonus = this.bonusService.selectByStoreMember("0", memberId);
        Optional<Bootmap> numOptional = Optional.ofNullable(lnumMap);
        int levelNum1 = numOptional.map(e -> e.getInteger("levelNum1")).orElse(0);
        int levelNum2 = numOptional.map(e -> e.getInteger("levelNum2")).orElse(0);
        int levelNum3 = numOptional.map(e -> e.getInteger("levelNum3")).orElse(0);
        Optional<Bonus> bonusOptional = Optional.ofNullable(bonus);
        int totalAmount = bonusOptional.map(Bonus::getTotalAmount).orElse(0);
        int amount = bonusOptional.map(Bonus::getAmount).orElse(0);
        int ranking = this.bonusService.myRanking(totalAmount);
        Bootmap btm = new Bootmap();
        btm.put((Object)"levelNum1", (Object)levelNum1);
        btm.put((Object)"levelNum2", (Object)levelNum2);
        btm.put((Object)"levelNum3", (Object)levelNum3);
        btm.put((Object)"totalAmount", (Object)totalAmount);
        btm.put((Object)"amount", (Object)amount);
        btm.put((Object)"ranking", (Object)ranking);
        return RestResponse.success((Object)btm);
    }

    @GetMapping(value={"/home"})
    public RestResponse home(HttpServletRequest request) {
        String memberId = SessionUtil.getMemberId((HttpServletRequest)request);
        Shift.throwsIfInvalid((boolean)StringUtils.isBlank((CharSequence)memberId), (RestStatus)StatusCode.NOT_MEMBER);
        Member member = this.memberService.selectById(memberId);
        Optional<Member> optional = Optional.ofNullable(member);
        Bootmap res = new Bootmap();
        res.put((Object)"appellation", (Object)optional.map(e -> e.getAppellation()).orElse(""));
        res.put((Object)"headImage", (Object)optional.map(e -> e.getHeadImage()).orElse(""));
        res.put((Object)"mobile", (Object)optional.map(e -> e.getMobilePhoneNumber()).orElse(""));
        return RestResponse.success((Object)res);
    }
}

