/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.mobile;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.member.util.SessionUtil;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.share.component.ShareChainComponent;
import com.wego168.share.domain.ShareChain;
import com.wego168.share.model.TeamUser;
import com.wego168.share.scheduler.ShareScheduler;
import com.wego168.share.service.ShareChainService;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.GuidGenerator;
import com.wego168.wechat.api.IWechatMiniProgramSession;
import com.wego168.wx.service.WxAppService;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/shareChain"})
public class ShareChainController
extends CrudController<ShareChain> {
    @Autowired
    private ShareChainService service;
    @Autowired
    private ShareChainComponent shareChainComponent;
    @Autowired
    private WxAppService wxAppService;
    @Autowired
    private IWechatMiniProgramSession wechatMiniProgramSession;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private ShareScheduler shareScheduler;

    public CrudService<ShareChain> getService() {
        return this.service;
    }

    @GetMapping(value={"/groupByLevel"})
    public RestResponse groupByLevel(HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Bootmap bootmap = this.service.groupByLevel(memberId);
        Optional<Bootmap> numOptional = Optional.ofNullable(bootmap);
        int levelNum1 = numOptional.map(e -> e.getInteger("levelNum1")).orElse(0);
        int levelNum2 = numOptional.map(e -> e.getInteger("levelNum2")).orElse(0);
        int levelNum3 = numOptional.map(e -> e.getInteger("levelNum3")).orElse(0);
        Bootmap response = new Bootmap();
        response.put((Object)"levelNum1", (Object)levelNum1);
        response.put((Object)"levelNum2", (Object)levelNum2);
        response.put((Object)"levelNum3", (Object)levelNum3);
        response.put((Object)"totalNum", (Object)(levelNum1 + levelNum2 + levelNum3));
        return RestResponse.success((Object)response);
    }

    @GetMapping(value={"/myPage"})
    public RestResponse myPage(HttpServletRequest request) {
        String memberId = request.getParameter("parentId");
        if (StringUtils.isBlank((CharSequence)memberId)) {
            memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        }
        Page page = this.buildPage(request);
        page.put((Object)"memberId", (Object)memberId);
        List<Bootmap> lists = this.service.pageMyMemberList(page);
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/groupByWithMember"})
    public RestResponse groupByWithMember(HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Bootmap bootmap = this.service.groupByWithMember(memberId);
        Optional<Bootmap> numOptional = Optional.ofNullable(bootmap);
        int teamNum = numOptional.map(e -> e.getInteger("teamNum")).orElse(0);
        int num = numOptional.map(e -> e.getInteger("num")).orElse(0);
        Bootmap response = new Bootmap();
        response.put((Object)"teamNum", (Object)teamNum);
        response.put((Object)"num", (Object)num);
        response.put((Object)"totalNum", (Object)(teamNum + num));
        return RestResponse.success((Object)response);
    }

    @GetMapping(value={"/myPageWithMember"})
    public RestResponse myPageWithMember(HttpServletRequest request) {
        String parentId = request.getParameter("parentId");
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Page page = this.buildPage(request);
        page.put((Object)"memberId", (Object)memberId);
        page.put((Object)"parentId", (Object)parentId);
        List<Bootmap> lists = this.service.pageMyMemberListWithMember(page);
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request) {
        String memberId = SessionUtil.getMemberIdIfAbsentToThrow();
        Page page = this.buildPage(request);
        page.put((Object)"parentId", (Object)memberId);
        List<TeamUser> lists = this.service.selectTeamUserPage(page);
        if (lists != null && lists.size() > 0) {
            LinkedList<String> idList = new LinkedList<String>();
            lists.forEach(e -> idList.add(e.getUserId()));
            Bootmap countmap = new Bootmap();
            List<Bootmap> countList = this.service.selectCountByParentList(idList);
            if (countList != null && countList.size() > 0) {
                countList.forEach(e -> {
                    int count = e.getInteger("count") == null ? 0 : e.getInteger("count");
                    countmap.put((Object)e.getString("id"), (Object)count);
                });
            }
            lists.forEach(e -> {
                if (countmap.containsKey((Object)e.getUserId())) {
                    e.setTeamCount(countmap.getInteger(e.getUserId()));
                }
            });
        }
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/testJoinShare"})
    public RestResponse testJoinShare(String openId, HttpServletRequest request, HttpServletResponse response) {
        SessionUtil.setOpenId((String)openId, (HttpServletRequest)request, (HttpServletResponse)response);
        return RestResponse.success((String)openId);
    }

    @PostMapping(value={"/testChain"})
    public RestResponse testChain(String memberId, String parentId, HttpServletRequest request) {
        String requestId = GuidGenerator.generate();
        return RestResponse.success((String)"\u6210\u529f");
    }
}

