/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.controller.mobile;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.Page;
import com.wego168.member.domain.MemberLevel;
import com.wego168.member.service.impl.MemberLevelService;
import com.wego168.member.util.SessionUtil;
import com.wego168.service.CrudService;
import com.wego168.share.domain.ShareLink;
import com.wego168.share.response.WxFansResponse;
import com.wego168.share.service.ShareLinkService;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.ParamUtils;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/shareLink"})
public class ShareLinkController
extends CrudController<ShareLink> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShareLinkController.class);
    @Autowired
    private ShareLinkService service;
    @Autowired
    private MemberLevelService memberLevelService;

    private void doListData(List<WxFansResponse> lists) {
        MemberLevel level = this.memberLevelService.selectByLevel(0, this.getAppId());
        if (lists != null && lists.size() > 0) {
            for (WxFansResponse fans : lists) {
                if (fans.getIdentity() == null) {
                    fans.setIdentity(0);
                }
                if (fans.getLevel() != null) continue;
                fans.setLevel(0);
                if (level == null) continue;
                fans.setLevelIconUrl(level.getIconUrl());
            }
        }
    }

    @GetMapping(value={"/pageFirstFans"})
    public RestResponse pageFirstFans(String parentId, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            parentId = SessionUtil.getOpenIdIfAbsentToThrow();
        }
        Page page = this.buildPage(request);
        page.put((Object)"openId", (Object)parentId);
        List<WxFansResponse> lists = this.service.selectFirstFansList(page);
        this.doListData(lists);
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/pageSecondFans"})
    public RestResponse pageSecondFans(HttpServletRequest request, HttpServletResponse response) {
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        Page page = this.buildPage(request);
        page.put((Object)"openId", (Object)openId);
        List<WxFansResponse> lists = this.service.selectSecondFansList(page);
        this.doListData(lists);
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/sumFansCount"})
    public RestResponse sumFansCount(HttpServletRequest request) {
        String parentId = ParamUtils.getString((ServletRequest)request, (String)"parentId");
        String appellation = ParamUtils.getString((ServletRequest)request, (String)"appellation");
        String openId = SessionUtil.getOpenIdIfAbsentToThrow();
        if (StringUtils.isBlank((CharSequence)parentId)) {
            parentId = openId;
        }
        int firstCount = this.service.selectFirstFansCount(parentId, appellation);
        int secondCount = this.service.selectSecondFansCount(openId, appellation);
        Bootmap response = new Bootmap();
        response.put((Object)"second", (Object)secondCount);
        response.put((Object)"first", (Object)firstCount);
        response.put((Object)"total", (Object)(firstCount + secondCount));
        return RestResponse.success((Object)response);
    }

    public CrudService<ShareLink> getService() {
        return this.service;
    }
}

