/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.filter;

import com.simple.mybatis.Bootmap;
import com.wego168.base.filter.FilterIgnores;
import com.wego168.member.util.SessionUtil;
import com.wego168.util.RequestUtil;
import com.wego168.util.StringUtil;
import com.wego168.web.util.GuidGenerator;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShareFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(ShareFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)resp;
        HttpServletRequest request = (HttpServletRequest)req;
        if (FilterIgnores.isStaticResource((HttpServletRequest)request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String programSessionId = request.getHeader("WPGSESSID");
        if (StringUtils.isNotBlank((CharSequence)programSessionId)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Bootmap bootParam = new Bootmap();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String key = (String)paramNames.nextElement();
            String value = request.getParameter(key);
            bootParam.put((Object)key, (Object)value);
        }
        String share = request.getParameter("shp");
        if (StringUtil.equals((String)share, (String)"1")) {
            String requestId = GuidGenerator.generate();
            String parentId = request.getParameter("shpr");
            String memberId = SessionUtil.getOpenId();
            logger.info("===>>> \u8fdb\u5165\u5206\u4eab\u7684filter[ShareFilter]\uff0c\u5206\u4eab\u4eba[memberId]\uff1a{}\uff0c\u5206\u4eab\u4eba\u4e0a\u7ebf[parentId]\uff1a{}\uff0crequestId\uff1a{}\uff0c\u5206\u4eab\u94fe\u63a5[url]\uff1a{} ", new Object[]{memberId, parentId, requestId, RequestUtil.getCurrentUrl((HttpServletRequest)request)});
            if (StringUtil.isNotBlank((String)memberId) && StringUtil.isNotBlank((String)parentId) && !memberId.equals(parentId)) {
                this.saveShareChain(memberId, parentId, bootParam);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    protected abstract void saveShareChain(String var1, String var2, Bootmap var3);
}

