/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.scheduler;

import com.wego168.share.component.BonusWithdrawComponent;
import com.wego168.share.domain.BonusWithdraw;
import com.wego168.share.enums.BonusWithdrawStatus;
import com.wego168.share.service.BonusWithdrawService;
import com.wego168.util.IntegerUtil;
import com.wego168.wx.enums.WxAppServiceTypeEnum;
import com.wego168.wxpay.constant.JoinTransferStatusCode;
import com.wego168.wxpay.domain.WxpayConfig;
import com.wego168.wxpay.impl.JoinTransferHelper;
import com.wego168.wxpay.model.response.JoinTransferResponse;
import com.wego168.wxpay.service.WxpayConfigService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class BonusWithdrawScheduler {
    private static final Logger logger = LoggerFactory.getLogger(BonusWithdrawScheduler.class);
    @Autowired
    private BonusWithdrawService bonusWithdrawService;
    @Autowired
    private WxpayConfigService wxpayConfigService;
    @Autowired
    private JoinTransferHelper joinTransferHelper;
    @Autowired
    private BonusWithdrawComponent bonusWithdrawComponent;

    @Scheduled(fixedRate=120000L)
    public void doTransfer() {
        List<BonusWithdraw> lists = this.bonusWithdrawService.selectApplyListForTransfer();
        if (lists != null && lists.size() > 0) {
            for (BonusWithdraw withdraw : lists) {
                this.bonusWithdrawComponent.joinTransfer(withdraw);
            }
        }
    }

    @Scheduled(fixedRate=300000L)
    public void queryTransfer() {
        List<BonusWithdraw> list = this.bonusWithdrawService.selectPayingListForTransfer();
        if (list == null || list.size() == 0) {
            return;
        }
        for (BonusWithdraw withdraw : list) {
            String tradeNo;
            String mchKey;
            String transferMchId;
            String appId = withdraw.getAppId();
            WxpayConfig payConfig = this.wxpayConfigService.selectByAppIdAndMerchant(appId, transferMchId = withdraw.getTransferMchId(), WxAppServiceTypeEnum.SERVICE.value());
            if (payConfig == null) continue;
            String mchId = payConfig.getMchId();
            JoinTransferResponse transferResponse = this.joinTransferHelper.querySinglePay(mchId, mchKey = payConfig.getMchKey(), tradeNo = withdraw.getTradeId());
            if (IntegerUtil.equals((Integer)transferResponse.getStatus(), (Integer)JoinTransferStatusCode.SUCCESS.getCode())) {
                withdraw.setStatus(BonusWithdrawStatus.SUCCESS.id);
            } else if (transferResponse.getStatus().intValue() != JoinTransferStatusCode.ONGOING.getCode()) {
                withdraw.setTransferErrorDesc(transferResponse.getErrorDesc());
                withdraw.setStatus(BonusWithdrawStatus.FAIL.id);
                logger.error("\u8f6c\u8d26\u5931\u8d25, bonusWithdrawId:{}, tradeNo:{},  errorDesc:{}", new Object[]{withdraw.getId(), withdraw.getTradeId(), transferResponse.getErrorDesc()});
            }
            if (withdraw.getStatus() != BonusWithdrawStatus.SUCCESS.id && withdraw.getStatus() != BonusWithdrawStatus.FAIL.id) continue;
            withdraw.setTransferNotifyTime(new Date());
            this.bonusWithdrawService.finishAfterTransfer(withdraw);
        }
    }
}

