/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.scheduler;

import com.wego168.member.service.IMemberAccountService;
import com.wego168.member.service.impl.MemberService;
import com.wego168.share.handler.ShareChainHandler;
import com.wego168.share.model.ShareParam;
import com.wego168.share.service.ShareChainService;
import com.wego168.share.service.ShareLinkService;
import com.wego168.util.InterfaceDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ShareScheduler {
    private static final Logger logger = LoggerFactory.getLogger(ShareScheduler.class);
    @Autowired
    private ShareChainService shareChainService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private IMemberAccountService memberAccountService;
    @Autowired
    private ShareLinkService shareLinkService;

    @Async
    public void saveShareChain(ShareParam param) {
        logger.error("\u5f02\u6b65\u6267\u884c\u5206\u4eab\u94fe\u7684\u4fdd\u5b58\u64cd\u4f5c\uff0c\u5206\u4eab\u4eba[memberId]\uff1a{}\uff0c\u5206\u4eab\u4eba\u4e0a\u7ebf[parentId]\uff1a{}", (Object)param.getOpenId(), (Object)param.getParentId());
        int rows = this.shareChainService.saveShareChainByShareLink(param.getOpenId(), param.getParentId(), param.getAppId());
        param.setChain(rows > 0);
        InterfaceDispatcher.builder().collect(ShareChainHandler.class).forEach(e -> e.doAfterShare(param));
    }
}

