/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.member.service.impl.MemberLevelService;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.share.component.DistributeWxMsgTemplateTask;
import com.wego168.share.config.ShareConfig;
import com.wego168.share.domain.BonusFlow;
import com.wego168.share.enums.BonusFlowStatusEnum;
import com.wego168.share.enums.BonusFlowTypeEnum;
import com.wego168.share.model.OrderBonus;
import com.wego168.share.persistence.BonusFlowMapper;
import com.wego168.share.response.BonusFlowResponse;
import com.wego168.share.service.BonusService;
import com.wego168.share.service.DistributeConfigService;
import com.wego168.share.service.ShareChainService;
import com.wego168.share.service.ShareConfigService;
import com.wego168.web.util.GuidGenerator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BonusFlowService
extends BaseService<BonusFlow> {
    static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private BonusFlowMapper mapper;
    @Autowired
    private DistributeConfigService distributeConfigService;
    @Autowired
    private ShareChainService shareChainService;
    @Autowired
    private BonusService bonusService;
    @Autowired
    private MemberLevelService memberLevelService;
    @Autowired
    private ShareConfigService shareConfigService;
    @Autowired
    private DistributeWxMsgTemplateTask distributeWxMsgTemplateTask;
    @Autowired
    private ShareConfig shareConfig;

    public CrudMapper<BonusFlow> getMapper() {
        return this.mapper;
    }

    public List<BonusFlowResponse> pageFlows(Page page) {
        return this.mapper.pageFlows(page);
    }

    public int selectOrderProfit(String orderId, Integer level) {
        Integer amount;
        JpaCriteria criteria = JpaCriteria.builder().select("sum(amount)").eq("type", (Object)1).eq("orderId", (Object)orderId);
        if (level != null) {
            criteria.eq("level", (Object)level);
        }
        return (amount = (Integer)super.select(criteria, Integer.class)) == null ? 0 : amount;
    }

    public List<BonusFlow> selectListByOrderId(String orderId) {
        JpaCriteria criteria = JpaCriteria.builder().eq("orderId", (Object)orderId);
        return this.mapper.selectList(criteria);
    }

    public BonusFlow selectFirstOrderBonus(String orderId, int level) {
        JpaCriteria criteria = JpaCriteria.builder().eq("orderId", (Object)orderId).eq("level", (Object)level).eq("type", (Object)BonusFlowTypeEnum.ORDER.id()).orderBy("createTime asc");
        List flowList = this.mapper.selectList(criteria);
        if (flowList != null && flowList.size() > 0) {
            return (BonusFlow)((Object)flowList.get(0));
        }
        return null;
    }

    public List<BonusFlow> page(Page page) {
        return this.mapper.page(page);
    }

    public List<Bootmap> pageForAdmin(Page page) {
        return this.mapper.pageForAdmin(page);
    }

    public List<BonusFlow> myPage(Page page) {
        return this.mapper.myPage(page);
    }

    public BonusFlow buildByOrderBonus(OrderBonus orderBonus) {
        int level = orderBonus.getLevel();
        BonusFlow flow = new BonusFlow();
        flow.setId(GuidGenerator.generate());
        flow.setCreateTime(new Date());
        flow.setAppId(orderBonus.getAppId());
        flow.setStoreId(orderBonus.getStoreId());
        flow.setIsDeleted(false);
        flow.setOrderAmount(orderBonus.getAmount());
        flow.setAmount((int)((double)orderBonus.getAmount() * this.distributeConfigService.getShareRate(orderBonus.getAppId(), level)));
        flow.setOrderId(orderBonus.getOrderId());
        flow.setType(1);
        flow.setLevel(level);
        flow.setMemberId(orderBonus.getMemberId());
        flow.setOrderMemberId(orderBonus.getOrderMemberId());
        flow.setStatus(BonusFlowStatusEnum.NEW.id());
        flow.setSourceType(orderBonus.getSourceType());
        String describe = orderBonus.getDetail();
        if (StringUtils.isNotBlank((CharSequence)describe) && describe.length() > 256) {
            flow.setDetail(describe.substring(0, 256));
        } else {
            flow.setDetail(describe);
        }
        return flow;
    }

    public BonusFlow buildForOrder(String orderId, String appId, String storeId, String memberId, int amount, String detail) {
        BonusFlow flow = new BonusFlow();
        flow.setId(GuidGenerator.generate());
        flow.setCreateTime(new Date());
        flow.setAppId(appId);
        flow.setStoreId(storeId);
        flow.setIsDeleted(false);
        flow.setOrderAmount(0);
        flow.setAmount(amount);
        flow.setOrderId(orderId);
        flow.setType(BonusFlowTypeEnum.PAY.id());
        flow.setLevel(0);
        flow.setMemberId(memberId);
        flow.setOrderMemberId(null);
        flow.setStatus(BonusFlowStatusEnum.SUCCESS.id());
        flow.setDetail(detail);
        return flow;
    }

    private BonusFlow initBonusFlow(String memberId, String orderMemberId, int level) {
        BonusFlow flow = new BonusFlow();
        flow.setMemberId(memberId);
        flow.setOrderMemberId(orderMemberId);
        flow.setLevel(level);
        return flow;
    }

    @Transactional
    public int finish(List<BonusFlow> flowList) {
        int rows = 0;
        if (flowList != null && flowList.size() > 0) {
            LinkedList<BonusFlow> bonusFlowList = new LinkedList<BonusFlow>();
            for (BonusFlow flow : flowList) {
                if (flow.getStatus().intValue() != BonusFlowStatusEnum.NEW.id()) continue;
                bonusFlowList.add(flow);
            }
            this.bonusService.produceByFlowList(bonusFlowList);
            for (BonusFlow flow : bonusFlowList) {
                flow.setStatus(BonusFlowStatusEnum.SUCCESS.id());
                flow.setAwardTime(new Date());
                rows += this.mapper.update((Object)flow);
            }
            if (bonusFlowList.size() > 0) {
                this.distributeWxMsgTemplateTask.sendFinishBonusMsg(bonusFlowList);
            }
        }
        return rows;
    }

    @Transactional
    public void cancelByOrderId(String orderId) {
        LinkedList<BonusFlow> cancelFlowList = new LinkedList<BonusFlow>();
        JpaCriteria criteria = JpaCriteria.builder().eq("orderId", (Object)orderId);
        List lists = this.mapper.selectList(criteria);
        if (lists != null && lists.size() > 0) {
            for (BonusFlow flow : lists) {
                if (flow.getStatus().intValue() == BonusFlowStatusEnum.SUCCESS.id()) {
                    cancelFlowList.add(flow);
                }
                flow.setStatus(BonusFlowStatusEnum.CANCEL.id());
                this.mapper.update((Object)flow);
            }
        }
        if (cancelFlowList.size() > 0) {
            this.bonusService.rollBackByFlowList(cancelFlowList);
        }
    }

    public List<BonusFlow> selectNewList(String orderId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("status", (Object)BonusFlowStatusEnum.NEW.id()).eq("type", (Object)BonusFlowTypeEnum.ORDER.id()).eq("orderId", (Object)orderId);
        return this.mapper.selectList(jpaCriteria);
    }

    public List<BonusFlow> selectByOrderId(String orderId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("orderId", (Object)orderId);
        return this.mapper.selectList(jpaCriteria);
    }

    public Bootmap groupByStatus(String memberId) {
        return this.mapper.groupByStatus(memberId);
    }

    public Bootmap groupByLevel(String memberId) {
        return this.mapper.groupByLevel(memberId);
    }

    public int sumTodayAmount(String memberId) {
        String date = FORMAT.format(new Date());
        return this.sumAmountByDate(memberId, date);
    }

    public int sumAmountByDate(String memberId, String date) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(FORMAT.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        calendar.set(6, calendar.get(6) + 1);
        String nextDate = FORMAT.format(calendar.getTime());
        JpaCriteria jpaCriteria = JpaCriteria.builder().select("sum(amount) amount").eq("memberId", (Object)memberId).eq("type", (Object)1).eq("isDeleted", (Object)false).gt("awardTime", (Object)date).lt("awardTime", (Object)nextDate);
        Integer rows = (Integer)super.select(jpaCriteria, Integer.class);
        return rows == null ? 0 : rows;
    }

    public Bootmap sumTeamAmount(String memberId) {
        Calendar calendar = Calendar.getInstance();
        String startDate = FORMAT.format(calendar.getTime());
        calendar.set(6, calendar.get(6) + 1);
        String endDate = FORMAT.format(calendar.getTime());
        return this.mapper.sumTeamAmount(memberId, startDate, endDate);
    }

    public Integer sumTotalBonusByType(String memberId, int type) {
        Integer amount = this.mapper.sumTotalBonusByType(memberId, type);
        return amount == null ? 0 : amount;
    }

    public List<Bootmap> sumTotalBonusByTypeAndParentIdList(List<String> list, int type) {
        return this.mapper.sumTotalBonusByTypeAndParentIdList(list, type);
    }

    public List<Bootmap> sumBlanceAndFrozenAmountByMemberIdList(List<String> list) {
        return this.mapper.sumBlanceAndFrozenAmountByMemberIdList(list);
    }

    public List<Bootmap> sumPersonAndTeamProfitByOrderIdList(List<String> list) {
        return this.mapper.sumPersonAndTeamProfitByOrderIdList(list);
    }

    public List<Bootmap> sumPersonAndTeamProfitByMemberIdList(List<String> list) {
        return this.mapper.sumPersonAndTeamProfitByMemberIdList(list);
    }

    public void doInitializtion() {
        Date now = new Date();
        List<Bootmap> lists = this.mapper.selectListToInitializtion();
        LinkedList<BonusFlow> flowList = new LinkedList<BonusFlow>();
        String parentId = "b71d230a33a34b5ba3f7b59f21335452";
        for (Bootmap boot : lists) {
            String name = boot.getString("name");
            String memberId = boot.getString("memberId");
            String appId = boot.getString("appId");
            String storeId = boot.getString("storeId");
            String orderId = boot.getString("orderId");
            Integer chainLevel = boot.getInteger("chainLevel");
            Integer memberLevel = boot.getInteger("memberLevel");
            String orderParentId = parentId;
            double rate = 0.2;
            int level = 1;
            if (memberLevel != null) {
                level = 2;
                rate = 0.08;
                orderParentId = memberId;
            }
            int amount = boot.getInteger("amount");
            int orderAmount = boot.getInteger("totalAmount");
            Date createTime = boot.getDate("createTime");
            OrderBonus orderBonus = new OrderBonus();
            orderBonus.setMemberId(parentId);
            orderBonus.setAmount(orderAmount);
            orderBonus.setLevel(level);
            orderBonus.setOrderMemberId(memberId);
            orderBonus.setAppId(appId);
            orderBonus.setStoreId(storeId);
            orderBonus.setOrderId(orderId);
            orderBonus.setDetail(name);
            BonusFlow flow = this.buildByOrderBonus(orderBonus);
            flow.setCreateTime(createTime);
            flow.setAmount((int)((double)orderAmount * rate));
            flow.setRate(rate);
            flow.setOrderParentId(orderParentId);
            flow.setUpdateTime(now);
            flowList.add(flow);
        }
        this.mapper.insertBatch(flowList);
    }
}

