/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.share.service;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.wego168.persistence.CrudMapper;
import com.wego168.service.BaseService;
import com.wego168.share.domain.Bonus;
import com.wego168.share.domain.BonusFlow;
import com.wego168.share.enums.BonusFlowStatusEnum;
import com.wego168.share.persistence.BonusMapper;
import com.wego168.share.service.BonusFlowService;
import com.wego168.util.Shift;
import com.wego168.web.util.GuidGenerator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BonusService
extends BaseService<Bonus> {
    private static final boolean STORE_CONSUME = false;
    @Autowired
    private BonusMapper mapper;
    @Autowired
    private BonusFlowService bonusFlowService;

    public CrudMapper<Bonus> getMapper() {
        return this.mapper;
    }

    public Bonus buildBonus(BonusFlow flow) {
        Bonus bonus = new Bonus();
        bonus.setId(GuidGenerator.generate());
        bonus.setCreateTime(new Date());
        bonus.setAppId(flow.getAppId());
        bonus.setStoreId(flow.getStoreId());
        bonus.setMemberId(flow.getMemberId());
        bonus.setIsDeleted(false);
        bonus.setAmount(flow.getAmount());
        bonus.setTotalAmount(flow.getAmount());
        return bonus;
    }

    @Transactional
    public void produceByFlowList(List<BonusFlow> flowList) {
        if (flowList != null && flowList.size() > 0) {
            HashMap<String, Bonus> insertBonusMap = new HashMap<String, Bonus>();
            HashMap<String, Bonus> updateBonusMap = new HashMap<String, Bonus>();
            for (BonusFlow flow : flowList) {
                String[] storeIds;
                String memberId = flow.getMemberId();
                String storeId = flow.getStoreId();
                int amount = flow.getAmount();
                String[] stringArray = storeIds = new String[]{"0", storeId};
                int n = storeIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String stid = stringArray[n2];
                    String key2 = String.valueOf(stid) + "_" + memberId;
                    if (this.addBonusToMapIfContains(key2, amount, insertBonusMap)) {
                        flow.setBalanceAmount(((Bonus)((Object)insertBonusMap.get(key2))).getAmount());
                    } else if (this.addBonusToMapIfContains(key2, amount, updateBonusMap)) {
                        flow.setBalanceAmount(((Bonus)((Object)updateBonusMap.get(key2))).getAmount());
                    } else {
                        Bonus bonus = this.selectByStoreMember(stid, memberId);
                        if (bonus == null) {
                            bonus = this.buildBonus(flow);
                            bonus.setStoreId(stid);
                            insertBonusMap.put(key2, bonus);
                        } else {
                            bonus.setAmount(bonus.getAmount() + amount);
                            bonus.setTotalAmount(bonus.getTotalAmount() + amount);
                            updateBonusMap.put(key2, bonus);
                        }
                        flow.setBalanceAmount(bonus.getAmount());
                    }
                    ++n2;
                }
            }
            insertBonusMap.forEach((key, value) -> super.insert((Object)value));
            updateBonusMap.forEach((key, value) -> {
                value.setUpdateTime(new Date());
                super.update((Object)value);
            });
        }
    }

    @Transactional
    public void rollBackByFlowList(List<BonusFlow> flowList) {
        if (flowList != null && flowList.size() > 0) {
            int amount;
            int total = 0;
            String memberId = flowList.get(0).getMemberId();
            HashMap<String, Integer> storeAmountMap = new HashMap<String, Integer>();
            for (BonusFlow flow : flowList) {
                amount = -flow.getAmount().intValue();
                total += amount;
                String storeId = flow.getStoreId();
                if (!storeAmountMap.containsKey(storeId)) {
                    storeAmountMap.put(storeId, 0);
                }
                int storeAmount = (Integer)storeAmountMap.get(storeId);
                storeAmountMap.put(storeId, amount + storeAmount);
            }
            for (String storeId : storeAmountMap.keySet()) {
                amount = (Integer)storeAmountMap.get(storeId);
                this.mapper.updateAddAmount(amount, storeId, memberId);
            }
            this.mapper.updateAddAmount(total, "0", memberId);
        }
    }

    @Transactional
    public void consumeByFlowList(List<BonusFlow> flowList) {
        if (flowList.size() > 0) {
            this.bonusFlowService.insertBatch(flowList);
            BonusFlow bonusFlow = flowList.get(0);
            List<Bonus> bonusList = this.selectList(bonusFlow.getMemberId());
            HashMap<String, Bonus> bonusMap = new HashMap<String, Bonus>();
            for (Bonus bonus : bonusList) {
                bonusMap.put(bonus.getStoreId(), bonus);
            }
            HashSet<String> storeSet = new HashSet<String>();
            Bonus totalBonus = (Bonus)((Object)bonusMap.get("0"));
            for (BonusFlow flow : flowList) {
                String storeId = flow.getStoreId();
                int flowAmount = -flow.getAmount().intValue();
                Bonus bonus = (Bonus)((Object)bonusMap.get(storeId));
                Shift.throwsIfNull((Object)((Object)bonus), (String)"\u94b1\u5305\u652f\u4ed8\u5931\u8d25\uff1a\u95e8\u5e97\u6682\u65e0\u6536\u76ca");
                int bonusAmount = bonus.getAmount();
                Shift.throwsIfInvalid((bonusAmount < flowAmount ? 1 : 0) != 0, (String)"\u94b1\u5305\u652f\u4ed8\u5931\u8d25\uff1a\u95e8\u5e97\u6536\u76ca\u4f59\u989d\u4e0d\u8db3");
                flowAmount = this.reduce(bonus, totalBonus, storeSet, flowAmount);
                Shift.throwsIfInvalid((flowAmount > 0 ? 1 : 0) != 0, (String)"\u94b1\u5305\u652f\u4ed8\u5931\u8d25\uff1a\u4f59\u989d\u4e0d\u8db3");
            }
            for (String stid : storeSet) {
                this.mapper.update(bonusMap.get(stid));
            }
            this.mapper.update(bonusMap.get("0"));
        }
    }

    private int reduce(Bonus bonus, Bonus totalBonus, Set<String> storeSet, int flowAmount) {
        int bonusAmount = bonus.getAmount();
        String storeId = bonus.getStoreId();
        if (bonusAmount > 0 && flowAmount > 0) {
            int tplAmount = 0;
            tplAmount = bonusAmount >= flowAmount ? flowAmount : bonusAmount;
            bonus.setAmount(bonus.getAmount() - tplAmount);
            totalBonus.setAmount(totalBonus.getAmount() - tplAmount);
            if (!storeSet.contains(storeId)) {
                storeSet.add(storeId);
            }
            flowAmount -= tplAmount;
        }
        return flowAmount;
    }

    public boolean addBonusToMapIfContains(String key, int amount, Map<String, Bonus> bonusMap) {
        if (bonusMap.containsKey(key)) {
            Bonus bs = bonusMap.get(key);
            bs.setAmount(bs.getAmount() + amount);
            bonusMap.put(key, bs);
            return true;
        }
        return false;
    }

    public int myRanking(Integer myAmount) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().select("count(1)").gt("totalAmount", (Object)myAmount).eq("storeId", (Object)"0").eq("isDeleted", (Object)false);
        int result = (Integer)super.select(jpaCriteria, Integer.class);
        return result + 1;
    }

    public Bonus selectByStoreMember(String storeId, String memberId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("storeId", (Object)storeId).eq("memberId", (Object)memberId).eq("isDeleted", (Object)false);
        return (Bonus)((Object)this.mapper.select(jpaCriteria));
    }

    public Bonus selectByMember(String memberId) {
        return this.selectByStoreMember("0", memberId);
    }

    public Bootmap selectListByDays(List<Map<String, String>> dayList, String memberId) {
        return this.mapper.selectListByDays(dayList, memberId);
    }

    public List<Bonus> selectListForWithdraw(String memberId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("memberId", (Object)memberId).ne("storeId", (Object)"0").orderBy("amount desc");
        return this.mapper.selectList(jpaCriteria);
    }

    public List<Bonus> selectList(String memberId) {
        JpaCriteria jpaCriteria = JpaCriteria.builder().eq("memberId", (Object)memberId).orderBy("amount desc");
        return this.mapper.selectList(jpaCriteria);
    }

    public int updateAddAmount(int amount, String storeId, String memberId) {
        return this.mapper.updateAddAmount(amount, storeId, memberId);
    }

    @Transactional
    public void withdrawRollBack(String orderId) {
        List<BonusFlow> flowList = this.bonusFlowService.selectByOrderId(orderId);
        if (flowList != null && flowList.size() > 0) {
            int amount;
            int total = 0;
            String memberId = flowList.get(0).getMemberId();
            HashMap<String, Integer> storeAmountMap = new HashMap<String, Integer>();
            for (BonusFlow flow : flowList) {
                amount = -flow.getAmount().intValue();
                total += amount;
                storeAmountMap.put(flow.getStoreId(), amount);
                flow.setIsDeleted(true);
                flow.setStatus(BonusFlowStatusEnum.CANCEL.id());
                this.bonusFlowService.update((Object)flow);
            }
            for (String storeId : storeAmountMap.keySet()) {
                amount = (Integer)storeAmountMap.get(storeId);
                this.mapper.updateAddAmount(amount, storeId, memberId);
            }
            this.mapper.updateAddAmount(total, "0", memberId);
        }
    }
}

